/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.play;

import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.weaving.BindClassMeta;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.play.PlayInvoker;
import org.glowroot.agent.plugin.play.Routes;

public class Play2xAspect {
    private static final BooleanProperty useAltTransactionNaming = Agent.getConfigService("play").getBooleanProperty("useAltTransactionNaming");

    private static String getAltTransactionName(String controller, String methodName) {
        int index = controller.lastIndexOf(46);
        if (index == -1) {
            return controller + "#" + methodName;
        }
        return controller.substring(index + 1) + "#" + methodName;
    }

    @Pointcut(className="play.core.Router$HandlerInvoker", methodName="call", methodParameterTypes={"scala.Function0", "play.core.Router$HandlerDef"})
    public static class OldHandlerInvokerAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindParameter Object action, @BindParameter HandlerDef handlerDef, @BindClassMeta PlayInvoker invoker) {
            String controller = handlerDef.controller();
            String method = handlerDef.method();
            String path = invoker.path(handlerDef);
            if (useAltTransactionNaming.value() || path == null) {
                if (controller != null && method != null) {
                    context.setTransactionName(Play2xAspect.getAltTransactionName(controller, method), -100);
                }
            } else {
                path = Routes.simplifiedRoute(path);
                context.setTransactionName(path, -100);
            }
        }
    }

    @Shim(value={"play.core.Router$HandlerDef"})
    public static interface HandlerDef {
        @Nullable
        public String controller();

        @Nullable
        public String method();
    }

    @Pointcut(className="views.html.*", methodName="apply", methodParameterTypes={".."}, timerName="play render", nestingGroup="play-render")
    public static class RenderAdvice {
        private static final TimerName timerName = Agent.getTimerName(RenderAdvice.class);

        @OnBefore
        public static TraceEntry onBefore(ThreadContext context, @BindReceiver Object view) {
            String viewName = view.getClass().getSimpleName();
            viewName = viewName.substring(0, viewName.length() - 1);
            return context.startTraceEntry(MessageSupplier.create("play render: {}", viewName), timerName);
        }

        @OnReturn
        public static void onReturn(@BindTraveler TraceEntry traceEntry) {
            traceEntry.end();
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler TraceEntry traceEntry) {
            traceEntry.endWithError(t);
        }
    }

    @Pointcut(className="play.core.routing.TaggingInvoker|play.core.Router$Routes$TaggingInvoker", methodName="call", methodParameterTypes={"scala.Function0"})
    public static class HandlerInvokerAdvice {
        @OnBefore
        public static void onBefore(ThreadContext context, @BindReceiver TaggingInvoker taggingInvoker) {
            ScalaMap tags = taggingInvoker.glowroot$cachedHandlerTags();
            if (tags == null) {
                return;
            }
            if (useAltTransactionNaming.value()) {
                ScalaOption controllerOption = tags.glowroot$get("ROUTE_CONTROLLER");
                ScalaOption methodOption = tags.glowroot$get("ROUTE_ACTION_METHOD");
                if (controllerOption != null && controllerOption.isDefined() && methodOption != null && methodOption.isDefined()) {
                    String controller = HandlerInvokerAdvice.toString(controllerOption.get());
                    String transactionName = Play2xAspect.getAltTransactionName(controller, HandlerInvokerAdvice.toString(methodOption.get()));
                    context.setTransactionName(transactionName, -100);
                }
            } else {
                ScalaOption option = tags.glowroot$get("ROUTE_PATTERN");
                if (option != null && option.isDefined()) {
                    String route = HandlerInvokerAdvice.toString(option.get());
                    route = Routes.simplifiedRoute(route);
                    context.setTransactionName(route, -100);
                }
            }
        }

        private static String toString(Object obj) {
            String str = obj.toString();
            return str == null ? "" : str;
        }
    }

    @Shim(value={"scala.Option"})
    public static interface ScalaOption {
        public boolean isDefined();

        public Object get();
    }

    @Shim(value={"scala.collection.immutable.Map"})
    public static interface ScalaMap {
        @Shim(value={"scala.Option get(java.lang.Object)"})
        @Nullable
        public ScalaOption glowroot$get(Object var1);
    }

    @Shim(value={"play.core.routing.TaggingInvoker", "play.core.Router$Routes$TaggingInvoker"})
    public static interface TaggingInvoker {
        @Shim(value={"scala.collection.immutable.Map cachedHandlerTags()"})
        @Nullable
        public ScalaMap glowroot$cachedHandlerTags();
    }
}

