/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.mongodb;

import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.mongodb.MongoCursorAspect;

public class MongoIterableAspect {

    @Pointcut(className="com.mongodb.client.MongoIterable", subTypeRestriction="com.mongodb.client.FindIterable|com.mongodb.client.AggregateIterable", methodName="iterator", methodParameterTypes={}, methodReturnType="com.mongodb.client.MongoCursor", nestingGroup="mongodb")
    public static class IteratorAdvice {
        @OnReturn
        public static void onReturn(@BindReturn @Nullable MongoCursorAspect.MongoCursorMixin mongoCursor, @BindReceiver MongoIterableMixin mongoIterable) {
            if (mongoCursor != null) {
                mongoCursor.glowroot$setQueryEntry(mongoIterable.glowroot$getQueryEntry());
            }
        }
    }

    @Pointcut(className="com.mongodb.client.MongoIterable", subTypeRestriction="com.mongodb.client.FindIterable|com.mongodb.client.AggregateIterable", methodName="first", methodParameterTypes={}, nestingGroup="mongodb")
    public static class FirstAdvice {
        @OnBefore
        @Nullable
        public static Timer onBefore(@BindReceiver MongoIterableMixin mongoIterable) {
            QueryEntry queryEntry = mongoIterable.glowroot$getQueryEntry();
            return queryEntry == null ? null : queryEntry.extend();
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable Object document, @BindReceiver MongoIterableMixin mongoIterable) {
            QueryEntry queryEntry = mongoIterable.glowroot$getQueryEntry();
            if (queryEntry == null) {
                return;
            }
            if (document != null) {
                queryEntry.incrementCurrRow();
            } else {
                queryEntry.rowNavigationAttempted();
            }
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Pointcut(className="com.mongodb.client.FindIterable", methodName="*", methodParameterTypes={".."}, methodReturnType="com.mongodb.client.FindIterable")
    public static class MapAdvice {
        @OnReturn
        public static void onReturn(@BindReturn @Nullable MongoIterableMixin newMongoIterable, @BindReceiver MongoIterableMixin mongoIterable) {
            if (newMongoIterable != null) {
                newMongoIterable.glowroot$setQueryEntry(mongoIterable.glowroot$getQueryEntry());
            }
        }
    }

    public static interface MongoIterableMixin {
        @Nullable
        public QueryEntry glowroot$getQueryEntry();

        public void glowroot$setQueryEntry(@Nullable QueryEntry var1);
    }

    @Mixin(value={"com.mongodb.client.FindIterable", "com.mongodb.client.AggregateIterable"})
    public static class MongoIterableImpl
    implements MongoIterableMixin {
        @Nullable
        private transient QueryEntry glowroot$queryEntry;

        @Override
        @Nullable
        public QueryEntry glowroot$getQueryEntry() {
            return this.glowroot$queryEntry;
        }

        @Override
        public void glowroot$setQueryEntry(@Nullable QueryEntry queryEntry) {
            this.glowroot$queryEntry = queryEntry;
        }
    }
}

