/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import org.glowroot.agent.model.SyncQueryData;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class QueryDataMap {
    private static final Object CHAINED_KEY = new Object();
    private final String type;
    private int capacity = 4;
    @Nullable
    private Object[] table = new Object[this.capacity << 1];
    private int size = 0;
    private int threshold = 3;

    public QueryDataMap(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Nullable
    public SyncQueryData get(String key) {
        int bucket = (key.hashCode() & this.capacity - 1) << 1;
        Object keyAtBucket = this.table[bucket];
        Object value = this.table[bucket + 1];
        if (key.equals(keyAtBucket)) {
            return (SyncQueryData)value;
        }
        if (keyAtBucket == CHAINED_KEY) {
            return QueryDataMap.getChained(key, Preconditions.checkNotNull(value));
        }
        return null;
    }

    public void put(String key, SyncQueryData value) {
        if (this.size++ > this.threshold) {
            this.rehash();
        }
        this.putWithoutRehashCheck(key, value);
    }

    private void putWithoutRehashCheck(Object key, @Nullable Object value) {
        int bucket = (key.hashCode() & this.capacity - 1) << 1;
        Object keyAtBucket = this.table[bucket];
        if (keyAtBucket == null) {
            this.table[bucket] = key;
            this.table[bucket + 1] = value;
            return;
        }
        this.putChained(key, value, bucket, keyAtBucket);
    }

    private void putChained(Object key, @Nullable Object value, int bucket, Object keyAtBucket) {
        if (keyAtBucket == CHAINED_KEY) {
            Object[] chain = (Object[])Preconditions.checkNotNull(this.table[bucket + 1]);
            int chainLength = chain.length;
            for (int i = 0; i < chainLength; i += 2) {
                if (chain[i] != null) continue;
                chain[i] = key;
                chain[i + 1] = value;
                return;
            }
            Object[] newChain = new Object[chainLength << 1];
            System.arraycopy(chain, 0, newChain, 0, chainLength);
            newChain[chainLength] = key;
            newChain[chainLength + 1] = value;
            this.table[bucket + 1] = newChain;
            return;
        }
        Object[] chain = new Object[]{keyAtBucket, this.table[bucket + 1], key, value};
        this.table[bucket] = CHAINED_KEY;
        this.table[bucket + 1] = chain;
    }

    private void rehash() {
        Object[] existingTable = this.table;
        this.capacity <<= 1;
        this.threshold <<= 1;
        this.table = new Object[this.capacity << 1];
        for (int i = 0; i < existingTable.length; i += 2) {
            Object key = existingTable[i];
            if (key == null) continue;
            if (key == CHAINED_KEY) {
                Object[] values = (Object[])Preconditions.checkNotNull(existingTable[i + 1]);
                this.putChainedValues(values);
                continue;
            }
            this.putWithoutRehashCheck(key, existingTable[i + 1]);
        }
    }

    private void putChainedValues(Object[] values) {
        Object chainedKey;
        for (int j = 0; j < values.length && (chainedKey = values[j]) != null; j += 2) {
            this.putWithoutRehashCheck(chainedKey, values[j + 1]);
        }
    }

    @Nullable
    private static SyncQueryData getChained(String key, Object value) {
        Object[] chainedTable = (Object[])value;
        for (int i = 0; i < chainedTable.length; i += 2) {
            if (!key.equals(chainedTable[i])) continue;
            return (SyncQueryData)chainedTable[i + 1];
        }
        return null;
    }
}

