/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.plugin.api.util.Optional;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class DetailMapWriter {
    private static final Logger logger = LoggerFactory.getLogger(DetailMapWriter.class);
    private static final int MESSAGE_CHAR_LIMIT = Integer.getInteger("glowroot.message.char.limit", 100000);

    private DetailMapWriter() {
    }

    public static List<TraceOuterClass.Trace.DetailEntry> toProto(Map<String, ?> detail) {
        return DetailMapWriter.mapToProto(detail);
    }

    private static TraceOuterClass.Trace.DetailEntry createDetailEntry(String name, @Nullable Object value) {
        if (value instanceof Map) {
            return TraceOuterClass.Trace.DetailEntry.newBuilder().setName(name).addAllChildEntry(DetailMapWriter.mapToProto((Map)value)).build();
        }
        if (value instanceof List) {
            return TraceOuterClass.Trace.DetailEntry.newBuilder().setName(name).addAllValue(DetailMapWriter.listToProto((List)value)).build();
        }
        return TraceOuterClass.Trace.DetailEntry.newBuilder().setName(name).addAllValue(DetailMapWriter.singleObjectToProto(value)).build();
    }

    private static List<TraceOuterClass.Trace.DetailEntry> mapToProto(Map<?, ?> map) {
        ArrayList<TraceOuterClass.Trace.DetailEntry> entries = Lists.newArrayListWithCapacity(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key == null) {
                logger.warn("detail map has null key");
                continue;
            }
            String name = key instanceof String ? (String)key : DetailMapWriter.convertToStringAndTruncate(key);
            entries.add(DetailMapWriter.createDetailEntry(name, entry.getValue()));
        }
        return entries;
    }

    private static List<TraceOuterClass.Trace.DetailValue> listToProto(List<?> list) {
        ArrayList<TraceOuterClass.Trace.DetailValue> detailValues = Lists.newArrayListWithCapacity(list.size());
        for (Object item : list) {
            TraceOuterClass.Trace.DetailValue detailValue = DetailMapWriter.createValue(item);
            if (detailValue == null) continue;
            detailValues.add(detailValue);
        }
        return detailValues;
    }

    private static List<TraceOuterClass.Trace.DetailValue> singleObjectToProto(@Nullable Object value) {
        TraceOuterClass.Trace.DetailValue detailValue = DetailMapWriter.createValue(value);
        if (detailValue == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(detailValue);
    }

    private static TraceOuterClass.Trace.DetailValue createValue(@Nullable Object possiblyOptionalValue) {
        Object value = DetailMapWriter.stripOptional(possiblyOptionalValue);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return TraceOuterClass.Trace.DetailValue.newBuilder().setString((String)value).build();
        }
        if (value instanceof Boolean) {
            return TraceOuterClass.Trace.DetailValue.newBuilder().setBoolean((Boolean)value).build();
        }
        if (value instanceof Long) {
            return TraceOuterClass.Trace.DetailValue.newBuilder().setLong((Long)value).build();
        }
        if (value instanceof Integer) {
            return TraceOuterClass.Trace.DetailValue.newBuilder().setLong(((Integer)value).intValue()).build();
        }
        if (value instanceof Number) {
            return TraceOuterClass.Trace.DetailValue.newBuilder().setDouble(((Number)value).doubleValue()).build();
        }
        logger.warn("detail map has unexpected value type: {}", (Object)value.getClass().getName());
        return TraceOuterClass.Trace.DetailValue.newBuilder().setString(DetailMapWriter.convertToStringAndTruncate(value)).build();
    }

    @Nullable
    private static Object stripOptional(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Optional) {
            Optional val = (Optional)value;
            return val.orNull();
        }
        return value;
    }

    private static String convertToStringAndTruncate(Object obj) {
        String str = obj.toString();
        if (str == null) {
            return "";
        }
        return DetailMapWriter.truncate(str);
    }

    private static String truncate(String s) {
        if (s.length() <= MESSAGE_CHAR_LIMIT) {
            return s;
        }
        return s.substring(0, MESSAGE_CHAR_LIMIT) + " [truncated to " + MESSAGE_CHAR_LIMIT + " characters]";
    }
}

