/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.tools.ToolProvider;
import org.glowroot.agent.live.LiveJvmServiceImpl;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.base.StandardSystemProperty;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.io.ByteStreams;
import org.glowroot.agent.shaded.com.google.common.io.Closer;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;

class JvmTool {
    private static final Logger logger = LoggerFactory.getLogger(JvmTool.class);
    private static final int UNAVAILABLE_DUE_TO_RUNNING_IN_JRE_STATUS = 12345;
    private static final int UNAVAILABLE_PROBABLY_DUE_TO_DOCKER_PID_ONE_STATUS = 23456;

    private JvmTool() {
    }

    public static void main(String[] args) throws Exception {
        long pid = Long.parseLong(args[0]);
        String methodName = args[1];
        try {
            JvmTool.run(pid, methodName, new SystemOutProcessor());
        }
        catch (LiveJvmService.UnavailableDueToRunningInJreException e) {
            System.exit(12345);
        }
        catch (LiveJvmService.UnavailableDueToDockerAlpinePidOneException e) {
            System.exit(23456);
        }
    }

    static <T> T run(long pid, String methodName, InputStreamProcessor<T> processor, boolean allowAttachSelf, @Nullable File glowrootJarFile) throws Exception {
        if (allowAttachSelf) {
            return JvmTool.run(pid, methodName, processor);
        }
        return JvmTool.runExternalAttach(pid, methodName, processor, glowrootJarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T run(long pid, String methodName, InputStreamProcessor<T> processor) throws Exception {
        Object vm;
        Class<?> vmClass;
        ClassLoader systemToolClassLoader = JavaVersion.isGreaterThanOrEqualToJava9() ? LiveJvmServiceImpl.class.getClassLoader() : ToolProvider.getSystemToolClassLoader();
        try {
            vmClass = Class.forName("com.sun.tools.attach.VirtualMachine", true, systemToolClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new LiveJvmService.UnavailableDueToRunningInJreException();
        }
        Method attachMethod = vmClass.getMethod("attach", String.class);
        Method detachMethod = vmClass.getMethod("detach", new Class[0]);
        Class<?> hotSpotVmClass = Class.forName("sun.tools.attach.HotSpotVirtualMachine", true, systemToolClassLoader);
        Method method = hotSpotVmClass.getMethod(methodName, Object[].class);
        try {
            vm = attachMethod.invoke(null, Long.toString(pid));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null && cause.getClass().getName().equals("com.sun.tools.attach.AttachNotSupportedException") && "Unable to get pid of LinuxThreads manager thread".equals(cause.getMessage()) && new File("/etc/alpine-release").exists() && pid == 1L) {
                throw new LiveJvmService.UnavailableDueToDockerAlpinePidOneException();
            }
            throw e;
        }
        try {
            InputStream in = (InputStream)method.invoke(vm, new Object[]{new Object[0]});
            Preconditions.checkNotNull(in);
            T t = JvmTool.processAndClose(in, processor);
            return t;
        }
        finally {
            detachMethod.invoke(vm, new Object[0]);
        }
    }

    private static <T> T runExternalAttach(long pid, String methodName, InputStreamProcessor<T> processor, @Nullable File glowrootJarFile) throws Exception {
        ErrorStreamReader errorStreamReader;
        List<String> command = JvmTool.buildCommand(pid, methodName, glowrootJarFile);
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        Process process = processBuilder.start();
        Closer closer = Closer.create();
        T result = null;
        Exception processingException = null;
        try {
            InputStream in = closer.register(process.getInputStream());
            InputStream err = closer.register(process.getErrorStream());
            errorStreamReader = new ErrorStreamReader(err);
            Thread errorStreamReaderThread = new Thread(errorStreamReader);
            errorStreamReaderThread.setName("Glowroot-JVM-Tool-Error-Stream-Reader");
            errorStreamReaderThread.setDaemon(true);
            errorStreamReaderThread.start();
            try {
                result = JvmTool.processAndClose(in, processor);
            }
            catch (Exception e) {
                processingException = e;
            }
            catch (Throwable t) {
                processingException = new RuntimeException(t);
            }
            errorStreamReaderThread.join();
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        int status = process.waitFor();
        if (status == 12345) {
            throw new LiveJvmService.UnavailableDueToRunningInJreException();
        }
        if (status == 23456) {
            throw new LiveJvmService.UnavailableDueToDockerAlpinePidOneException();
        }
        if (status != 0) {
            logger.error("error occurred while trying to run jvm tool:\n{}\n{}", (Object)Joiner.on(' ').join(command), (Object)errorStreamReader.getOutput().trim());
            throw new IllegalStateException("Error occurred while trying to run jvm tool");
        }
        if (result == null) {
            throw Preconditions.checkNotNull(processingException);
        }
        return result;
    }

    private static List<String> buildCommand(long pid, String methodName, @Nullable File glowrootJarFile) {
        ArrayList<String> command = Lists.newArrayList();
        String javaExecutable = StandardSystemProperty.JAVA_HOME.value() + File.separator + "bin" + File.separator + "java";
        command.add(javaExecutable);
        command.add("-classpath");
        command.add(Joiner.on(File.pathSeparatorChar).join(JvmTool.buildClasspath(glowrootJarFile)));
        command.add(JvmTool.class.getName());
        command.add(Long.toString(pid));
        command.add(methodName);
        return command;
    }

    private static List<String> buildClasspath(@Nullable File glowrootJarFile) {
        if (glowrootJarFile == null || !JvmTool.isShaded()) {
            ArrayList<String> classpath = Lists.newArrayList();
            if (glowrootJarFile != null) {
                classpath.add(glowrootJarFile.getAbsolutePath());
            }
            classpath.addAll(JvmTool.splitClasspath(StandardSystemProperty.JAVA_CLASS_PATH.value()));
            for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!jvmArg.startsWith("-Xbootclasspath/a:")) continue;
                classpath.addAll(JvmTool.splitClasspath(jvmArg.substring("-Xbootclasspath/a:".length())));
                break;
            }
            return classpath;
        }
        return ImmutableList.of(glowrootJarFile.getAbsolutePath());
    }

    private static List<String> splitClasspath(@Nullable String classpath) {
        if (Strings.isNullOrEmpty(classpath)) {
            return ImmutableList.of();
        }
        return Splitter.on(File.pathSeparatorChar).splitToList(classpath);
    }

    private static <T> T processAndClose(InputStream in, InputStreamProcessor<T> processor) throws IOException {
        Closer closer = Closer.create();
        try {
            closer.register(in);
            T t = processor.process(in);
            return t;
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
    }

    private static boolean isShaded() {
        try {
            Class.forName("org.glowroot.agent.shaded.org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.trace(e.getMessage(), e);
            return false;
        }
    }

    private static class ErrorStreamReader
    implements Runnable {
        private final InputStream errorStream;
        private final ByteArrayOutputStream baos;

        private ErrorStreamReader(InputStream errorStream) {
            this.errorStream = errorStream;
            this.baos = new ByteArrayOutputStream();
        }

        @Override
        public void run() {
            try {
                ByteStreams.copy(this.errorStream, this.baos);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }

        private String getOutput() {
            return new String(this.baos.toByteArray());
        }
    }

    private static class SystemOutProcessor
    implements InputStreamProcessor<Void> {
        private SystemOutProcessor() {
        }

        @Override
        @Nullable
        public Void process(InputStream in) throws IOException {
            ByteStreams.copy(in, System.out);
            return null;
        }
    }

    static interface InputStreamProcessor<T> {
        public T process(InputStream var1) throws IOException;
    }
}

