/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.File;
import org.glowroot.agent.live.ClasspathCache;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClasspathCache.Location", generator="Immutables")
@Immutable
final class ImmutableLocation
implements ClasspathCache.Location {
    @Nullable
    private final File directory;
    @Nullable
    private final File jarFile;
    @Nullable
    private final String jarFileInsideJarFile;
    @Nullable
    private final String directoryInsideJarFile;

    private ImmutableLocation(@Nullable File directory, @Nullable File jarFile, @Nullable String jarFileInsideJarFile, @Nullable String directoryInsideJarFile) {
        this.directory = directory;
        this.jarFile = jarFile;
        this.jarFileInsideJarFile = jarFileInsideJarFile;
        this.directoryInsideJarFile = directoryInsideJarFile;
    }

    @Override
    @JsonProperty(value="directory")
    @Nullable
    public File directory() {
        return this.directory;
    }

    @Override
    @JsonProperty(value="jarFile")
    @Nullable
    public File jarFile() {
        return this.jarFile;
    }

    @Override
    @JsonProperty(value="jarFileInsideJarFile")
    @Nullable
    public String jarFileInsideJarFile() {
        return this.jarFileInsideJarFile;
    }

    @Override
    @JsonProperty(value="directoryInsideJarFile")
    @Nullable
    public String directoryInsideJarFile() {
        return this.directoryInsideJarFile;
    }

    public final ImmutableLocation withDirectory(@Nullable File value) {
        if (this.directory == value) {
            return this;
        }
        return new ImmutableLocation(value, this.jarFile, this.jarFileInsideJarFile, this.directoryInsideJarFile);
    }

    public final ImmutableLocation withJarFile(@Nullable File value) {
        if (this.jarFile == value) {
            return this;
        }
        return new ImmutableLocation(this.directory, value, this.jarFileInsideJarFile, this.directoryInsideJarFile);
    }

    public final ImmutableLocation withJarFileInsideJarFile(@Nullable String value) {
        if (Objects.equal(this.jarFileInsideJarFile, value)) {
            return this;
        }
        return new ImmutableLocation(this.directory, this.jarFile, value, this.directoryInsideJarFile);
    }

    public final ImmutableLocation withDirectoryInsideJarFile(@Nullable String value) {
        if (Objects.equal(this.directoryInsideJarFile, value)) {
            return this;
        }
        return new ImmutableLocation(this.directory, this.jarFile, this.jarFileInsideJarFile, value);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLocation && this.equalTo((ImmutableLocation)another);
    }

    private boolean equalTo(ImmutableLocation another) {
        return Objects.equal(this.directory, another.directory) && Objects.equal(this.jarFile, another.jarFile) && Objects.equal(this.jarFileInsideJarFile, another.jarFileInsideJarFile) && Objects.equal(this.directoryInsideJarFile, another.directoryInsideJarFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.directory);
        h += (h << 5) + Objects.hashCode(this.jarFile);
        h += (h << 5) + Objects.hashCode(this.jarFileInsideJarFile);
        h += (h << 5) + Objects.hashCode(this.directoryInsideJarFile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Location").omitNullValues().add("directory", this.directory).add("jarFile", this.jarFile).add("jarFileInsideJarFile", this.jarFileInsideJarFile).add("directoryInsideJarFile", this.directoryInsideJarFile).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLocation fromJson(Json json) {
        Builder builder = ImmutableLocation.builder();
        if (json.directory != null) {
            builder.directory(json.directory);
        }
        if (json.jarFile != null) {
            builder.jarFile(json.jarFile);
        }
        if (json.jarFileInsideJarFile != null) {
            builder.jarFileInsideJarFile(json.jarFileInsideJarFile);
        }
        if (json.directoryInsideJarFile != null) {
            builder.directoryInsideJarFile(json.directoryInsideJarFile);
        }
        return builder.build();
    }

    public static ImmutableLocation copyOf(ClasspathCache.Location instance) {
        if (instance instanceof ImmutableLocation) {
            return (ImmutableLocation)instance;
        }
        return ImmutableLocation.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClasspathCache.Location", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private File directory;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private File jarFile;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String jarFileInsideJarFile;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String directoryInsideJarFile;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ClasspathCache.Location instance) {
            String directoryInsideJarFileValue;
            String jarFileInsideJarFileValue;
            File jarFileValue;
            Preconditions.checkNotNull(instance, "instance");
            File directoryValue = instance.directory();
            if (directoryValue != null) {
                this.directory(directoryValue);
            }
            if ((jarFileValue = instance.jarFile()) != null) {
                this.jarFile(jarFileValue);
            }
            if ((jarFileInsideJarFileValue = instance.jarFileInsideJarFile()) != null) {
                this.jarFileInsideJarFile(jarFileInsideJarFileValue);
            }
            if ((directoryInsideJarFileValue = instance.directoryInsideJarFile()) != null) {
                this.directoryInsideJarFile(directoryInsideJarFileValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder directory(@Nullable File directory) {
            this.directory = directory;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jarFile(@Nullable File jarFile) {
            this.jarFile = jarFile;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder jarFileInsideJarFile(@Nullable String jarFileInsideJarFile) {
            this.jarFileInsideJarFile = jarFileInsideJarFile;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder directoryInsideJarFile(@Nullable String directoryInsideJarFile) {
            this.directoryInsideJarFile = directoryInsideJarFile;
            return this;
        }

        public ImmutableLocation build() {
            return new ImmutableLocation(this.directory, this.jarFile, this.jarFileInsideJarFile, this.directoryInsideJarFile);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClasspathCache.Location", generator="Immutables")
    static final class Json
    implements ClasspathCache.Location {
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        File directory;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        File jarFile;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String jarFileInsideJarFile;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String directoryInsideJarFile;

        Json() {
        }

        @JsonProperty(value="directory")
        public void setDirectory(@Nullable File directory) {
            this.directory = directory;
        }

        @JsonProperty(value="jarFile")
        public void setJarFile(@Nullable File jarFile) {
            this.jarFile = jarFile;
        }

        @JsonProperty(value="jarFileInsideJarFile")
        public void setJarFileInsideJarFile(@Nullable String jarFileInsideJarFile) {
            this.jarFileInsideJarFile = jarFileInsideJarFile;
        }

        @JsonProperty(value="directoryInsideJarFile")
        public void setDirectoryInsideJarFile(@Nullable String directoryInsideJarFile) {
            this.directoryInsideJarFile = directoryInsideJarFile;
        }

        @Override
        public File directory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public File jarFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String jarFileInsideJarFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String directoryInsideJarFile() {
            throw new UnsupportedOperationException();
        }
    }
}

