/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.central.CentralCollector;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.config.PluginCache;
import org.glowroot.agent.impl.BytecodeServiceImpl;
import org.glowroot.agent.init.AgentModule;
import org.glowroot.agent.init.CollectorLogbackAppender;
import org.glowroot.agent.init.CollectorProxy;
import org.glowroot.agent.init.ConfigUpdateService;
import org.glowroot.agent.init.EnvironmentCreator;
import org.glowroot.agent.init.GlowrootAgentInit;
import org.glowroot.agent.init.JRebelWorkaround;
import org.glowroot.agent.init.NettyInit;
import org.glowroot.agent.init.PreCheckLoadedClasses;
import org.glowroot.agent.shaded.ch.qos.logback.classic.Logger;
import org.glowroot.agent.shaded.ch.qos.logback.core.Context;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.ThreadFactories;
import org.glowroot.agent.util.Tickers;

public class NonEmbeddedGlowrootAgentInit
implements GlowrootAgentInit {
    private static final org.glowroot.agent.shaded.org.slf4j.Logger startupLogger = LoggerFactory.getLogger("org.glowroot");
    private static final org.glowroot.agent.shaded.org.slf4j.Logger logger = LoggerFactory.getLogger(NonEmbeddedGlowrootAgentInit.class);
    @Nullable
    private final String collectorAddress;
    @Nullable
    private final String collectorAuthority;
    @Nullable
    private final Class<? extends Collector> customCollectorClass;
    @MonotonicNonNull
    private volatile CollectorLogbackAppender collectorLogbackAppender;
    @MonotonicNonNull
    private volatile AgentModule agentModule;
    @MonotonicNonNull
    private volatile CentralCollector centralCollector;
    @MonotonicNonNull
    private volatile ScheduledExecutorService backgroundExecutor;
    @MonotonicNonNull
    private volatile Closeable agentDirLockCloseable;

    public NonEmbeddedGlowrootAgentInit(@Nullable String collectorAddress, @Nullable String collectorAuthority, @Nullable Class<? extends Collector> customCollectorClass) {
        this.collectorAddress = collectorAddress;
        this.collectorAuthority = collectorAuthority;
        this.customCollectorClass = customCollectorClass;
    }

    @Override
    public void init(@Nullable File pluginsDir, final List<File> confDirs, File logDir, File tmpDir, final @Nullable File glowrootJarFile, final Map<String, String> properties, final @Nullable Instrumentation instrumentation, @Nullable PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer, final String glowrootVersion, Closeable agentDirLockCloseable) throws Exception {
        this.agentDirLockCloseable = agentDirLockCloseable;
        Ticker ticker = Tickers.getTicker();
        Clock clock = Clock.systemClock();
        JRebelWorkaround.perform();
        final boolean configReadOnly = Boolean.parseBoolean(properties.get("glowroot.config.readOnly"));
        final PluginCache pluginCache = PluginCache.create(pluginsDir, false);
        final ConfigService configService = ConfigService.create(confDirs, configReadOnly, pluginCache.pluginDescriptors());
        final CollectorProxy collectorProxy = new CollectorProxy();
        this.collectorLogbackAppender = new CollectorLogbackAppender(collectorProxy);
        this.collectorLogbackAppender.setName(CollectorLogbackAppender.class.getName());
        this.collectorLogbackAppender.setContext((Context)((Object)LoggerFactory.getILoggerFactory()));
        this.collectorLogbackAppender.start();
        NonEmbeddedGlowrootAgentInit.attachAppender(this.collectorLogbackAppender);
        this.agentModule = new AgentModule(clock, ticker, pluginCache, configService, instrumentation, glowrootJarFile, tmpDir, preCheckClassFileTransformer);
        BytecodeServiceImpl.OnEnteringMain onEnteringMain = new BytecodeServiceImpl.OnEnteringMain(){

            @Override
            public void run(@Nullable String mainClass) throws Exception {
                Collector collector;
                Preconditions.checkNotNull(NonEmbeddedGlowrootAgentInit.this.agentModule);
                NonEmbeddedGlowrootAgentInit.this.backgroundExecutor = Executors.newScheduledThreadPool(2, ThreadFactories.create("Glowroot-Background-%d"));
                NonEmbeddedGlowrootAgentInit.this.agentModule.onEnteringMain(NonEmbeddedGlowrootAgentInit.this.backgroundExecutor, collectorProxy, instrumentation, glowrootJarFile, mainClass);
                ConfigUpdateService agentConfigUpdater = new ConfigUpdateService(configService, pluginCache);
                NettyInit.run();
                Constructor collectorProxyConstructor = null;
                if (NonEmbeddedGlowrootAgentInit.this.customCollectorClass != null) {
                    try {
                        collectorProxyConstructor = NonEmbeddedGlowrootAgentInit.this.customCollectorClass.getConstructor(Collector.class);
                    }
                    catch (NoSuchMethodException e) {
                        logger.debug(e.getMessage(), e);
                    }
                }
                if (NonEmbeddedGlowrootAgentInit.this.customCollectorClass != null && collectorProxyConstructor == null) {
                    collector = (Collector)NonEmbeddedGlowrootAgentInit.this.customCollectorClass.newInstance();
                } else {
                    NonEmbeddedGlowrootAgentInit.this.centralCollector = new CentralCollector(properties, Preconditions.checkNotNull(NonEmbeddedGlowrootAgentInit.this.collectorAddress), NonEmbeddedGlowrootAgentInit.this.collectorAuthority, confDirs, configReadOnly, NonEmbeddedGlowrootAgentInit.this.agentModule.getLiveJvmService(), NonEmbeddedGlowrootAgentInit.this.agentModule.getLiveWeavingService(), NonEmbeddedGlowrootAgentInit.this.agentModule.getLiveTraceRepository(), agentConfigUpdater, configService);
                    if (collectorProxyConstructor == null) {
                        collector = NonEmbeddedGlowrootAgentInit.this.centralCollector;
                    } else {
                        startupLogger.info("using collector proxy: {}", (Object)collectorProxyConstructor.getName());
                        collector = (Collector)collectorProxyConstructor.newInstance(NonEmbeddedGlowrootAgentInit.this.centralCollector);
                    }
                }
                collectorProxy.setInstance(collector);
                collector.init(confDirs, EnvironmentCreator.create(glowrootVersion, configService.getJvmConfig()), configService.getAgentConfig(), agentConfigUpdater);
            }
        };
        if (instrumentation == null) {
            onEnteringMain.run(null);
        } else {
            this.agentModule.setOnEnteringMain(onEnteringMain);
        }
    }

    @Override
    @OnlyUsedByTests
    public void initConfigForTests() throws IOException {
        AgentModule agentModule = Preconditions.checkNotNull(this.agentModule);
        agentModule.getConfigService().initConfigForTests();
    }

    @Override
    @OnlyUsedByTests
    public void resetConfigForTests() throws Exception {
        AgentModule agentModule = Preconditions.checkNotNull(this.agentModule);
        agentModule.getConfigService().resetConfigForTests();
        agentModule.getLiveWeavingService().reweave("");
    }

    @Override
    @OnlyUsedByTests
    public void close() throws Exception {
        Preconditions.checkNotNull(this.agentModule).close();
        if (this.centralCollector != null) {
            this.centralCollector.close();
        }
        if (this.backgroundExecutor != null) {
            this.backgroundExecutor.shutdown();
            if (!this.backgroundExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Could not terminate executor");
            }
        }
        Preconditions.checkNotNull(this.collectorLogbackAppender).close();
        Preconditions.checkNotNull(this.agentDirLockCloseable).close();
    }

    @Override
    @OnlyUsedByTests
    public void awaitClose() throws Exception {
        if (this.centralCollector != null) {
            this.centralCollector.awaitClose();
        }
    }

    private static void attachAppender(CollectorLogbackAppender appender) {
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        rootLogger.detachAppender(appender.getClass().getName());
        rootLogger.addAppender(appender);
    }
}

