/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.glowroot.agent.bytecode.api.BytecodeServiceHolder;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.config.PluginCache;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.impl.BytecodeServiceImpl;
import org.glowroot.agent.impl.ConfigServiceImpl;
import org.glowroot.agent.impl.GlowrootServiceHolder;
import org.glowroot.agent.impl.GlowrootServiceImpl;
import org.glowroot.agent.impl.PluginServiceImpl;
import org.glowroot.agent.impl.PreloadSomeSuperTypesCache;
import org.glowroot.agent.impl.StackTraceCollector;
import org.glowroot.agent.impl.TimerNameCache;
import org.glowroot.agent.impl.TraceCollector;
import org.glowroot.agent.impl.TransactionProcessor;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.impl.TransactionService;
import org.glowroot.agent.init.FileSystem;
import org.glowroot.agent.init.GaugeCollector;
import org.glowroot.agent.init.ImmediateTraceStoreWatcher;
import org.glowroot.agent.init.PreCheckLoadedClasses;
import org.glowroot.agent.live.LiveAggregateRepositoryImpl;
import org.glowroot.agent.live.LiveJvmServiceImpl;
import org.glowroot.agent.live.LiveTraceRepositoryImpl;
import org.glowroot.agent.live.LiveWeavingServiceImpl;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.internal.PluginServiceHolder;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.ScheduledRunnable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;
import org.glowroot.agent.util.LazyPlatformMBeanServer;
import org.glowroot.agent.util.OptionalService;
import org.glowroot.agent.util.ThreadAllocatedBytes;
import org.glowroot.agent.util.Tickers;
import org.glowroot.agent.weaving.AdviceCache;
import org.glowroot.agent.weaving.AnalyzedWorld;
import org.glowroot.agent.weaving.IsolatedWeavingClassLoader;
import org.glowroot.agent.weaving.PointcutClassFileTransformer;
import org.glowroot.agent.weaving.PreInitializeWeavingClasses;
import org.glowroot.agent.weaving.Weaver;
import org.glowroot.agent.weaving.WeavingClassFileTransformer;

public class AgentModule {
    private static final Logger logger = LoggerFactory.getLogger(AgentModule.class);
    private static final Logger startupLogger = LoggerFactory.getLogger("org.glowroot");
    private static final long ROLLUP_0_INTERVAL_MILLIS = Long.getLong("glowroot.internal.rollup.0.intervalMillis", TimeUnit.MINUTES.toMillis(1L));
    private final Clock clock;
    private final Ticker ticker;
    private final org.glowroot.agent.config.ConfigService configService;
    private final TransactionRegistry transactionRegistry;
    private final AdviceCache adviceCache;
    private final PreloadSomeSuperTypesCache preloadSomeSuperTypesCache;
    private final AnalyzedWorld analyzedWorld;
    private final Weaver weaver;
    private final Random random;
    private final TransactionService transactionService;
    private final BytecodeServiceImpl bytecodeService;
    @MonotonicNonNull
    private volatile DeadlockedActiveWeavingRunnable deadlockedActiveWeavingRunnable;
    @MonotonicNonNull
    private volatile TraceCollector traceCollector;
    @MonotonicNonNull
    private volatile TransactionProcessor transactionProcessor;
    @MonotonicNonNull
    private volatile LazyPlatformMBeanServer lazyPlatformMBeanServer;
    @MonotonicNonNull
    private volatile GaugeCollector gaugeCollector;
    @MonotonicNonNull
    private volatile StackTraceCollector stackTraceCollector;
    @MonotonicNonNull
    private volatile ImmediateTraceStoreWatcher immedateTraceStoreWatcher;
    private final boolean jvmRetransformClassesSupported;
    @MonotonicNonNull
    private volatile LiveTraceRepositoryImpl liveTraceRepository;
    @MonotonicNonNull
    private volatile LiveAggregateRepositoryImpl liveAggregateRepository;
    @MonotonicNonNull
    private volatile LiveWeavingServiceImpl liveWeavingService;
    @MonotonicNonNull
    private volatile LiveJvmServiceImpl liveJvmService;

    public AgentModule(Clock clock, @Nullable Ticker nullableTicker, final PluginCache pluginCache, final org.glowroot.agent.config.ConfigService configService, @Nullable Instrumentation instrumentation, @Nullable File glowrootJarFile, File tmpDir, @Nullable PreCheckLoadedClasses.PreCheckClassFileTransformer preCheckClassFileTransformer) throws Exception {
        this.clock = clock;
        this.ticker = nullableTicker == null ? Tickers.getTicker() : nullableTicker;
        this.configService = configService;
        this.transactionRegistry = new TransactionRegistry();
        PointcutClassFileTransformer pointcutClassFileTransformer = null;
        if (instrumentation != null) {
            for (File pluginJar : pluginCache.pluginJars()) {
                instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(pluginJar));
            }
            pointcutClassFileTransformer = new PointcutClassFileTransformer();
            instrumentation.addTransformer(pointcutClassFileTransformer);
        }
        this.adviceCache = new AdviceCache(pluginCache.pluginDescriptors(), configService.getInstrumentationConfigs(), instrumentation, tmpDir);
        if (pointcutClassFileTransformer != null) {
            Preconditions.checkNotNull(instrumentation).removeTransformer(pointcutClassFileTransformer);
        }
        this.preloadSomeSuperTypesCache = new PreloadSomeSuperTypesCache(new File(tmpDir, "preload-some-super-types-cache"), 50000, clock);
        this.analyzedWorld = new AnalyzedWorld(this.adviceCache.getAdvisorsSupplier(), this.adviceCache.getShimTypes(), this.adviceCache.getMixinTypes(), this.preloadSomeSuperTypesCache);
        TimerNameCache timerNameCache = new TimerNameCache();
        this.weaver = new Weaver(this.adviceCache.getAdvisorsSupplier(), this.adviceCache.getShimTypes(), this.adviceCache.getMixinTypes(), this.analyzedWorld, this.transactionRegistry, this.ticker, timerNameCache, configService);
        GlowrootServiceHolder.set(new GlowrootServiceImpl(this.transactionRegistry));
        PluginServiceImpl.ConfigServiceFactory configServiceFactory = new PluginServiceImpl.ConfigServiceFactory(){

            @Override
            public ConfigService create(String pluginId) {
                return ConfigServiceImpl.create(configService, pluginCache.pluginDescriptors(), pluginId);
            }
        };
        PluginServiceImpl pluginService = new PluginServiceImpl(timerNameCache, configServiceFactory);
        PluginServiceHolder.set(pluginService);
        this.random = new Random();
        this.transactionService = TransactionService.create(this.transactionRegistry, configService, timerNameCache, this.ticker, clock);
        this.bytecodeService = new BytecodeServiceImpl(this.transactionRegistry, this.transactionService, this.preloadSomeSuperTypesCache);
        BytecodeServiceHolder.set(this.bytecodeService);
        if (instrumentation == null) {
            IsolatedWeavingClassLoader isolatedWeavingClassLoader = (IsolatedWeavingClassLoader)Thread.currentThread().getContextClassLoader();
            Preconditions.checkNotNull(isolatedWeavingClassLoader);
            isolatedWeavingClassLoader.setWeaver(this.weaver);
            this.jvmRetransformClassesSupported = false;
        } else {
            PreInitializeWeavingClasses.preInitializeClasses();
            WeavingClassFileTransformer transformer = new WeavingClassFileTransformer(this.weaver, instrumentation);
            if (instrumentation.isRetransformClassesSupported()) {
                instrumentation.addTransformer(transformer, true);
                this.jvmRetransformClassesSupported = true;
            } else {
                instrumentation.addTransformer(transformer);
                this.jvmRetransformClassesSupported = false;
            }
            if (preCheckClassFileTransformer != null) {
                for (Map.Entry<String, Exception> entry : preCheckClassFileTransformer.getImportantClassLoadingPoints().entrySet()) {
                    logger.warn("important class loaded before Glowroot instrumentation could be applied to it: {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
                instrumentation.removeTransformer(preCheckClassFileTransformer);
            }
            Class[] initialLoadedClasses = instrumentation.getAllLoadedClasses();
            this.adviceCache.initialReweave(initialLoadedClasses);
            AgentModule.logAnyImportantClassLoadedPriorToWeavingInit(initialLoadedClasses, glowrootJarFile, false);
            instrumentation.retransformClasses(ClassLoader.class);
        }
        ManagementFactory.getThreadMXBean().setThreadCpuTimeEnabled(true);
        ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        try {
            Class.forName("sun.net.www.protocol.ftp.Handler");
            Class.forName("sun.net.www.protocol.ftp.FtpURLConnection");
        }
        catch (ClassNotFoundException e) {
            logger.debug(e.getMessage(), e);
        }
        Exception getterCalledTooEarlyLocation = GlowrootServiceHolder.getRetrievedTooEarlyLocation();
        if (getterCalledTooEarlyLocation != null) {
            logger.error("Glowroot Agent API was called too early", getterCalledTooEarlyLocation);
        }
        AgentModule.initPlugins(pluginCache.pluginDescriptors());
    }

    public void setOnEnteringMain(BytecodeServiceImpl.OnEnteringMain onEnteringMain) {
        this.bytecodeService.setOnEnteringMain(onEnteringMain);
    }

    public void onEnteringMain(ScheduledExecutorService backgroundExecutor, Collector collector, @Nullable Instrumentation instrumentation, @Nullable File glowrootJarFile, @Nullable String mainClass) throws Exception {
        this.weaver.setNoLongerNeedToWeaveMainMethods();
        this.deadlockedActiveWeavingRunnable = new DeadlockedActiveWeavingRunnable(this.weaver);
        this.deadlockedActiveWeavingRunnable.scheduleWithFixedDelay(backgroundExecutor, 5L, 5L, TimeUnit.SECONDS);
        OptionalService<ThreadAllocatedBytes> threadAllocatedBytes = ThreadAllocatedBytes.create();
        this.transactionService.setThreadAllocatedBytes(threadAllocatedBytes.getService());
        this.traceCollector = new TraceCollector(this.configService, collector, this.clock, this.ticker);
        this.transactionProcessor = new TransactionProcessor(collector, this.traceCollector, this.configService, ROLLUP_0_INTERVAL_MILLIS, this.clock);
        this.transactionService.setTransactionProcessor(this.transactionProcessor);
        this.lazyPlatformMBeanServer = LazyPlatformMBeanServer.create(mainClass);
        this.bytecodeService.setOnExitingGetPlatformMBeanServer(new Runnable(){

            @Override
            public void run() {
                Preconditions.checkNotNull(AgentModule.this.lazyPlatformMBeanServer);
                AgentModule.this.lazyPlatformMBeanServer.setPlatformMBeanServerAvailable();
            }
        });
        File[] roots = File.listRoots();
        if (roots != null) {
            for (File root : roots) {
                String name = root.getCanonicalPath();
                if (name.length() > 1 && (name.endsWith("/") || name.endsWith("\\"))) {
                    name = name.substring(0, name.length() - 1);
                }
                name = name.replaceAll(":", "");
                this.lazyPlatformMBeanServer.lazyRegisterMBean(new FileSystem(root), "org.glowroot:type=FileSystem,name=" + name);
            }
        }
        this.gaugeCollector = new GaugeCollector(this.configService, collector, this.lazyPlatformMBeanServer, instrumentation, this.clock, this.ticker);
        long gaugeCollectionIntervalMillis = this.configService.getGaugeCollectionIntervalMillis();
        this.gaugeCollector.scheduleWithFixedDelay(gaugeCollectionIntervalMillis, TimeUnit.MILLISECONDS);
        this.stackTraceCollector = new StackTraceCollector(this.transactionRegistry, this.configService, this.random);
        this.immedateTraceStoreWatcher = new ImmediateTraceStoreWatcher(backgroundExecutor, this.transactionRegistry, this.traceCollector, this.configService, this.ticker);
        this.immedateTraceStoreWatcher.scheduleWithFixedDelay(backgroundExecutor, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.liveTraceRepository = new LiveTraceRepositoryImpl(this.transactionRegistry, this.traceCollector, this.clock, this.ticker);
        this.liveAggregateRepository = new LiveAggregateRepositoryImpl(this.transactionProcessor);
        this.liveWeavingService = new LiveWeavingServiceImpl(this.analyzedWorld, instrumentation, this.configService, this.adviceCache, this.jvmRetransformClassesSupported);
        this.liveJvmService = new LiveJvmServiceImpl(this.lazyPlatformMBeanServer, this.transactionRegistry, this.traceCollector, threadAllocatedBytes.getAvailability(), this.configService, glowrootJarFile, this.clock);
        this.preloadSomeSuperTypesCache.scheduleWithFixedDelay(backgroundExecutor, 5L, 5L, TimeUnit.SECONDS);
    }

    public org.glowroot.agent.config.ConfigService getConfigService() {
        return this.configService;
    }

    public LazyPlatformMBeanServer getLazyPlatformMBeanServer() {
        if (this.lazyPlatformMBeanServer == null) {
            throw new IllegalStateException("onEnteringMain() was never called");
        }
        return this.lazyPlatformMBeanServer;
    }

    public LiveTraceRepositoryImpl getLiveTraceRepository() {
        if (this.liveTraceRepository == null) {
            throw new IllegalStateException("onEnteringMain() was never called");
        }
        return this.liveTraceRepository;
    }

    public LiveAggregateRepositoryImpl getLiveAggregateRepository() {
        if (this.liveAggregateRepository == null) {
            throw new IllegalStateException("onEnteringMain() was never called");
        }
        return this.liveAggregateRepository;
    }

    public LiveWeavingServiceImpl getLiveWeavingService() {
        if (this.liveWeavingService == null) {
            throw new IllegalStateException("onEnteringMain() was never called");
        }
        return this.liveWeavingService;
    }

    public LiveJvmServiceImpl getLiveJvmService() {
        if (this.liveJvmService == null) {
            throw new IllegalStateException("onEnteringMain() was never called");
        }
        return this.liveJvmService;
    }

    public static boolean logAnyImportantClassLoadedPriorToWeavingInit(Class<?>[] initialLoadedClasses, @Nullable File glowrootJarFile, boolean preCheck) {
        ArrayList<String> loadedImportantClassNames = Lists.newArrayList();
        for (Class<?> initialLoadedClass : initialLoadedClasses) {
            String className = initialLoadedClass.getName();
            if (!PreCheckLoadedClasses.isImportantClass(className, initialLoadedClass)) continue;
            loadedImportantClassNames.add(className);
        }
        if (loadedImportantClassNames.isEmpty()) {
            return false;
        }
        AgentModule.logLoadedImportantClassWarning(loadedImportantClassNames, glowrootJarFile, preCheck);
        return true;
    }

    private static void logLoadedImportantClassWarning(List<String> loadedImportantClassNames, @Nullable File glowrootJarFile, boolean preCheck) {
        if (preCheck) {
            startupLogger.warn("PRE-CHECK: one or more important classes were loaded before Glowroot startup: {}", (Object)Joiner.on(", ").join(loadedImportantClassNames));
            return;
        }
        List<String> javaAgentArgsBeforeGlowroot = AgentModule.getJavaAgentArgsBeforeGlowroot(glowrootJarFile);
        if (!javaAgentArgsBeforeGlowroot.isEmpty()) {
            startupLogger.warn("one or more important classes were loaded before Glowroot instrumentation could be applied to them: {}. This likely occurred because one or more other javaagents are listed in the JVM args prior to the Glowroot agent ({}) which gives them a higher loading precedence.", (Object)Joiner.on(", ").join(loadedImportantClassNames), (Object)Joiner.on(" ").join(javaAgentArgsBeforeGlowroot));
            return;
        }
        List<String> nativeAgentArgs = AgentModule.getNativeAgentArgs();
        if (!nativeAgentArgs.isEmpty()) {
            startupLogger.warn("one or more important classes were loaded before Glowroot instrumentation could be applied to them: {}. This likely occurred because there are one or more native agents listed in the JVM args ({}), and native agents have higher loading precedence than java agents.", (Object)Joiner.on(", ").join(loadedImportantClassNames), (Object)Joiner.on(" ").join(nativeAgentArgs));
            return;
        }
        startupLogger.warn("one or more important classes were loaded before Glowroot instrumentation could be applied to them: {}", (Object)Joiner.on(", ").join(loadedImportantClassNames));
    }

    private static List<String> getNativeAgentArgs() {
        ArrayList<String> nativeAgentArgs = Lists.newArrayList();
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!jvmArg.startsWith("-agentpath:") && !jvmArg.startsWith("-agentlib:")) continue;
            nativeAgentArgs.add(jvmArg);
        }
        return nativeAgentArgs;
    }

    private static List<String> getJavaAgentArgsBeforeGlowroot(@Nullable File glowrootJarFile) {
        String jvmArg;
        if (glowrootJarFile == null) {
            return ImmutableList.of();
        }
        ArrayList<String> javaAgentArgsBeforeGlowroot = Lists.newArrayList();
        Iterator<String> iterator = ManagementFactory.getRuntimeMXBean().getInputArguments().iterator();
        while (!(!iterator.hasNext() || (jvmArg = iterator.next()).startsWith("-javaagent:") && jvmArg.endsWith(glowrootJarFile.getName()))) {
            if (!jvmArg.startsWith("-javaagent:") && !AgentModule.isIbmJ9HealthcenterArg(jvmArg)) continue;
            javaAgentArgsBeforeGlowroot.add(jvmArg);
        }
        return javaAgentArgsBeforeGlowroot;
    }

    private static boolean isIbmJ9HealthcenterArg(String jvmArg) {
        return JavaVersion.isJ9Jvm() && (jvmArg.equals("-Xhealthcenter") || jvmArg.startsWith("-Xhealthcenter:"));
    }

    private static void initPlugins(List<PluginDescriptor> pluginDescriptors) {
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            for (String aspect : pluginDescriptor.aspects()) {
                try {
                    Class.forName(aspect, true, AgentModule.class.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    logger.debug(e.getMessage(), e);
                }
            }
        }
    }

    @OnlyUsedByTests
    public void close() throws Exception {
        if (this.immedateTraceStoreWatcher != null) {
            this.immedateTraceStoreWatcher.cancel();
        }
        if (this.stackTraceCollector != null) {
            this.stackTraceCollector.close();
        }
        if (this.gaugeCollector != null) {
            this.gaugeCollector.close();
        }
        if (this.lazyPlatformMBeanServer != null) {
            this.lazyPlatformMBeanServer.close();
        }
        if (this.traceCollector != null) {
            this.traceCollector.close();
        }
        if (this.transactionProcessor != null) {
            this.transactionProcessor.close();
        }
        if (this.deadlockedActiveWeavingRunnable != null) {
            this.deadlockedActiveWeavingRunnable.cancel();
        }
    }

    private static class DeadlockedActiveWeavingRunnable
    extends ScheduledRunnable {
        private final Weaver weaver;

        private DeadlockedActiveWeavingRunnable(Weaver weaver) {
            this.weaver = weaver;
        }

        @Override
        public void runInternal() {
            this.weaver.checkForDeadlockedActiveWeaving();
        }
    }
}

