/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.AsyncComponents;
import org.glowroot.agent.impl.RootTimerCollectorImpl;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.ThreadStatsCollectorImpl;
import org.glowroot.agent.impl.TimerImpl;
import org.glowroot.agent.impl.TraceEntryImpl;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.impl.TransactionService;
import org.glowroot.agent.model.AggregatedTimer;
import org.glowroot.agent.model.AsyncQueryData;
import org.glowroot.agent.model.AsyncTimer;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.model.MergedThreadTimer;
import org.glowroot.agent.model.QueryCollector;
import org.glowroot.agent.model.ServiceCallCollector;
import org.glowroot.agent.model.SharedQueryTextCollection;
import org.glowroot.agent.model.ThreadProfile;
import org.glowroot.agent.model.ThreadStats;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.plugin.api.Message;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.internal.ReadableMessage;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ArrayListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.HashMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSetMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.Iterables;
import org.glowroot.agent.shaded.com.google.common.collect.ListMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.SetMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.com.google.common.collect.TreeMultimap;
import org.glowroot.agent.shaded.com.google.common.io.BaseEncoding;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.shaded.org.glowroot.common.util.Cancellable;
import org.glowroot.agent.shaded.org.glowroot.common.util.NotAvailableAware;
import org.glowroot.agent.shaded.org.glowroot.common.util.Traverser;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Checkers;
import org.glowroot.agent.util.IterableWithSelfRemovableEntries;
import org.glowroot.agent.util.ThreadAllocatedBytes;

public class Transaction {
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    static final int USE_GENERAL_STORE_THRESHOLD = -1;
    static final String AUXILIARY_THREAD_MESSAGE = "auxiliary thread";
    private static final int ATTRIBUTE_KEYS_INITIAL_CAPACITY = 16;
    private static final long ATTRIBUTE_VALUES_PER_KEY_LIMIT = 1000L;
    private static final int TRANSACTION_AUX_THREAD_CONTEXT_LIMIT = Integer.getInteger("glowroot.transaction.aux.thread.context.limit", 1000);
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final Random random = new Random();
    @Nullable
    private volatile String traceId;
    private final long startTime;
    private final long startTick;
    private volatile boolean async;
    private volatile boolean outer;
    private volatile String transactionType;
    private volatile int transactionTypePriority = Integer.MIN_VALUE;
    private volatile String transactionName;
    private volatile int transactionNamePriority = Integer.MIN_VALUE;
    @Nullable
    private volatile String user;
    private volatile int userPriority = Integer.MIN_VALUE;
    private final Object attributesLock = new Object();
    @GuardedBy(value="attributesLock")
    @MonotonicNonNull
    private SetMultimap<String, String> attributes;
    @Nullable
    private volatile ErrorMessage errorMessage;
    private final int maxTraceEntries;
    private final int maxQueryAggregates;
    private final int maxServiceCallAggregates;
    private final int maxProfileSamples;
    private final TransactionRegistry transactionRegistry;
    private final TransactionService transactionService;
    private final ConfigService configService;
    @MonotonicNonNull
    private volatile ThreadProfile mainThreadProfile;
    @MonotonicNonNull
    private volatile ThreadProfile auxThreadProfile;
    private volatile int slowThresholdMillis = -1;
    private volatile int slowThresholdMillisPriority = Integer.MIN_VALUE;
    @MonotonicNonNull
    private volatile Cancellable immedateTraceStoreRunnable;
    private volatile boolean partiallyStored;
    private volatile long captureTime;
    private volatile boolean memoryBarrier;
    private final CompletionCallback completionCallback;
    private volatile int entryLimitCounter;
    private volatile int extraErrorEntryLimitCounter;
    @Nullable
    private volatile AtomicInteger throwableFrameLimitCounter;
    private final ThreadContextImpl mainThreadContext;
    @GuardedBy(value="mainThreadContext")
    @MonotonicNonNull
    private List<ThreadContextImpl> auxThreadContexts;
    @GuardedBy(value="mainThreadContext")
    @MonotonicNonNull
    private List<ThreadContextImpl> unmergeableAuxThreadContexts;
    @GuardedBy(value="mainThreadContext")
    @MonotonicNonNull
    private Set<ThreadContextImpl> unmergedLimitExceededAuxThreadContexts;
    private final Object asyncComponentsInitLock = new Object();
    @MonotonicNonNull
    private volatile AsyncComponents asyncComponents;
    private final Object sharedQueryTextCollectionLock = new Object();
    @GuardedBy(value="sharedQueryTextCollectionLock")
    @MonotonicNonNull
    private SharedQueryTextCollectionImpl sharedQueryTextCollection;
    private Map<Object, StackTraceElement[]> unreleasedResources = Maps.newConcurrentMap();
    private volatile boolean waitingToEndAsync;
    private volatile boolean completed;
    private volatile long endTick;
    private final Ticker ticker;
    @Nullable
    private IterableWithSelfRemovableEntries.SelfRemovableEntry transactionEntry;
    @GuardedBy(value="mainThreadContext")
    @MonotonicNonNull
    private RootTimerCollectorImpl alreadyMergedAuxThreadTimers;
    @GuardedBy(value="mainThreadContext")
    @MonotonicNonNull
    private ThreadStatsCollectorImpl alreadyMergedAuxThreadStats;
    @GuardedBy(value="mainThreadContext")
    @MonotonicNonNull
    private QueryCollector alreadyMergedAuxQueries;
    @GuardedBy(value="mainThreadContext")
    @MonotonicNonNull
    private ServiceCallCollector alreadyMergedAuxServiceCalls;
    @GuardedBy(value="mainThreadContext")
    private boolean stopMergingAuxThreadContexts;

    Transaction(long startTime, long startTick, String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName, boolean captureThreadStats, int maxTraceEntries, int maxQueryAggregates, int maxServiceCallAggregates, int maxProfileSamples, @Nullable ThreadAllocatedBytes threadAllocatedBytes, CompletionCallback completionCallback, Ticker ticker, TransactionRegistry transactionRegistry, TransactionService transactionService, ConfigService configService, ThreadContextThreadLocal.Holder threadContextHolder, int rootNestingGroupId, int rootSuppressionKeyId) {
        this.startTime = startTime;
        this.startTick = startTick;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.maxTraceEntries = maxTraceEntries;
        this.maxQueryAggregates = maxQueryAggregates;
        this.maxServiceCallAggregates = maxServiceCallAggregates;
        this.maxProfileSamples = maxProfileSamples;
        this.completionCallback = completionCallback;
        this.ticker = ticker;
        this.transactionRegistry = transactionRegistry;
        this.transactionService = transactionService;
        this.configService = configService;
        this.mainThreadContext = new ThreadContextImpl(Checkers.castInitialized(this), null, null, messageSupplier, timerName, startTick, captureThreadStats, maxQueryAggregates, maxServiceCallAggregates, threadAllocatedBytes, false, ticker, threadContextHolder, null, rootNestingGroupId, rootSuppressionKeyId);
    }

    long getStartTime() {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTraceId() {
        if (this.traceId == null) {
            Transaction transaction = this;
            synchronized (transaction) {
                if (this.traceId == null) {
                    this.traceId = Transaction.buildTraceId(this.startTime);
                }
            }
        }
        return this.traceId;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isFullyCompleted() {
        return this.completed && this.captureTime != 0L;
    }

    long getEndTick() {
        return this.endTick;
    }

    public long getDurationNanos() {
        return this.completed ? this.endTick - this.startTick : this.ticker.read() - this.startTick;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getTransactionName() {
        return this.transactionName;
    }

    public String getHeadline() {
        Object messageSupplier = this.mainThreadContext.getRootEntry().getMessageSupplier();
        Preconditions.checkNotNull(messageSupplier);
        return ((ReadableMessage)((Object)((MessageSupplier)messageSupplier).get())).getText();
    }

    public String getUser() {
        return Strings.nullToEmpty(this.user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetMultimap<String, String> getAttributes() {
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.attributes == null) {
                return ImmutableSetMultimap.of();
            }
            TreeMultimap<String, String> orderedAttributes = TreeMultimap.create();
            orderedAttributes.putAll(this.attributes);
            return orderedAttributes;
        }
    }

    Map<String, ?> getDetail() {
        Object messageSupplier = this.mainThreadContext.getRootEntry().getMessageSupplier();
        Preconditions.checkNotNull(messageSupplier);
        return ((ReadableMessage)((Object)((MessageSupplier)messageSupplier).get())).getDetail();
    }

    @Nullable
    List<StackTraceElement> getLocationStackTrace() {
        return this.mainThreadContext.getRootEntry().getLocationStackTrace();
    }

    @Nullable
    public ErrorMessage getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return this.mainThreadContext.getRootEntry().getErrorMessage();
    }

    boolean isAsync() {
        return this.async;
    }

    boolean isOuter() {
        return this.outer;
    }

    TimerImpl getMainThreadRootTimer() {
        this.memoryBarrierRead();
        return this.mainThreadContext.getRootTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasAuxThreadContexts() {
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            return this.auxThreadContexts != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeAuxThreadTimersInto(AggregatedTimer rootAuxThreadTimer) {
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts == null) {
                return;
            }
            if (this.alreadyMergedAuxThreadTimers != null) {
                for (MergedThreadTimer rootTimer : this.alreadyMergedAuxThreadTimers.getRootTimers()) {
                    rootAuxThreadTimer.addDataFrom(rootTimer);
                }
            }
            for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                rootAuxThreadTimer.addDataFrom(auxThreadContext.getRootTimer());
            }
        }
    }

    boolean hasAsyncTimers() {
        return this.asyncComponents != null;
    }

    void mergeAsyncTimersInto(RootTimerCollector asyncTimers) {
        if (this.asyncComponents != null) {
            this.asyncComponents.mergeAsyncTimersInto(asyncTimers);
        }
    }

    ThreadStats getMainThreadStats() {
        return this.mainThreadContext.getThreadStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCpuNanos() {
        long cpuNanos = this.mainThreadContext.getCpuNanos();
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts == null) {
                return cpuNanos;
            }
            if (this.alreadyMergedAuxThreadStats != null) {
                cpuNanos = NotAvailableAware.add(cpuNanos, this.alreadyMergedAuxThreadStats.getCpuNanos());
            }
            for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                cpuNanos = NotAvailableAware.add(cpuNanos, auxThreadContext.getCpuNanos());
            }
        }
        return cpuNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeAuxThreadStatsInto(ThreadStatsCollector collector) {
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts == null) {
                return;
            }
            if (this.alreadyMergedAuxThreadStats != null) {
                collector.mergeThreadStats(this.alreadyMergedAuxThreadStats.getMergedThreadStats());
            }
            for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                collector.mergeThreadStats(auxThreadContext.getThreadStats());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeQueriesInto(QueryCollector collector) {
        this.memoryBarrierRead();
        this.mainThreadContext.mergeQueriesInto(collector);
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts != null) {
                if (this.alreadyMergedAuxQueries != null) {
                    this.alreadyMergedAuxQueries.mergeQueriesInto(collector);
                }
                for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                    auxThreadContext.mergeQueriesInto(collector);
                }
            }
        }
        if (this.asyncComponents != null) {
            this.asyncComponents.mergeQueriesInto(collector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AggregateOuterClass.Aggregate.Query> getQueries() {
        Object object = this.sharedQueryTextCollectionLock;
        synchronized (object) {
            if (this.sharedQueryTextCollection == null) {
                this.sharedQueryTextCollection = new SharedQueryTextCollectionImpl();
            }
            return this.getQueriesInternal(this.sharedQueryTextCollection);
        }
    }

    int getQueryCount() {
        return this.getQueriesInternal(new NopSharedQueryTextCollection()).size();
    }

    private List<AggregateOuterClass.Aggregate.Query> getQueriesInternal(SharedQueryTextCollection sharedQueryTextCollection) {
        QueryCollector collector = new QueryCollector(this.maxQueryAggregates, 10);
        this.mergeQueriesInto(collector);
        return collector.toAggregateProto(sharedQueryTextCollection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSharedQueryTexts() {
        Object object = this.sharedQueryTextCollectionLock;
        synchronized (object) {
            if (this.sharedQueryTextCollection == null) {
                this.sharedQueryTextCollection = new SharedQueryTextCollectionImpl();
            }
            return ImmutableList.copyOf(this.sharedQueryTextCollection.sharedQueryTexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeServiceCallsInto(ServiceCallCollector collector) {
        this.memoryBarrierRead();
        this.mainThreadContext.mergeServiceCallsInto(collector);
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts != null) {
                if (this.alreadyMergedAuxServiceCalls != null) {
                    this.alreadyMergedAuxServiceCalls.mergeServiceCallsInto(collector);
                }
                for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                    auxThreadContext.mergeServiceCallsInto(collector);
                }
            }
        }
        if (this.asyncComponents != null) {
            this.asyncComponents.mergeServiceCallsInto(collector);
        }
    }

    boolean allowAnotherEntry() {
        return this.entryLimitCounter++ < this.maxTraceEntries;
    }

    boolean allowAnotherErrorEntry() {
        return this.entryLimitCounter++ < this.maxTraceEntries || this.extraErrorEntryLimitCounter++ < this.maxTraceEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitEntries(long captureTick, TraceEntryVisitor entryVisitor) {
        Object object = this.sharedQueryTextCollectionLock;
        synchronized (object) {
            if (this.sharedQueryTextCollection == null) {
                this.sharedQueryTextCollection = new SharedQueryTextCollectionImpl();
            }
            this.visitEntriesInternal(captureTick, entryVisitor, this.sharedQueryTextCollection);
        }
    }

    int getEntryCount(long captureTick) {
        CountingEntryVisitor entryVisitor = new CountingEntryVisitor();
        this.visitEntriesInternal(captureTick, entryVisitor, new NopSharedQueryTextCollection());
        return entryVisitor.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitEntriesInternal(long captureTick, TraceEntryVisitor entryVisitor, SharedQueryTextCollection sharedQueryTextCollection) {
        this.memoryBarrierRead();
        ListMultimap<TraceEntryImpl, ThreadContextImpl> priorEntryChildThreadContextMap = this.buildPriorEntryChildThreadContextMap();
        ArrayListMultimap<TraceEntryImpl, TraceEntryImpl> parentChildMap = ArrayListMultimap.create();
        this.mainThreadContext.populateParentChildMap(parentChildMap, captureTick, priorEntryChildThreadContextMap);
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts != null) {
                for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                    auxThreadContext.populateParentChildMap(parentChildMap, captureTick, priorEntryChildThreadContextMap);
                }
            }
        }
        new ParentChildMapTrimmer(this.mainThreadContext.getRootEntry(), parentChildMap, captureTick).traverse();
        Transaction.addProtobufChildEntries(this.mainThreadContext.getRootEntry(), parentChildMap, this.startTick, captureTick, 0, entryVisitor, sharedQueryTextCollection, this.async);
    }

    long getMainThreadProfileSampleCount() {
        if (this.mainThreadProfile == null) {
            return 0L;
        }
        return this.mainThreadProfile.getSampleCount();
    }

    @Nullable
    ThreadProfile getMainThreadProfile() {
        return this.mainThreadProfile;
    }

    @Nullable
    public ProfileOuterClass.Profile getMainThreadProfileProtobuf() {
        if (this.mainThreadProfile == null) {
            return null;
        }
        return this.mainThreadProfile.toProto();
    }

    boolean isMainThreadProfileSampleLimitExceeded(long profileSampleCount) {
        return profileSampleCount >= (long)this.maxProfileSamples && this.mainThreadProfile != null && this.mainThreadProfile.isSampleLimitExceeded();
    }

    long getAuxThreadProfileSampleCount() {
        if (this.auxThreadProfile == null) {
            return 0L;
        }
        return this.auxThreadProfile.getSampleCount();
    }

    @Nullable
    ThreadProfile getAuxThreadProfile() {
        return this.auxThreadProfile;
    }

    @Nullable
    public ProfileOuterClass.Profile getAuxThreadProfileProtobuf() {
        if (this.auxThreadProfile == null) {
            return null;
        }
        return this.auxThreadProfile.toProto();
    }

    boolean isAuxThreadProfileSampleLimitExceeded(long profileSampleCount) {
        return profileSampleCount >= (long)this.maxProfileSamples && this.auxThreadProfile != null && this.auxThreadProfile.isSampleLimitExceeded();
    }

    int getSlowThresholdMillisOverride() {
        return this.slowThresholdMillis;
    }

    @Nullable
    public Cancellable getImmedateTraceStoreRunnable() {
        return this.immedateTraceStoreRunnable;
    }

    public boolean isPartiallyStored() {
        return this.partiallyStored;
    }

    public ThreadContextImpl getMainThreadContext() {
        return this.mainThreadContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadContextImpl> getActiveAuxThreadContexts() {
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts == null) {
                return ImmutableList.of();
            }
            ArrayList<ThreadContextImpl> activeAuxThreadContexts = Lists.newArrayList();
            for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                if (!auxThreadContext.isActive()) continue;
                activeAuxThreadContexts.add(auxThreadContext);
            }
            return activeAuxThreadContexts;
        }
    }

    void setAsync() {
        this.async = true;
    }

    void setOuter() {
        this.outer = true;
    }

    void setTransactionType(String transactionType, int priority) {
        if (priority > this.transactionTypePriority && !transactionType.isEmpty()) {
            this.transactionType = transactionType;
            this.transactionTypePriority = priority;
        }
    }

    void setTransactionName(String transactionName, int priority) {
        if (priority > this.transactionNamePriority && !transactionName.isEmpty()) {
            this.transactionName = transactionName;
            this.transactionNamePriority = priority;
        }
    }

    void setUser(String user, int priority) {
        if (priority > this.userPriority && !user.isEmpty()) {
            this.user = user;
            this.userPriority = priority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAttribute(String name, @Nullable String value) {
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = HashMultimap.create(16, 1);
            }
            String val = Strings.nullToEmpty(value);
            Set<String> values = this.attributes.get(name);
            if ((long)values.size() < 1000L) {
                values.add(val);
            }
        }
    }

    void setError(@Nullable String message, @Nullable Throwable t) {
        if (this.errorMessage == null) {
            this.errorMessage = ErrorMessage.create(message, t, this.getThrowableFrameLimitCounter());
        }
    }

    void setSlowThresholdMillis(int slowThresholdMillis, int priority) {
        if (priority > this.slowThresholdMillisPriority) {
            this.slowThresholdMillis = slowThresholdMillis;
            this.slowThresholdMillisPriority = priority;
        } else if (priority == this.slowThresholdMillisPriority) {
            this.slowThresholdMillis = Math.min(this.slowThresholdMillis, slowThresholdMillis);
        }
    }

    public void setImmediateTraceStoreRunnable(Cancellable immedateTraceStoreRunnable) {
        if (this.immedateTraceStoreRunnable != null) {
            logger.warn("setImmediateTraceStoreRunnable(): overwriting non-null immedateTraceStoreRunnable");
        }
        this.immedateTraceStoreRunnable = immedateTraceStoreRunnable;
    }

    void setPartiallyStored() {
        this.partiallyStored = true;
    }

    void setTransactionEntry(IterableWithSelfRemovableEntries.SelfRemovableEntry transactionEntry) {
        this.transactionEntry = transactionEntry;
    }

    void removeFromActiveTransactions() {
        Preconditions.checkNotNull(this.transactionEntry).remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ThreadContextImpl startAuxThreadContext(@Nullable TraceEntryImpl parentTraceEntry, @Nullable TraceEntryImpl parentThreadContextPriorEntry, TimerName auxTimerName, long startTick, ThreadContextThreadLocal.Holder threadContextHolder, @Nullable ThreadContext.ServletRequestInfo servletRequestInfo, @Nullable ThreadAllocatedBytes threadAllocatedBytes) {
        ThreadContextImpl auxThreadContext;
        Object object = this.mainThreadContext;
        synchronized (object) {
            if (this.completed) {
                return null;
            }
            if (this.auxThreadContexts == null) {
                this.auxThreadContexts = Lists.newArrayList();
            }
            if (this.allowAnotherAuxThreadContextWithTraceEntries() && parentTraceEntry != null && parentThreadContextPriorEntry != null) {
                auxThreadContext = new ThreadContextImpl(this, parentTraceEntry, parentThreadContextPriorEntry, AuxThreadRootMessageSupplier.INSTANCE, auxTimerName, startTick, this.mainThreadContext.getCaptureThreadStats(), this.maxQueryAggregates, this.maxServiceCallAggregates, threadAllocatedBytes, false, this.ticker, threadContextHolder, servletRequestInfo, 0, 0);
                this.auxThreadContexts.add(auxThreadContext);
            } else {
                auxThreadContext = new ThreadContextImpl(this, this.mainThreadContext.getRootEntry(), this.mainThreadContext.getTailEntry(), AuxThreadRootMessageSupplier.INSTANCE, auxTimerName, startTick, this.mainThreadContext.getCaptureThreadStats(), this.maxQueryAggregates, this.maxServiceCallAggregates, threadAllocatedBytes, true, this.ticker, threadContextHolder, servletRequestInfo, 0, 0);
                if (this.unmergedLimitExceededAuxThreadContexts == null) {
                    this.unmergedLimitExceededAuxThreadContexts = Sets.newHashSet();
                }
                this.unmergedLimitExceededAuxThreadContexts.add(auxThreadContext);
            }
        }
        object = threadContextHolder;
        synchronized (object) {
            threadContextHolder.set(auxThreadContext);
        }
        return auxThreadContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeLimitExceededAuxThreadContext(ThreadContextImpl auxThreadContext) {
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            Preconditions.checkNotNull(this.unmergedLimitExceededAuxThreadContexts).remove(auxThreadContext);
            if (auxThreadContext.hasTraceEntries()) {
                Preconditions.checkNotNull(this.auxThreadContexts).add(auxThreadContext);
                return;
            }
            this.initAlreadyMergedAuxComponentsIfNeeded();
            this.mergeAux(auxThreadContext);
        }
    }

    AsyncTimer startAsyncTimer(TimerName asyncTimerName, long startTick) {
        return this.getOrInitAsyncComponents().startAsyncTimer(asyncTimerName, startTick);
    }

    AsyncQueryData getOrCreateAsyncQueryData(String queryType, String queryText, boolean bypassLimit) {
        return this.getOrInitAsyncComponents().getOrCreateAsyncQueryData(queryType, queryText, bypassLimit);
    }

    AsyncQueryData getOrCreateAsyncServiceCallData(String serviceCallType, String serviceCallText, boolean bypassLimit) {
        return this.getOrInitAsyncComponents().getOrCreateAsyncServiceCallData(serviceCallType, serviceCallText, bypassLimit);
    }

    TraceEntryImpl startInnerTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName, ThreadContextThreadLocal.Holder threadContextHolder, int rootNestingGroupId, int rootSuppressionKeyId) {
        return this.transactionService.startTransaction(transactionType, transactionName, messageSupplier, timerName, threadContextHolder, rootNestingGroupId, rootSuppressionKeyId);
    }

    boolean isEntryLimitExceeded(int entryCount) {
        return entryCount >= this.maxTraceEntries && this.entryLimitCounter > this.maxTraceEntries;
    }

    boolean isQueryLimitExceeded(int queryCount) {
        return queryCount > this.maxQueryAggregates;
    }

    void captureStackTrace(boolean auxiliary, ThreadInfo threadInfo) {
        if (this.completed) {
            return;
        }
        ThreadProfile profile = auxiliary ? this.auxThreadProfile : this.mainThreadProfile;
        if (profile == null) {
            profile = new ThreadProfile(this.maxProfileSamples);
            profile.addStackTrace(threadInfo);
            if (auxiliary) {
                this.auxThreadProfile = profile;
            } else {
                this.mainThreadProfile = profile;
            }
            return;
        }
        profile.addStackTrace(threadInfo);
    }

    void trackResourceAcquired(Object resource, boolean withLocationStackTrace) {
        if (withLocationStackTrace) {
            this.unreleasedResources.put(resource, Thread.currentThread().getStackTrace());
        } else {
            this.unreleasedResources.put(resource, EMPTY_STACK_TRACE);
        }
    }

    void trackResourceReleased(Object resource) {
        this.unreleasedResources.remove(resource);
    }

    void setWaitingToEndAsync() {
        this.waitingToEndAsync = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void end(long endTick, boolean completeAsyncTransaction, boolean isSetTransactionAsyncComplete) {
        if (this.async && (!completeAsyncTransaction || this.waitingToEndAsync && isSetTransactionAsyncComplete)) {
            return;
        }
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.completed) {
                return;
            }
            this.endTick = endTick;
            this.completed = true;
            this.detachIncompleteAuxThreadContexts();
        }
        if (!this.unreleasedResources.isEmpty()) {
            boolean first = true;
            for (Map.Entry<Object, StackTraceElement[]> entry : this.unreleasedResources.entrySet()) {
                ErrorMessage errorMessage = ErrorMessage.create("Resource leaked", null, this.getThrowableFrameLimitCounter());
                if (first) {
                    this.errorMessage = errorMessage;
                }
                StackTraceElement[] locationStackTrace = entry.getValue();
                TraceEntryImpl traceEntry = this.mainThreadContext.addErrorEntry(endTick, endTick, MessageSupplier.create("Resource leaked (acquired during the transaction and not released): " + entry.getKey().getClass().getName()), null, errorMessage);
                if (locationStackTrace.length != 0) {
                    int index = ThreadContextImpl.getNormalizedStartIndex(locationStackTrace, "trackResourceAcquired", 2);
                    traceEntry.setLocationStackTrace((ImmutableList<StackTraceElement>)ImmutableList.copyOf(locationStackTrace).subList(index, locationStackTrace.length));
                }
                first = false;
            }
        }
        if (this.immedateTraceStoreRunnable != null) {
            this.immedateTraceStoreRunnable.cancel();
        }
        this.completionCallback.completed(this);
    }

    void setCaptureTime(long captureTime) {
        this.captureTime = captureTime;
    }

    public long getCaptureTime() {
        return this.captureTime;
    }

    TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    TransactionService getTransactionService() {
        return this.transactionService;
    }

    ConfigService getConfigService() {
        return this.configService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AtomicInteger getThrowableFrameLimitCounter() {
        if (this.throwableFrameLimitCounter == null) {
            Transaction transaction = this;
            synchronized (transaction) {
                if (this.throwableFrameLimitCounter == null) {
                    this.throwableFrameLimitCounter = new AtomicInteger();
                }
            }
        }
        return this.throwableFrameLimitCounter;
    }

    boolean memoryBarrierRead() {
        return this.memoryBarrier;
    }

    void memoryBarrierWrite() {
        this.memoryBarrier = true;
    }

    void memoryBarrierReadWrite() {
        this.memoryBarrierRead();
        this.memoryBarrierWrite();
    }

    @GuardedBy(value="mainThreadContext")
    @RequiresNonNull(value={"auxThreadContexts"})
    private boolean allowAnotherAuxThreadContextWithTraceEntries() {
        int unmergedCount = this.auxThreadContexts.size();
        if (this.unmergeableAuxThreadContexts != null) {
            unmergedCount += this.unmergeableAuxThreadContexts.size();
        }
        if (unmergedCount < TRANSACTION_AUX_THREAD_CONTEXT_LIMIT) {
            return true;
        }
        if (this.stopMergingAuxThreadContexts) {
            return false;
        }
        ArrayList<ThreadContextImpl> mergeableAuxThreadContexts = Lists.newArrayList();
        ArrayList<ThreadContextImpl> unmergeableAuxThreadContexts = Lists.newArrayList();
        ArrayList<ThreadContextImpl> mergeableButIncompleteAuxThreadContexts = Lists.newArrayList();
        for (ThreadContextImpl auxThreadContext : this.auxThreadContexts) {
            if (!auxThreadContext.isMergeable()) {
                unmergeableAuxThreadContexts.add(auxThreadContext);
                continue;
            }
            if (auxThreadContext.isCompleted()) {
                mergeableAuxThreadContexts.add(auxThreadContext);
                continue;
            }
            mergeableButIncompleteAuxThreadContexts.add(auxThreadContext);
        }
        if ((double)mergeableAuxThreadContexts.size() < 0.01 * (double)TRANSACTION_AUX_THREAD_CONTEXT_LIMIT) {
            this.stopMergingAuxThreadContexts = true;
            return false;
        }
        this.initAlreadyMergedAuxComponentsIfNeeded();
        for (ThreadContextImpl mergeableAuxThreadContext : mergeableAuxThreadContexts) {
            this.mergeAux(mergeableAuxThreadContext);
        }
        if (this.unmergeableAuxThreadContexts == null) {
            this.unmergeableAuxThreadContexts = Lists.newArrayList(unmergeableAuxThreadContexts);
        } else {
            this.unmergeableAuxThreadContexts.addAll(unmergeableAuxThreadContexts);
        }
        this.auxThreadContexts = Lists.newArrayList(mergeableButIncompleteAuxThreadContexts);
        return true;
    }

    @GuardedBy(value="mainThreadContext")
    @EnsuresNonNull(value={"alreadyMergedAuxThreadTimers", "alreadyMergedAuxThreadStats", "alreadyMergedAuxQueries", "alreadyMergedAuxServiceCalls"})
    private void initAlreadyMergedAuxComponentsIfNeeded() {
        if (this.alreadyMergedAuxThreadTimers == null) {
            this.alreadyMergedAuxThreadTimers = new RootTimerCollectorImpl();
        }
        if (this.alreadyMergedAuxThreadStats == null) {
            this.alreadyMergedAuxThreadStats = new ThreadStatsCollectorImpl();
        }
        if (this.alreadyMergedAuxQueries == null) {
            this.alreadyMergedAuxQueries = new QueryCollector(this.maxQueryAggregates, 10);
        }
        if (this.alreadyMergedAuxServiceCalls == null) {
            this.alreadyMergedAuxServiceCalls = new ServiceCallCollector(this.maxServiceCallAggregates, 10);
        }
    }

    @GuardedBy(value="mainThreadContext")
    @RequiresNonNull(value={"alreadyMergedAuxThreadTimers", "alreadyMergedAuxThreadStats", "alreadyMergedAuxQueries", "alreadyMergedAuxServiceCalls"})
    private void mergeAux(ThreadContextImpl mergeableAuxThreadContext) {
        this.alreadyMergedAuxThreadTimers.mergeRootTimer(mergeableAuxThreadContext.getRootTimer());
        this.alreadyMergedAuxThreadStats.mergeThreadStats(mergeableAuxThreadContext.getThreadStats());
        mergeableAuxThreadContext.mergeQueriesInto(this.alreadyMergedAuxQueries);
        mergeableAuxThreadContext.mergeServiceCallsInto(this.alreadyMergedAuxServiceCalls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncComponents getOrInitAsyncComponents() {
        if (this.asyncComponents == null) {
            Object object = this.asyncComponentsInitLock;
            synchronized (object) {
                if (this.asyncComponents == null) {
                    this.asyncComponents = new AsyncComponents(this.maxQueryAggregates, this.maxServiceCallAggregates, this.ticker);
                }
            }
        }
        return this.asyncComponents;
    }

    private static void addProtobufChildEntries(TraceEntryImpl entry, ListMultimap<TraceEntryImpl, TraceEntryImpl> parentChildMap, long transactionStartTick, long captureTick, int depth, TraceEntryVisitor entryVisitor, SharedQueryTextCollection sharedQueryTextCollection, boolean removeSingleAuxEntry) {
        if (!parentChildMap.containsKey(entry)) {
            return;
        }
        List<TraceEntryImpl> childEntries = parentChildMap.get(entry);
        for (TraceEntryImpl childEntry : childEntries) {
            boolean singleAuxEntry;
            boolean bl = singleAuxEntry = childEntries.size() == 1 && childEntry.isAuxThreadRoot() && !childEntry.hasLocationStackTrace();
            if (singleAuxEntry && removeSingleAuxEntry) {
                Transaction.addProtobufChildEntries(childEntry, parentChildMap, transactionStartTick, captureTick, depth, entryVisitor, sharedQueryTextCollection, removeSingleAuxEntry);
                continue;
            }
            childEntry.accept(depth, transactionStartTick, captureTick, entryVisitor, sharedQueryTextCollection);
            Transaction.addProtobufChildEntries(childEntry, parentChildMap, transactionStartTick, captureTick, depth + 1, entryVisitor, sharedQueryTextCollection, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListMultimap<TraceEntryImpl, ThreadContextImpl> buildPriorEntryChildThreadContextMap() {
        ThreadContextImpl threadContextImpl = this.mainThreadContext;
        synchronized (threadContextImpl) {
            if (this.auxThreadContexts == null) {
                return ImmutableListMultimap.of();
            }
            ArrayListMultimap<TraceEntryImpl, ThreadContextImpl> parentChildMap = ArrayListMultimap.create();
            for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
                parentChildMap.put(Preconditions.checkNotNull(auxThreadContext.getParentThreadContextPriorEntry()), auxThreadContext);
            }
            return parentChildMap;
        }
    }

    @GuardedBy(value="mainThreadContext")
    private void detachIncompleteAuxThreadContexts() {
        if (this.auxThreadContexts == null) {
            return;
        }
        for (ThreadContextImpl auxThreadContext : this.getUnmergedAuxThreadContext()) {
            if (auxThreadContext.isCompleted()) continue;
            auxThreadContext.detach();
            if (!logger.isDebugEnabled()) continue;
            ThreadInfo threadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(auxThreadContext.getThreadId(), Integer.MAX_VALUE);
            if (!logger.isDebugEnabled() || this.isCompleted() || threadInfo == null) continue;
            StringBuilder sb = new StringBuilder();
            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                sb.append("    ");
                sb.append(stackTraceElement.toString());
                sb.append('\n');
            }
            logger.debug("auxiliary thread extended beyond the transaction which started it\n{}", (Object)sb);
        }
    }

    @GuardedBy(value="mainThreadContext")
    @RequiresNonNull(value={"auxThreadContexts"})
    private Iterable<ThreadContextImpl> getUnmergedAuxThreadContext() {
        if (this.unmergeableAuxThreadContexts == null) {
            if (this.unmergedLimitExceededAuxThreadContexts == null) {
                return this.auxThreadContexts;
            }
            return Iterables.concat(this.auxThreadContexts, this.unmergedLimitExceededAuxThreadContexts);
        }
        if (this.unmergedLimitExceededAuxThreadContexts == null) {
            return Iterables.concat(this.unmergeableAuxThreadContexts, this.auxThreadContexts);
        }
        return Iterables.concat(this.unmergeableAuxThreadContexts, this.auxThreadContexts, this.unmergedLimitExceededAuxThreadContexts);
    }

    static String buildTraceId(long startTime) {
        byte[] bytes = new byte[10];
        random.nextBytes(bytes);
        return Transaction.lowerSixBytesHex(startTime) + BaseEncoding.base16().lowerCase().encode(bytes);
    }

    static String lowerSixBytesHex(long startTime) {
        long mask = 0x1000000000000L;
        return Long.toHexString(mask | startTime & mask - 1L).substring(1);
    }

    private static class NopSharedQueryTextCollection
    implements SharedQueryTextCollection {
        private NopSharedQueryTextCollection() {
        }

        @Override
        public int getSharedQueryTextIndex(String queryText) {
            return 0;
        }
    }

    private static class SharedQueryTextCollectionImpl
    implements SharedQueryTextCollection {
        private final Map<String, Integer> sharedQueryTextIndexes = Maps.newHashMap();
        private List<String> sharedQueryTexts = Lists.newArrayList();

        private SharedQueryTextCollectionImpl() {
        }

        @Override
        public int getSharedQueryTextIndex(String queryText) {
            Integer sharedQueryTextIndex = this.sharedQueryTextIndexes.get(queryText);
            if (sharedQueryTextIndex == null) {
                sharedQueryTextIndex = this.sharedQueryTextIndexes.size();
                this.sharedQueryTextIndexes.put(queryText, sharedQueryTextIndex);
                this.sharedQueryTexts.add(queryText);
            }
            return sharedQueryTextIndex;
        }
    }

    private static class CountingEntryVisitor
    implements TraceEntryVisitor {
        private int count;

        private CountingEntryVisitor() {
        }

        @Override
        public void visitEntry(TraceOuterClass.Trace.Entry entry) {
            if (CountingEntryVisitor.countEntry(entry)) {
                ++this.count;
            }
        }

        private static boolean countEntry(TraceOuterClass.Trace.Entry entry) {
            return !entry.getMessage().equals(Transaction.AUXILIARY_THREAD_MESSAGE);
        }
    }

    private static class ParentChildMapTrimmer
    extends Traverser<TraceEntryImpl, RuntimeException> {
        private final ListMultimap<TraceEntryImpl, TraceEntryImpl> parentChildMap;
        private final long captureTick;

        private ParentChildMapTrimmer(TraceEntryImpl rootNode, ListMultimap<TraceEntryImpl, TraceEntryImpl> parentChildMap, long captureTick) {
            super(rootNode);
            this.parentChildMap = parentChildMap;
            this.captureTick = captureTick;
        }

        @Override
        public List<TraceEntryImpl> visit(TraceEntryImpl node, int depth) {
            if (!this.parentChildMap.containsKey(node)) {
                return ImmutableList.of();
            }
            return this.parentChildMap.get(node);
        }

        @Override
        public void revisitAfterChildren(TraceEntryImpl node) {
            TraceEntryImpl childEntry;
            if (!this.parentChildMap.containsKey(node)) {
                return;
            }
            List<TraceEntryImpl> childEntries = this.parentChildMap.get(node);
            ListIterator<TraceEntryImpl> i = childEntries.listIterator();
            while (i.hasNext()) {
                childEntry = i.next();
                if (childEntry.getStartTick() <= this.captureTick) continue;
                i.remove();
            }
            i = childEntries.listIterator();
            while (i.hasNext()) {
                TraceEntryImpl singleSubChildEntry;
                childEntry = i.next();
                if (!childEntry.isAuxThreadRoot() || childEntry.hasLocationStackTrace()) continue;
                if (!this.parentChildMap.containsKey(childEntry)) {
                    i.remove();
                    continue;
                }
                List<TraceEntryImpl> subChildEntries = this.parentChildMap.get(childEntry);
                if (subChildEntries.isEmpty()) {
                    i.remove();
                    continue;
                }
                if (subChildEntries.size() != 1 || !(singleSubChildEntry = subChildEntries.get(0)).isAuxThreadRoot()) continue;
                i.set(singleSubChildEntry);
            }
        }
    }

    private static class AuxThreadRootMessageSupplier
    extends MessageSupplier {
        private static final AuxThreadRootMessageSupplier INSTANCE = new AuxThreadRootMessageSupplier();
        private final Message message = Message.create("auxiliary thread");

        private AuxThreadRootMessageSupplier() {
        }

        @Override
        public Message get() {
            return this.message;
        }
    }

    public static interface TraceEntryVisitor {
        public void visitEntry(TraceOuterClass.Trace.Entry var1);
    }

    static interface ThreadStatsCollector {
        public void mergeThreadStats(ThreadStats var1);
    }

    static interface RootTimerCollector {
        public void mergeRootTimer(TransactionTimer var1);
    }

    static interface CompletionCallback {
        public void completed(Transaction var1);
    }
}

