/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.ThreadStats;
import org.glowroot.agent.shaded.org.glowroot.common.util.NotAvailableAware;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;

class ThreadStatsCollectorImpl
implements Transaction.ThreadStatsCollector {
    private long cpuNanos;
    private long blockedMillis;
    private long waitedMillis;
    private long allocatedBytes;

    ThreadStatsCollectorImpl() {
    }

    @Override
    public void mergeThreadStats(ThreadStats threadStats) {
        this.cpuNanos = NotAvailableAware.add(this.cpuNanos, threadStats.getCpuNanos());
        this.blockedMillis = NotAvailableAware.add(this.blockedMillis, threadStats.getBlockedMillis());
        this.waitedMillis = NotAvailableAware.add(this.waitedMillis, threadStats.getWaitedMillis());
        this.allocatedBytes = NotAvailableAware.add(this.allocatedBytes, threadStats.getAllocatedBytes());
    }

    ThreadStats getMergedThreadStats() {
        return new ThreadStats(this.cpuNanos, this.blockedMillis, this.waitedMillis, this.allocatedBytes);
    }

    long getCpuNanos() {
        return this.cpuNanos;
    }

    public TraceOuterClass.Trace.ThreadStats toProto() {
        return TraceOuterClass.Trace.ThreadStats.newBuilder().setCpuNanos(this.cpuNanos).setBlockedNanos(NotAvailableAware.millisToNanos(this.blockedMillis)).setWaitedNanos(NotAvailableAware.millisToNanos(this.waitedMillis)).setAllocatedBytes(this.allocatedBytes).build();
    }
}

