/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.lang.management.ThreadInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.bytecode.api.BytecodeServiceHolder;
import org.glowroot.agent.bytecode.api.ThreadContextPlus;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.impl.AuxThreadContextImpl;
import org.glowroot.agent.impl.NopTransactionService;
import org.glowroot.agent.impl.OptionalThreadContextImpl;
import org.glowroot.agent.impl.TimerImpl;
import org.glowroot.agent.impl.TraceEntryComponent;
import org.glowroot.agent.impl.TraceEntryImpl;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.AsyncQueryData;
import org.glowroot.agent.model.AsyncTimer;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.model.QueryCollector;
import org.glowroot.agent.model.QueryData;
import org.glowroot.agent.model.QueryDataMap;
import org.glowroot.agent.model.QueryEntryBase;
import org.glowroot.agent.model.ServiceCallCollector;
import org.glowroot.agent.model.SyncQueryData;
import org.glowroot.agent.model.ThreadStats;
import org.glowroot.agent.model.ThreadStatsComponent;
import org.glowroot.agent.model.TimerNameImpl;
import org.glowroot.agent.plugin.api.AsyncQueryEntry;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.QueryMessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.base.Ticker;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ListMultimap;
import org.glowroot.agent.shaded.com.google.common.primitives.Ints;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Checkers;
import org.glowroot.agent.util.ThreadAllocatedBytes;
import org.glowroot.agent.util.Tickers;

public class ThreadContextImpl
implements ThreadContextPlus {
    private static final boolean CAPTURE_AUXILIARY_THREAD_LOCATION_STACK_TRACES = Boolean.getBoolean("glowroot.debug.captureAuxiliaryThreadLocationStackTraces");
    private static final String LIMIT_EXCEEDED_BUCKET = "LIMIT EXCEEDED BUCKET";
    private static final MessageSupplier DETACHED_MESSAGE_SUPPLIER = MessageSupplier.create("this auxiliary thread was still running when the transaction ended");
    private static final Logger logger = LoggerFactory.getLogger(ThreadContextImpl.class);
    private final Transaction transaction;
    @Nullable
    private final TraceEntryImpl parentTraceEntry;
    @Nullable
    private final TraceEntryImpl parentThreadContextPriorEntry;
    private final TimerImpl rootTimer;
    @Nullable
    private TimerImpl currentTimer;
    private int currentNestingGroupId;
    private int currentSuppressionKeyId;
    @Nullable
    private final ThreadStatsComponent threadStatsComponent;
    private final TraceEntryComponent traceEntryComponent;
    private boolean transactionAsyncComplete;
    @MonotonicNonNull
    private SyncQueryData headQueryData;
    @MonotonicNonNull
    private SyncQueryData headServiceCallData;
    @MonotonicNonNull
    private QueryDataMap queriesForFirstType;
    @MonotonicNonNull
    private Map<String, QueryDataMap> allQueryTypesMap;
    @MonotonicNonNull
    private QueryDataMap serviceCallsForFirstType;
    @MonotonicNonNull
    private Map<String, QueryDataMap> allServiceCallTypesMap;
    private int queryAggregateCounter;
    private int serviceCallAggregateCounter;
    private final int maxQueryAggregates;
    private final int maxServiceCallAggregates;
    private final long threadId;
    private final boolean limitExceededAuxThreadContext;
    private final Ticker ticker;
    private final ThreadContextThreadLocal.Holder threadContextHolder;
    @Nullable
    private ThreadContext.ServletRequestInfo servletRequestInfo;
    private volatile boolean mayHaveChildAuxThreadContext;
    private volatile boolean detached;
    @Nullable
    private final ThreadContextImpl outerTransactionThreadContext;
    @Nullable
    private ThreadContextImpl innerTransactionThreadContext;

    ThreadContextImpl(Transaction transaction, @Nullable TraceEntryImpl parentTraceEntry, @Nullable TraceEntryImpl parentThreadContextPriorEntry, MessageSupplier messageSupplier, TimerName rootTimerName, long startTick, boolean captureThreadStats, int maxQueryAggregates, int maxServiceCallAggregates, @Nullable ThreadAllocatedBytes threadAllocatedBytes, boolean limitExceededAuxThreadContext, Ticker ticker, ThreadContextThreadLocal.Holder threadContextHolder, @Nullable ThreadContext.ServletRequestInfo servletRequestInfo, int rootNestingGroupId, int rootSuppressionKeyId) {
        this.transaction = transaction;
        this.parentTraceEntry = parentTraceEntry;
        this.rootTimer = TimerImpl.createRootTimer(Checkers.castInitialized(this), (TimerNameImpl)rootTimerName);
        this.rootTimer.start(startTick);
        this.traceEntryComponent = new TraceEntryComponent(Checkers.castInitialized(this), messageSupplier, this.rootTimer, startTick);
        this.parentThreadContextPriorEntry = parentThreadContextPriorEntry;
        this.threadId = Thread.currentThread().getId();
        this.threadStatsComponent = captureThreadStats ? new ThreadStatsComponent(threadAllocatedBytes) : null;
        this.maxQueryAggregates = maxQueryAggregates;
        this.maxServiceCallAggregates = maxServiceCallAggregates;
        this.limitExceededAuxThreadContext = limitExceededAuxThreadContext;
        this.ticker = ticker;
        this.threadContextHolder = threadContextHolder;
        this.servletRequestInfo = servletRequestInfo;
        this.outerTransactionThreadContext = (ThreadContextImpl)threadContextHolder.get();
        this.currentNestingGroupId = rootNestingGroupId;
        this.currentSuppressionKeyId = rootSuppressionKeyId;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Nullable
    TraceEntryImpl getParentThreadContextPriorEntry() {
        return this.parentThreadContextPriorEntry;
    }

    TraceEntryImpl getTailEntry() {
        return this.traceEntryComponent.getTailEntry();
    }

    TraceEntryImpl getRootEntry() {
        return this.traceEntryComponent.getRootEntry();
    }

    TimerImpl getRootTimer() {
        return this.rootTimer;
    }

    ThreadStats getThreadStats() {
        if (this.threadStatsComponent == null) {
            return ThreadStats.NA;
        }
        return this.threadStatsComponent.getThreadStats();
    }

    long getCpuNanos() {
        if (this.threadStatsComponent == null) {
            return -1L;
        }
        return this.threadStatsComponent.getCpuNanos();
    }

    public long getThreadId() {
        return this.threadId;
    }

    boolean isCompleted() {
        return this.traceEntryComponent.isCompleted();
    }

    public boolean isActive() {
        return !this.traceEntryComponent.isCompleted() && this.threadContextHolder.get() == this;
    }

    @Nullable
    public TimerImpl getCurrentTimer() {
        return this.currentTimer;
    }

    void setCurrentTimer(@Nullable TimerImpl currentTimer) {
        this.currentTimer = currentTimer;
    }

    @Override
    public int getCurrentNestingGroupId() {
        return this.currentNestingGroupId;
    }

    @Override
    public void setCurrentNestingGroupId(int nestingGroupId) {
        this.currentNestingGroupId = nestingGroupId;
    }

    @Override
    public int getCurrentSuppressionKeyId() {
        return this.currentSuppressionKeyId;
    }

    @Override
    public void setCurrentSuppressionKeyId(int suppressionKeyId) {
        this.currentSuppressionKeyId = suppressionKeyId;
    }

    boolean isMergeable() {
        return !this.mayHaveChildAuxThreadContext && this.traceEntryComponent.isEmpty();
    }

    void mergeQueriesInto(QueryCollector collector) {
        for (SyncQueryData curr = this.headQueryData; curr != null; curr = curr.getNextQueryData()) {
            collector.mergeQuery(curr.getQueryType(), curr.getQueryText(), curr.getTotalDurationNanos(this.ticker), curr.getExecutionCount(), curr.hasTotalRows(), curr.getTotalRows(), curr.isActive());
        }
    }

    void mergeServiceCallsInto(ServiceCallCollector collector) {
        for (SyncQueryData curr = this.headServiceCallData; curr != null; curr = curr.getNextQueryData()) {
            collector.mergeServiceCall(curr.getQueryType(), curr.getQueryText(), curr.getTotalDurationNanos(this.ticker), curr.getExecutionCount());
        }
    }

    boolean getCaptureThreadStats() {
        return this.threadStatsComponent != null;
    }

    private boolean isCompleted(long captureTick) {
        if (!this.traceEntryComponent.isCompleted()) {
            return false;
        }
        return this.traceEntryComponent.getEndTick() >= captureTick;
    }

    private SyncQueryData getOrCreateQueryData(String queryType, String queryText, boolean bypassLimit) {
        SyncQueryData queryData;
        if (this.headQueryData == null) {
            this.queriesForFirstType = new QueryDataMap(queryType);
            return this.createQueryData(this.queriesForFirstType, queryType, queryText, bypassLimit);
        }
        QueryDataMap queriesForType = Preconditions.checkNotNull(this.queriesForFirstType);
        if (!queriesForType.getType().equals(queryType)) {
            queriesForType = this.getOrCreateQueriesForType(queryType);
        }
        if ((queryData = queriesForType.get(queryText)) == null) {
            queryData = this.createQueryData(queriesForType, queryType, queryText, bypassLimit);
        }
        return queryData;
    }

    private SyncQueryData createQueryData(QueryDataMap queriesForType, String queryType, String queryText, boolean bypassLimit) {
        if (this.allowAnotherQueryAggregate(bypassLimit)) {
            return this.createQueryData(queriesForType, queryType, queryText);
        }
        SyncQueryData limitExceededBucket = queriesForType.get(LIMIT_EXCEEDED_BUCKET);
        if (limitExceededBucket == null) {
            limitExceededBucket = this.createQueryData(queriesForType, queryType, LIMIT_EXCEEDED_BUCKET);
        }
        return new SyncQueryData(queryType, queryText, null, limitExceededBucket);
    }

    private SyncQueryData createQueryData(QueryDataMap queriesForType, String queryType, String queryText) {
        SyncQueryData queryData = new SyncQueryData(queryType, queryText, this.headQueryData, null);
        queriesForType.put(queryText, queryData);
        this.headQueryData = queryData;
        return queryData;
    }

    private SyncQueryData getOrCreateServiceCallData(String serviceCallType, String serviceCallText, boolean bypassLimit) {
        SyncQueryData serviceCallData;
        if (this.headServiceCallData == null) {
            this.serviceCallsForFirstType = new QueryDataMap(serviceCallType);
            return this.createServiceCallData(this.serviceCallsForFirstType, serviceCallType, serviceCallText, bypassLimit);
        }
        QueryDataMap serviceCallsForType = Preconditions.checkNotNull(this.serviceCallsForFirstType);
        if (!serviceCallsForType.getType().equals(serviceCallType)) {
            serviceCallsForType = this.getOrCreateServiceCallsForType(serviceCallType);
        }
        if ((serviceCallData = serviceCallsForType.get(serviceCallText)) == null) {
            serviceCallData = this.createServiceCallData(serviceCallsForType, serviceCallType, serviceCallText, bypassLimit);
        }
        return serviceCallData;
    }

    private SyncQueryData createServiceCallData(QueryDataMap serviceCallsForType, String serviceCallType, String serviceCallText, boolean bypassLimit) {
        if (this.allowAnotherServiceCallAggregate(bypassLimit)) {
            return this.createServiceCallData(serviceCallsForType, serviceCallType, serviceCallText);
        }
        SyncQueryData limitExceededBucket = serviceCallsForType.get(LIMIT_EXCEEDED_BUCKET);
        if (limitExceededBucket == null) {
            limitExceededBucket = this.createServiceCallData(serviceCallsForType, serviceCallType, LIMIT_EXCEEDED_BUCKET);
        }
        return new SyncQueryData(serviceCallType, serviceCallText, null, limitExceededBucket);
    }

    private SyncQueryData createServiceCallData(QueryDataMap serviceCallsForType, String serviceCallType, String serviceCallText) {
        SyncQueryData serviceCallData = new SyncQueryData(serviceCallType, serviceCallText, this.headServiceCallData, null);
        serviceCallsForType.put(serviceCallText, serviceCallData);
        this.headServiceCallData = serviceCallData;
        return serviceCallData;
    }

    private boolean allowAnotherQueryAggregate(boolean bypassLimit) {
        return this.queryAggregateCounter++ < this.maxQueryAggregates * 10 || bypassLimit;
    }

    private boolean allowAnotherServiceCallAggregate(boolean bypassLimit) {
        return this.serviceCallAggregateCounter++ < this.maxServiceCallAggregates * 10 || bypassLimit;
    }

    TraceEntryImpl addErrorEntry(long startTick, long endTick, @Nullable Object messageSupplier, @Nullable QueryData queryData, ErrorMessage errorMessage) {
        TraceEntryImpl entry = this.traceEntryComponent.addErrorEntry(startTick, endTick, messageSupplier, queryData, errorMessage);
        this.transaction.memoryBarrierReadWrite();
        return entry;
    }

    private TraceEntryImpl startAsyncTraceEntry(long startTick, MessageSupplier messageSupplier, TimerImpl syncTimer, AsyncTimer asyncTimer) {
        TraceEntryImpl entry = this.traceEntryComponent.pushEntry(startTick, messageSupplier, syncTimer, asyncTimer, null, 0L);
        this.transaction.memoryBarrierReadWrite();
        return entry;
    }

    private TraceEntryImpl startAsyncQueryEntry(long startTick, QueryMessageSupplier queryMessageSupplier, TimerImpl syncTimer, AsyncTimer asyncTimer, @Nullable QueryData queryData, long queryExecutionCount) {
        TraceEntryImpl entry = this.traceEntryComponent.pushEntry(startTick, queryMessageSupplier, syncTimer, asyncTimer, queryData, queryExecutionCount);
        this.transaction.memoryBarrierReadWrite();
        return entry;
    }

    private TraceEntryImpl startAsyncServiceCallEntry(long startTick, MessageSupplier messageSupplier, TimerImpl syncTimer, AsyncTimer asyncTimer, @Nullable QueryData queryData) {
        TraceEntryImpl entry = this.traceEntryComponent.pushEntry(startTick, messageSupplier, syncTimer, asyncTimer, queryData, 1L);
        this.transaction.memoryBarrierReadWrite();
        return entry;
    }

    void captureStackTrace(ThreadInfo threadInfo) {
        this.transaction.captureStackTrace(this.isAuxiliary(), threadInfo);
        this.transaction.memoryBarrierRead();
    }

    @Override
    public AuxThreadContext createAuxThreadContext() {
        List locationStackTrace = null;
        if (CAPTURE_AUXILIARY_THREAD_LOCATION_STACK_TRACES) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int index = ThreadContextImpl.getNormalizedStartIndex(stackTrace, "createAuxThreadContext", 1);
            locationStackTrace = ImmutableList.copyOf(stackTrace).subList(index, stackTrace.length);
        }
        if (this.limitExceededAuxThreadContext) {
            return new AuxThreadContextImpl(this.transaction, null, null, this.servletRequestInfo, (ImmutableList<StackTraceElement>)locationStackTrace, this.transaction.getTransactionRegistry(), this.transaction.getTransactionService());
        }
        this.mayHaveChildAuxThreadContext = true;
        return new AuxThreadContextImpl(this.transaction, this.traceEntryComponent.getActiveEntry(), this.traceEntryComponent.getTailEntry(), this.servletRequestInfo, (ImmutableList<StackTraceElement>)locationStackTrace, this.transaction.getTransactionRegistry(), this.transaction.getTransactionService());
    }

    void popEntry(TraceEntryImpl entry, long endTick) {
        this.traceEntryComponent.popEntry(entry, endTick);
        this.transaction.memoryBarrierReadWrite();
        if (this.traceEntryComponent.isCompleted()) {
            if (this.threadStatsComponent != null) {
                this.threadStatsComponent.onComplete();
            }
            if (this.limitExceededAuxThreadContext) {
                this.transaction.mergeLimitExceededAuxThreadContext(this);
            }
            if (!this.isAuxiliary() || this.transactionAsyncComplete) {
                this.transaction.end(endTick, this.transactionAsyncComplete, false);
            }
            this.threadContextHolder.set(this.outerTransactionThreadContext);
            if (this.outerTransactionThreadContext != null) {
                this.outerTransactionThreadContext.innerTransactionThreadContext = null;
            }
        }
    }

    void popNonRootEntry(TraceEntryImpl entry) {
        this.traceEntryComponent.popNonRootEntry(entry);
        this.transaction.memoryBarrierReadWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        ThreadContextThreadLocal.Holder holder = this.threadContextHolder;
        synchronized (holder) {
            if (this.threadContextHolder.get() == this) {
                this.threadContextHolder.set(null);
            }
        }
        this.transaction.memoryBarrierWrite();
        this.detached = true;
    }

    private QueryDataMap getOrCreateQueriesForType(String queryType) {
        if (this.allQueryTypesMap == null) {
            this.allQueryTypesMap = new HashMap<String, QueryDataMap>(2);
            QueryDataMap queriesForType = new QueryDataMap(queryType);
            this.allQueryTypesMap.put(queryType, queriesForType);
            return queriesForType;
        }
        QueryDataMap queriesForType = this.allQueryTypesMap.get(queryType);
        if (queriesForType == null) {
            queriesForType = new QueryDataMap(queryType);
            this.allQueryTypesMap.put(queryType, queriesForType);
        }
        return queriesForType;
    }

    private QueryDataMap getOrCreateServiceCallsForType(String type) {
        if (this.allServiceCallTypesMap == null) {
            this.allServiceCallTypesMap = new HashMap<String, QueryDataMap>(2);
            QueryDataMap serviceCallsForType = new QueryDataMap(type);
            this.allServiceCallTypesMap.put(type, serviceCallsForType);
            return serviceCallsForType;
        }
        QueryDataMap serviceCallsForType = this.allServiceCallTypesMap.get(type);
        if (serviceCallsForType == null) {
            serviceCallsForType = new QueryDataMap(type);
            this.allServiceCallTypesMap.put(type, serviceCallsForType);
        }
        return serviceCallsForType;
    }

    @Override
    public boolean isInTransaction() {
        return true;
    }

    @Override
    public TraceEntry startTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName) {
        return this.startTransaction(transactionType, transactionName, messageSupplier, timerName, OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_TRACE_ENTRY);
    }

    @Override
    public TraceEntry startTransaction(String transactionType, String transactionName, MessageSupplier messageSupplier, TimerName timerName, OptionalThreadContext.AlreadyInTransactionBehavior alreadyInTransactionBehavior) {
        if (transactionType == null) {
            logger.error("startTransaction(): argument 'transactionType' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (transactionName == null) {
            logger.error("startTransaction(): argument 'transactionName' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (messageSupplier == null) {
            logger.error("startTransaction(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (timerName == null) {
            logger.error("startTransaction(): argument 'timerName' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        this.transaction.getConfigService().readMemoryBarrier();
        if (this.transaction.isOuter() || alreadyInTransactionBehavior == OptionalThreadContext.AlreadyInTransactionBehavior.CAPTURE_NEW_TRANSACTION) {
            TraceEntryImpl traceEntry = this.transaction.startInnerTransaction(transactionType, transactionName, messageSupplier, timerName, this.threadContextHolder, this.currentNestingGroupId, this.currentSuppressionKeyId);
            this.innerTransactionThreadContext = (ThreadContextImpl)Preconditions.checkNotNull(this.threadContextHolder.get());
            return traceEntry;
        }
        long startTick = this.ticker.read();
        TimerImpl timer = this.startTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            return this.traceEntryComponent.pushEntry(startTick, messageSupplier, timer, null, null, 0L);
        }
        return new DummyTraceEntryOrQuery(timer, null, startTick, messageSupplier, null, 0L);
    }

    @Override
    public TraceEntry startTraceEntry(MessageSupplier messageSupplier, TimerName timerName) {
        if (messageSupplier == null) {
            logger.error("startTraceEntry(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (timerName == null) {
            logger.error("startTraceEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        long startTick = this.ticker.read();
        TimerImpl timer = this.startTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            return this.traceEntryComponent.pushEntry(startTick, messageSupplier, timer, null, null, 0L);
        }
        return new DummyTraceEntryOrQuery(timer, null, startTick, messageSupplier, null, 0L);
    }

    @Override
    public AsyncTraceEntry startAsyncTraceEntry(MessageSupplier messageSupplier, TimerName timerName) {
        if (messageSupplier == null) {
            logger.error("startAsyncTraceEntry(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.ASYNC_TRACE_ENTRY;
        }
        if (timerName == null) {
            logger.error("startAsyncTraceEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.ASYNC_TRACE_ENTRY;
        }
        long startTick = this.ticker.read();
        TimerImpl syncTimer = this.startTimer(timerName, startTick);
        AsyncTimer asyncTimer = this.transaction.startAsyncTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            return this.startAsyncTraceEntry(startTick, messageSupplier, syncTimer, asyncTimer);
        }
        return new DummyTraceEntryOrQuery(syncTimer, asyncTimer, startTick, messageSupplier, null, 0L);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (queryType == null) {
            logger.error("startQueryEntry(): argument 'queryType' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        if (queryText == null) {
            logger.error("startQueryEntry(): argument 'queryText' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        if (queryMessageSupplier == null) {
            logger.error("startQueryEntry(): argument 'queryMessageSupplier' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        if (timerName == null) {
            logger.error("startQueryEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        long startTick = this.ticker.read();
        TimerImpl timer = this.startTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            SyncQueryData queryData = this.getOrCreateQueryData(queryType, queryText, true);
            return this.traceEntryComponent.pushEntry(startTick, queryMessageSupplier, timer, null, queryData, 1L);
        }
        SyncQueryData queryData = this.getOrCreateQueryData(queryType, queryText, false);
        return new DummyTraceEntryOrQuery(timer, null, startTick, queryMessageSupplier, queryData, 1L);
    }

    @Override
    public QueryEntry startQueryEntry(String queryType, String queryText, long queryExecutionCount, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (queryType == null) {
            logger.error("startQueryEntry(): argument 'queryType' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        if (queryText == null) {
            logger.error("startQueryEntry(): argument 'queryText' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        if (queryExecutionCount <= 0L) {
            logger.error("startQueryEntry(): argument 'queryExecutionCount' must be positive");
            return NopTransactionService.QUERY_ENTRY;
        }
        if (queryMessageSupplier == null) {
            logger.error("startQueryEntry(): argument 'queryMessageSupplier' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        if (timerName == null) {
            logger.error("startQueryEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.QUERY_ENTRY;
        }
        long startTick = this.ticker.read();
        TimerImpl timer = this.startTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            SyncQueryData queryData = this.getOrCreateQueryData(queryType, queryText, true);
            return this.traceEntryComponent.pushEntry(startTick, queryMessageSupplier, timer, null, queryData, queryExecutionCount);
        }
        SyncQueryData queryData = this.getOrCreateQueryData(queryType, queryText, false);
        return new DummyTraceEntryOrQuery(timer, null, startTick, queryMessageSupplier, queryData, queryExecutionCount);
    }

    @Override
    public AsyncQueryEntry startAsyncQueryEntry(String queryType, String queryText, QueryMessageSupplier queryMessageSupplier, TimerName timerName) {
        if (queryType == null) {
            logger.error("startAsyncQueryEntry(): argument 'queryType' must be non-null");
            return NopTransactionService.ASYNC_QUERY_ENTRY;
        }
        if (queryText == null) {
            logger.error("startAsyncQueryEntry(): argument 'queryText' must be non-null");
            return NopTransactionService.ASYNC_QUERY_ENTRY;
        }
        if (queryMessageSupplier == null) {
            logger.error("startAsyncQueryEntry(): argument 'queryMessageSupplier' must be non-null");
            return NopTransactionService.ASYNC_QUERY_ENTRY;
        }
        if (timerName == null) {
            logger.error("startAsyncQueryEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.ASYNC_QUERY_ENTRY;
        }
        long startTick = this.ticker.read();
        TimerImpl syncTimer = this.startTimer(timerName, startTick);
        AsyncTimer asyncTimer = this.transaction.startAsyncTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            AsyncQueryData queryData = this.transaction.getOrCreateAsyncQueryData(queryType, queryText, true);
            return this.startAsyncQueryEntry(startTick, queryMessageSupplier, syncTimer, asyncTimer, queryData, 1L);
        }
        AsyncQueryData queryData = this.transaction.getOrCreateAsyncQueryData(queryType, queryText, false);
        return new DummyTraceEntryOrQuery(syncTimer, asyncTimer, startTick, queryMessageSupplier, queryData, 1L);
    }

    @Override
    public TraceEntry startServiceCallEntry(String serviceCallType, String serviceCallText, MessageSupplier messageSupplier, TimerName timerName) {
        if (serviceCallType == null) {
            logger.error("startServiceCallEntry(): argument 'serviceCallType' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (serviceCallText == null) {
            logger.error("startServiceCallEntry(): argument 'serviceCallText' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (messageSupplier == null) {
            logger.error("startServiceCallEntry(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        if (timerName == null) {
            logger.error("startServiceCallEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.TRACE_ENTRY;
        }
        long startTick = this.ticker.read();
        TimerImpl timer = this.startTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            SyncQueryData queryData = this.getOrCreateServiceCallData(serviceCallType, serviceCallText, true);
            return this.traceEntryComponent.pushEntry(startTick, messageSupplier, timer, null, queryData, 1L);
        }
        SyncQueryData queryData = this.getOrCreateServiceCallData(serviceCallType, serviceCallText, false);
        return new DummyTraceEntryOrQuery(timer, null, startTick, messageSupplier, queryData, 1L);
    }

    @Override
    public AsyncTraceEntry startAsyncServiceCallEntry(String serviceCallType, String serviceCallText, MessageSupplier messageSupplier, TimerName timerName) {
        if (serviceCallType == null) {
            logger.error("startAsyncServiceCallEntry(): argument 'serviceCallType' must be non-null");
            return NopTransactionService.ASYNC_TRACE_ENTRY;
        }
        if (serviceCallText == null) {
            logger.error("startAsyncServiceCallEntry(): argument 'serviceCallText' must be non-null");
            return NopTransactionService.ASYNC_TRACE_ENTRY;
        }
        if (messageSupplier == null) {
            logger.error("startAsyncServiceCallEntry(): argument 'messageSupplier' must be non-null");
            return NopTransactionService.ASYNC_TRACE_ENTRY;
        }
        if (timerName == null) {
            logger.error("startAsyncServiceCallEntry(): argument 'timerName' must be non-null");
            return NopTransactionService.ASYNC_TRACE_ENTRY;
        }
        long startTick = this.ticker.read();
        TimerImpl syncTimer = this.startTimer(timerName, startTick);
        AsyncTimer asyncTimer = this.transaction.startAsyncTimer(timerName, startTick);
        if (this.transaction.allowAnotherEntry()) {
            AsyncQueryData queryData = this.transaction.getOrCreateAsyncServiceCallData(serviceCallType, serviceCallText, true);
            return this.startAsyncServiceCallEntry(startTick, messageSupplier, syncTimer, asyncTimer, queryData);
        }
        AsyncQueryData queryData = this.transaction.getOrCreateAsyncServiceCallData(serviceCallType, serviceCallText, false);
        return new DummyTraceEntryOrQuery(syncTimer, asyncTimer, startTick, messageSupplier, queryData, 1L);
    }

    @Override
    public Timer startTimer(TimerName timerName) {
        if (timerName == null) {
            logger.error("startTimer(): argument 'timerName' must be non-null");
            return NopTransactionService.NopTimer.INSTANCE;
        }
        if (this.currentTimer == null) {
            logger.warn("startTimer(): called on completed thread context");
            return NopTransactionService.NopTimer.INSTANCE;
        }
        return this.currentTimer.startNestedTimer(timerName);
    }

    @Override
    public void setTransactionAsync() {
        if (this.innerTransactionThreadContext == null) {
            if (logger.isDebugEnabled() && AuxThreadContextImpl.inAuxDebugLogging.get() == null) {
                AuxThreadContextImpl.inAuxDebugLogging.set(Boolean.TRUE);
                try {
                    logger.debug("set async transaction, thread context: {}, parent thread context: {}, thread name: {}", this.hashCode(), this.getParentThreadContextDisplay(), Thread.currentThread().getName(), new Exception());
                }
                finally {
                    AuxThreadContextImpl.inAuxDebugLogging.remove();
                }
            }
            this.transaction.setAsync();
        } else {
            this.innerTransactionThreadContext.setTransactionAsync();
        }
    }

    @Override
    public void setTransactionAsyncComplete() {
        if (this.innerTransactionThreadContext == null) {
            if (logger.isDebugEnabled() && AuxThreadContextImpl.inAuxDebugLogging.get() == null) {
                AuxThreadContextImpl.inAuxDebugLogging.set(Boolean.TRUE);
                try {
                    logger.debug("set async transaction complete, thread context: {}, parent thread context: {}, thread name: {}", this.hashCode(), this.getParentThreadContextDisplay(), Thread.currentThread().getName(), new Exception());
                }
                finally {
                    AuxThreadContextImpl.inAuxDebugLogging.remove();
                }
            }
            this.transactionAsyncComplete = true;
            if (this.isCompleted()) {
                this.transaction.end(this.ticker.read(), true, true);
            } else {
                this.transaction.setWaitingToEndAsync();
            }
        } else {
            this.innerTransactionThreadContext.setTransactionAsyncComplete();
        }
    }

    @Override
    public void setTransactionOuter() {
        if (this.innerTransactionThreadContext == null) {
            this.transaction.setOuter();
        } else {
            this.innerTransactionThreadContext.setTransactionOuter();
        }
    }

    @Override
    public void setTransactionType(@Nullable String transactionType, int priority) {
        if (Strings.isNullOrEmpty(transactionType)) {
            return;
        }
        if (this.innerTransactionThreadContext == null) {
            this.transaction.setTransactionType(transactionType, priority);
        } else {
            this.innerTransactionThreadContext.setTransactionType(transactionType, priority);
        }
    }

    @Override
    public void setTransactionName(@Nullable String transactionName, int priority) {
        if (Strings.isNullOrEmpty(transactionName)) {
            return;
        }
        if (this.innerTransactionThreadContext == null) {
            this.transaction.setTransactionName(transactionName, priority);
        } else {
            this.innerTransactionThreadContext.setTransactionName(transactionName, priority);
        }
    }

    @Override
    public void setTransactionUser(@Nullable String user, int priority) {
        if (Strings.isNullOrEmpty(user)) {
            return;
        }
        if (this.innerTransactionThreadContext == null) {
            this.transaction.setUser(user, priority);
        } else {
            this.innerTransactionThreadContext.setTransactionUser(user, priority);
        }
    }

    @Override
    public void addTransactionAttribute(String name, @Nullable String value) {
        if (name == null) {
            logger.error("addTransactionAttribute(): argument 'name' must be non-null");
            return;
        }
        if (this.innerTransactionThreadContext == null) {
            this.transaction.addAttribute(name, value);
        } else {
            this.innerTransactionThreadContext.addTransactionAttribute(name, value);
        }
    }

    @Override
    public void setTransactionSlowThreshold(long threshold, TimeUnit unit, int priority) {
        if (threshold < 0L) {
            logger.error("setTransactionSlowThreshold(): argument 'threshold' must be non-negative");
            return;
        }
        if (unit == null) {
            logger.error("setTransactionSlowThreshold(): argument 'unit' must be non-null");
            return;
        }
        if (this.innerTransactionThreadContext == null) {
            int thresholdMillis = Ints.saturatedCast(unit.toMillis(threshold));
            this.transaction.setSlowThresholdMillis(thresholdMillis, priority);
        } else {
            this.innerTransactionThreadContext.setTransactionSlowThreshold(threshold, unit, priority);
        }
    }

    @Override
    public void setTransactionError(Throwable t) {
        if (this.innerTransactionThreadContext == null) {
            this.transaction.setError(null, t);
        } else {
            this.innerTransactionThreadContext.setTransactionError(t);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message) {
        if (Strings.isNullOrEmpty(message)) {
            return;
        }
        if (this.innerTransactionThreadContext == null) {
            this.transaction.setError(message, null);
        } else {
            this.innerTransactionThreadContext.setTransactionError(message);
        }
    }

    @Override
    public void setTransactionError(@Nullable String message, @Nullable Throwable t) {
        if (this.innerTransactionThreadContext == null) {
            this.transaction.setError(message, t);
        } else {
            this.innerTransactionThreadContext.setTransactionError(message, t);
        }
    }

    @Override
    public void addErrorEntry(Throwable t) {
        this.addErrorEntryInternal(null, t);
    }

    @Override
    public void addErrorEntry(@Nullable String message) {
        this.addErrorEntryInternal(message, null);
    }

    @Override
    public void addErrorEntry(@Nullable String message, Throwable t) {
        this.addErrorEntryInternal(message, t);
    }

    @Override
    public void trackResourceAcquired(Object resource, boolean withLocationStackTrace) {
        this.transaction.trackResourceAcquired(resource, withLocationStackTrace);
    }

    @Override
    public void trackResourceReleased(Object resource) {
        this.transaction.trackResourceReleased(resource);
    }

    @Override
    @Nullable
    public ThreadContext.ServletRequestInfo getServletRequestInfo() {
        return this.servletRequestInfo;
    }

    @Override
    public void setServletRequestInfo(@Nullable ThreadContext.ServletRequestInfo servletRequestInfo) {
        this.servletRequestInfo = servletRequestInfo;
    }

    boolean hasTraceEntries() {
        return !this.traceEntryComponent.isEmpty();
    }

    void populateParentChildMap(ListMultimap<TraceEntryImpl, TraceEntryImpl> parentChildMap, long captureTick, ListMultimap<TraceEntryImpl, ThreadContextImpl> priorEntryAuxThreadContextMap) {
        if (captureTick < this.traceEntryComponent.getStartTick()) {
            return;
        }
        boolean completed = this.isCompleted(captureTick);
        TraceEntryImpl entry = this.getRootEntry();
        boolean entryIsRoot = true;
        while (entry != null && (completed || Tickers.lessThanOrEqual(entry.getStartTick(), captureTick))) {
            TraceEntryImpl parentTraceEntry = entry.getParentTraceEntry();
            if (parentTraceEntry == null && !entryIsRoot) {
                logger.error("found non-root trace entry with null parent trace entry\ntrace entry: {}\ntransaction: {} - {}", entry, this.transaction.getTransactionType(), this.transaction.getTransactionName());
                entry = entry.getNextTraceEntry();
                continue;
            }
            if (!entryIsRoot) {
                parentChildMap.put(parentTraceEntry, entry);
            }
            for (ThreadContextImpl auxThreadContext : priorEntryAuxThreadContextMap.get(entry)) {
                TraceEntryImpl auxThreadRootEntry = auxThreadContext.getRootEntry();
                if (!completed && !Tickers.lessThanOrEqual(auxThreadRootEntry.getStartTick(), captureTick)) continue;
                parentChildMap.put(Preconditions.checkNotNull(auxThreadContext.parentTraceEntry), auxThreadRootEntry);
            }
            entry = entry.getNextTraceEntry();
            entryIsRoot = false;
        }
        if (this.detached && !this.traceEntryComponent.isEmpty()) {
            TraceEntryImpl rootEntry = this.getRootEntry();
            parentChildMap.put(rootEntry, new TraceEntryImpl(this, rootEntry, DETACHED_MESSAGE_SUPPLIER, null, 0L, this.transaction.getEndTick(), null, null));
        }
    }

    private boolean isAuxiliary() {
        return this.parentTraceEntry != null;
    }

    private void addErrorEntryInternal(@Nullable String message, @Nullable Throwable t) {
        if (this.transaction.allowAnotherErrorEntry()) {
            long currTick = this.ticker.read();
            ErrorMessage errorMessage = ErrorMessage.create(message, t, this.transaction.getThrowableFrameLimitCounter());
            this.addErrorEntry(currTick, currTick, null, null, errorMessage);
        }
    }

    private TimerImpl startTimer(TimerName timerName, long startTick) {
        if (this.currentTimer == null) {
            return TimerImpl.createRootTimer(this, (TimerNameImpl)timerName);
        }
        return this.currentTimer.startNestedTimer(timerName, startTick);
    }

    @Nullable
    private Object getParentThreadContextDisplay() {
        if (this.parentTraceEntry == null) {
            return null;
        }
        return this.parentTraceEntry.getThreadContext().hashCode();
    }

    static int getNormalizedStartIndex(StackTraceElement[] locationStackTrace, String methodName, int additionalMethodsToSkip) {
        for (int i = 0; i < locationStackTrace.length; ++i) {
            if (!methodName.equals(locationStackTrace[i].getMethodName())) continue;
            if (methodName.equals(locationStackTrace[i + 1].getMethodName()) && OptionalThreadContextImpl.class.getName().equals(locationStackTrace[i + 1].getClassName())) {
                ++i;
            }
            return i + 1 + additionalMethodsToSkip;
        }
        return 0;
    }

    private class DummyTraceEntryOrQuery
    extends QueryEntryBase
    implements AsyncQueryEntry,
    Timer {
        private final TimerImpl syncTimer;
        @Nullable
        private final AsyncTimer asyncTimer;
        private final long startTick;
        private final Object messageSupplier;
        private int selfNestingLevel;
        @Nullable
        private TimerImpl extendedTimer;
        private boolean initialComplete;

        public DummyTraceEntryOrQuery(@Nullable TimerImpl syncTimer, AsyncTimer asyncTimer, long startTick, @Nullable Object messageSupplier, QueryData queryData, long queryExecutionCount) {
            super(queryData, startTick, queryExecutionCount);
            this.syncTimer = syncTimer;
            this.asyncTimer = asyncTimer;
            this.startTick = startTick;
            this.messageSupplier = messageSupplier;
        }

        @Override
        public void end() {
            this.endInternal(ThreadContextImpl.this.ticker.read());
        }

        @Override
        public void endWithLocationStackTrace(long threshold, TimeUnit unit) {
            if (threshold < 0L) {
                logger.error("endWithLocationStackTrace(): argument 'threshold' must be non-negative");
            }
            this.endInternal(ThreadContextImpl.this.ticker.read());
        }

        @Override
        public void endWithError(Throwable t) {
            this.endWithErrorInternal(null, t);
        }

        @Override
        public void endWithError(@Nullable String message) {
            this.endWithErrorInternal(message, null);
        }

        @Override
        public void endWithError(@Nullable String message, Throwable t) {
            this.endWithErrorInternal(message, t);
        }

        @Override
        public void endWithInfo(Throwable t) {
            this.endInternal(ThreadContextImpl.this.ticker.read());
        }

        private void endWithErrorInternal(@Nullable String message, @Nullable Throwable t) {
            if (this.initialComplete) {
                return;
            }
            long endTick = ThreadContextImpl.this.ticker.read();
            this.endInternal(endTick);
            if (ThreadContextImpl.this.transaction.allowAnotherErrorEntry()) {
                ErrorMessage errorMessage = ErrorMessage.create(message, t, ThreadContextImpl.this.transaction.getThrowableFrameLimitCounter());
                ThreadContextImpl.this.addErrorEntry(this.startTick, endTick, this.messageSupplier, this.getQueryData(), errorMessage);
            }
        }

        private void endInternal(long endTick) {
            if (this.initialComplete) {
                return;
            }
            if (this.asyncTimer == null) {
                this.syncTimer.end(endTick);
            } else {
                this.asyncTimer.end(endTick);
            }
            this.endQueryData(endTick);
            this.initialComplete = true;
        }

        @Override
        public Timer extend() {
            if (this.selfNestingLevel++ == 0) {
                if (this.isAsync()) {
                    this.extendAsync();
                } else {
                    TimerImpl currentTimerLocal = ThreadContextImpl.this.currentTimer;
                    if (currentTimerLocal == null) {
                        --this.selfNestingLevel;
                        return NopTransactionService.NopTimer.INSTANCE;
                    }
                    this.extendSync(ThreadContextImpl.this.ticker.read(), currentTimerLocal);
                }
            }
            return this;
        }

        private void extendSync(long currTick, TimerImpl currentTimer) {
            this.extendedTimer = this.syncTimer.extend(currTick, currentTimer);
            this.extendQueryData(currTick);
        }

        @RequiresNonNull(value={"asyncTimer"})
        private void extendAsync() {
            ThreadContextThreadLocal.Holder holder = BytecodeServiceHolder.get().getCurrentThreadContextHolder();
            ThreadContextPlus currThreadContext = holder.get();
            long currTick = ThreadContextImpl.this.ticker.read();
            if (currThreadContext == ThreadContextImpl.this) {
                this.extendSync(currTick, Preconditions.checkNotNull(ThreadContextImpl.this.getCurrentTimer()));
            } else {
                this.extendedTimer = null;
                this.extendQueryData(currTick);
            }
            this.asyncTimer.extend(currTick);
        }

        @Override
        public void stop() {
            if (--this.selfNestingLevel == 0) {
                if (this.isAsync()) {
                    this.stopAsync();
                } else {
                    this.stopSync(ThreadContextImpl.this.ticker.read());
                }
            }
        }

        private void stopSync(long endTick) {
            Preconditions.checkNotNull(this.extendedTimer).end(endTick);
            this.endQueryData(endTick);
        }

        @RequiresNonNull(value={"asyncTimer"})
        private void stopAsync() {
            long endTick = ThreadContextImpl.this.ticker.read();
            if (this.extendedTimer == null) {
                this.endQueryData(endTick);
            } else {
                this.stopSync(endTick);
            }
            this.asyncTimer.end(endTick);
        }

        @Override
        public Object getMessageSupplier() {
            return this.messageSupplier;
        }

        @Override
        public void stopSyncTimer() {
            this.syncTimer.stop();
        }

        @Override
        public Timer extendSyncTimer(ThreadContext currThreadContext) {
            if (currThreadContext != this) {
                return NopTransactionService.NopTimer.INSTANCE;
            }
            return this.syncTimer.extend(Preconditions.checkNotNull(ThreadContextImpl.this.getCurrentTimer()));
        }

        @EnsuresNonNullIf(expression={"asyncTimer"}, result=true)
        private boolean isAsync() {
            return this.asyncTimer != null;
        }
    }
}

