/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class StackTraceCollector {
    private static final Logger logger = LoggerFactory.getLogger(StackTraceCollector.class);
    private final TransactionRegistry transactionRegistry;
    private final ConfigService configService;
    private final Random random;
    private final InternalRunnable runnable;
    private final Thread processingThread;

    public StackTraceCollector(TransactionRegistry transactionRegistry, final ConfigService configService, Random random) {
        this.transactionRegistry = transactionRegistry;
        this.configService = configService;
        this.random = random;
        this.runnable = new InternalRunnable();
        this.processingThread = new Thread(this.runnable);
        this.processingThread.setDaemon(true);
        this.processingThread.setName("Glowroot-Stack-Trace-Collector");
        this.processingThread.start();
        configService.addConfigListener(new ConfigListener(){

            @Override
            public void onChange() {
                int intervalMillis = configService.getTransactionConfig().profilingIntervalMillis();
                if (intervalMillis != Preconditions.checkNotNull(StackTraceCollector.this.runnable).currIntervalMillis) {
                    Preconditions.checkNotNull(StackTraceCollector.this.processingThread);
                    StackTraceCollector.this.processingThread.interrupt();
                }
            }
        });
    }

    @OnlyUsedByTests
    public void close() throws InterruptedException {
        this.runnable.closed = true;
        this.processingThread.interrupt();
        this.processingThread.join();
    }

    static void captureStackTraces(List<ThreadContextImpl> threadContexts) {
        if (threadContexts.isEmpty()) {
            return;
        }
        long[] threadIds = new long[threadContexts.size()];
        for (int i = 0; i < threadContexts.size(); ++i) {
            threadIds[i] = threadContexts.get(i).getThreadId();
        }
        ThreadInfo[] threadInfos = ManagementFactory.getThreadMXBean().getThreadInfo(threadIds, Integer.MAX_VALUE);
        for (int i = 0; i < threadContexts.size(); ++i) {
            ThreadContextImpl threadContext = threadContexts.get(i);
            ThreadInfo threadInfo = threadInfos[i];
            if (threadInfo == null) continue;
            threadContext.captureStackTrace(threadInfo);
        }
    }

    private class InternalRunnable
    implements Runnable {
        private volatile int currIntervalMillis;
        private volatile boolean closed;

        private InternalRunnable() {
        }

        @Override
        public void run() {
            long remainingMillisInInterval = 0L;
            while (!this.closed) {
                this.currIntervalMillis = StackTraceCollector.this.configService.getTransactionConfig().profilingIntervalMillis();
                if (this.currIntervalMillis <= 0) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(Long.MAX_VALUE);
                    }
                    catch (InterruptedException e) {
                        logger.debug(e.getMessage(), e);
                        remainingMillisInInterval = 0L;
                        continue;
                    }
                }
                long randomDelayMillisFromIntervalStart = (long)(StackTraceCollector.this.random.nextFloat() * (float)this.currIntervalMillis);
                try {
                    TimeUnit.MILLISECONDS.sleep(remainingMillisInInterval + randomDelayMillisFromIntervalStart);
                }
                catch (InterruptedException e) {
                    logger.debug(e.getMessage(), e);
                    remainingMillisInInterval = 0L;
                    continue;
                }
                remainingMillisInInterval = (long)this.currIntervalMillis - randomDelayMillisFromIntervalStart;
                try {
                    this.runInternal();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        }

        private void runInternal() {
            ImmutableList<Transaction> transactions = ImmutableList.copyOf(StackTraceCollector.this.transactionRegistry.getTransactions());
            if (transactions.isEmpty()) {
                return;
            }
            ArrayList<ThreadContextImpl> activeThreadContexts = Lists.newArrayListWithCapacity(2 * transactions.size());
            for (int i = 0; i < transactions.size(); ++i) {
                Transaction transaction = (Transaction)transactions.get(i);
                ThreadContextImpl mainThreadContext = transaction.getMainThreadContext();
                if (mainThreadContext.isActive()) {
                    activeThreadContexts.add(mainThreadContext);
                }
                activeThreadContexts.addAll(transaction.getActiveAuxThreadContexts());
            }
            StackTraceCollector.captureStackTraces(activeThreadContexts);
        }
    }
}

