/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.ArrayList;
import java.util.List;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.model.MutableAggregateTimer;
import org.glowroot.agent.model.SharedQueryTextCollection;
import org.glowroot.agent.model.ThreadProfile;
import org.glowroot.agent.model.ThreadStats;
import org.glowroot.agent.model.TransactionTimer;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableOverviewAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutablePercentileAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableThroughputAggregate;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.LazyHistogram;
import org.glowroot.agent.shaded.org.glowroot.common.model.MutableProfile;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ProfileCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.util.NotAvailableAware;
import org.glowroot.agent.shaded.org.glowroot.common.util.Styles;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AggregateOuterClass;

@Styles.Private
class AggregateCollector {
    @Nullable
    private final String transactionName;
    private double totalDurationNanos;
    private long transactionCount;
    private long errorCount;
    private boolean asyncTransactions;
    private final RootTimerCollectorImpl mainThreadRootTimers = new RootTimerCollectorImpl();
    private final ThreadStatsCollectorImpl mainThreadStats = new ThreadStatsCollectorImpl();
    private final LazyHistogram durationNanosHistogram = new LazyHistogram();
    private final org.glowroot.agent.model.QueryCollector queries;
    private final org.glowroot.agent.model.ServiceCallCollector serviceCalls;
    @MonotonicNonNull
    private MutableAggregateTimer auxThreadRootTimer;
    @MonotonicNonNull
    private ThreadStatsCollectorImpl auxThreadStats;
    @MonotonicNonNull
    private RootTimerCollectorImpl asyncTimers;
    @MonotonicNonNull
    private MutableProfile mainThreadProfile;
    @MonotonicNonNull
    private MutableProfile auxThreadProfile;
    private final Object lock = new Object();

    AggregateCollector(@Nullable String transactionName, int maxQueryAggregates, int maxServiceCallAggregates) {
        this.transactionName = transactionName;
        int queriesHardLimitMultiplierWhileBuilding = transactionName == null ? 10 : 2;
        this.queries = new org.glowroot.agent.model.QueryCollector(maxQueryAggregates, queriesHardLimitMultiplierWhileBuilding);
        int serviceCallsHardLimitMultiplierWhileBuilding = transactionName == null ? 10 : 2;
        this.serviceCalls = new org.glowroot.agent.model.ServiceCallCollector(maxServiceCallAggregates, serviceCallsHardLimitMultiplierWhileBuilding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeDataFrom(Transaction transaction) {
        Object object = this.lock;
        synchronized (object) {
            ThreadProfile toBeMergedAuxThreadProfile;
            long totalDurationNanos = transaction.getDurationNanos();
            this.totalDurationNanos += (double)totalDurationNanos;
            ++this.transactionCount;
            if (transaction.getErrorMessage() != null) {
                ++this.errorCount;
            }
            if (transaction.isAsync()) {
                this.asyncTransactions = true;
            }
            this.mainThreadStats.mergeThreadStats(transaction.getMainThreadStats());
            this.mainThreadRootTimers.mergeRootTimer(transaction.getMainThreadRootTimer());
            if (transaction.hasAuxThreadContexts()) {
                if (this.auxThreadRootTimer == null) {
                    this.auxThreadRootTimer = MutableAggregateTimer.createAuxThreadRootTimer();
                }
                transaction.mergeAuxThreadTimersInto(this.auxThreadRootTimer);
                if (this.auxThreadStats == null) {
                    this.auxThreadStats = new ThreadStatsCollectorImpl();
                }
                transaction.mergeAuxThreadStatsInto(this.auxThreadStats);
            }
            if (transaction.hasAsyncTimers()) {
                if (this.asyncTimers == null) {
                    this.asyncTimers = new RootTimerCollectorImpl();
                }
                transaction.mergeAsyncTimersInto(this.asyncTimers);
            }
            this.durationNanosHistogram.add(totalDurationNanos);
            transaction.mergeQueriesInto(this.queries);
            transaction.mergeServiceCallsInto(this.serviceCalls);
            ThreadProfile toBeMergedMainThreadProfile = transaction.getMainThreadProfile();
            if (toBeMergedMainThreadProfile != null) {
                if (this.mainThreadProfile == null) {
                    this.mainThreadProfile = new MutableProfile();
                }
                toBeMergedMainThreadProfile.mergeInto(this.mainThreadProfile);
            }
            if ((toBeMergedAuxThreadProfile = transaction.getAuxThreadProfile()) != null) {
                if (this.auxThreadProfile == null) {
                    this.auxThreadProfile = new MutableProfile();
                }
                toBeMergedAuxThreadProfile.mergeInto(this.auxThreadProfile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AggregateOuterClass.Aggregate build(SharedQueryTextCollection sharedQueryTextCollection, LazyHistogram.ScratchBuffer scratchBuffer) {
        Object object = this.lock;
        synchronized (object) {
            AggregateOuterClass.Aggregate.Builder builder = AggregateOuterClass.Aggregate.newBuilder().setTotalDurationNanos(this.totalDurationNanos).setTransactionCount(this.transactionCount).setErrorCount(this.errorCount).setAsyncTransactions(this.asyncTransactions).addAllMainThreadRootTimer(this.mainThreadRootTimers.toProto()).setMainThreadStats(this.mainThreadStats.toProto()).setDurationNanosHistogram(this.durationNanosHistogram.toProto(scratchBuffer));
            if (this.auxThreadRootTimer != null) {
                builder.setAuxThreadRootTimer(this.auxThreadRootTimer.toProto());
                builder.setAuxThreadStats(Preconditions.checkNotNull(this.auxThreadStats).toProto());
            }
            if (this.asyncTimers != null) {
                builder.addAllAsyncTimer(this.asyncTimers.toProto());
            }
            if (this.queries != null) {
                builder.addAllQuery(this.queries.toAggregateProto(sharedQueryTextCollection, false));
            }
            if (this.serviceCalls != null) {
                builder.addAllServiceCall(this.serviceCalls.toAggregateProto());
            }
            if (this.mainThreadProfile != null) {
                builder.setMainThreadProfile(this.mainThreadProfile.toProto());
            }
            if (this.auxThreadProfile != null) {
                builder.setAuxThreadProfile(this.auxThreadProfile.toProto());
            }
            return builder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeOverallSummaryInto(OverallSummaryCollector collector) {
        Object object = this.lock;
        synchronized (object) {
            collector.mergeSummary(this.totalDurationNanos, this.transactionCount, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeTransactionNameSummariesInto(TransactionNameSummaryCollector collector) {
        Preconditions.checkNotNull(this.transactionName);
        Object object = this.lock;
        synchronized (object) {
            collector.collect(this.transactionName, this.totalDurationNanos, this.transactionCount, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeOverallErrorSummaryInto(OverallErrorSummaryCollector collector) {
        Object object = this.lock;
        synchronized (object) {
            collector.mergeErrorSummary(this.errorCount, this.transactionCount, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeTransactionNameErrorSummariesInto(TransactionNameErrorSummaryCollector collector) {
        Preconditions.checkNotNull(this.transactionName);
        Object object = this.lock;
        synchronized (object) {
            if (this.errorCount != 0L) {
                collector.collect(this.transactionName, this.errorCount, this.transactionCount, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LiveAggregateRepository.OverviewAggregate getOverviewAggregate(long captureTime) {
        Object object = this.lock;
        synchronized (object) {
            ImmutableOverviewAggregate.Builder builder = ImmutableOverviewAggregate.builder().captureTime(captureTime).totalDurationNanos(this.totalDurationNanos).transactionCount(this.transactionCount).asyncTransactions(this.asyncTransactions).mainThreadRootTimers(this.mainThreadRootTimers.toProto()).mainThreadStats(this.mainThreadStats.toProto());
            if (this.auxThreadRootTimer != null) {
                builder.auxThreadRootTimer(this.auxThreadRootTimer.toProto());
                builder.auxThreadStats(Preconditions.checkNotNull(this.auxThreadStats).toProto());
            }
            if (this.asyncTimers != null) {
                builder.asyncTimers(this.asyncTimers.toProto());
            }
            return builder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LiveAggregateRepository.PercentileAggregate getPercentileAggregate(long captureTime) {
        Object object = this.lock;
        synchronized (object) {
            return ImmutablePercentileAggregate.builder().captureTime(captureTime).totalDurationNanos(this.totalDurationNanos).transactionCount(this.transactionCount).durationNanosHistogram(this.durationNanosHistogram.toProto(new LazyHistogram.ScratchBuffer())).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LiveAggregateRepository.ThroughputAggregate getThroughputAggregate(long captureTime) {
        Object object = this.lock;
        synchronized (object) {
            return ImmutableThroughputAggregate.builder().captureTime(captureTime).transactionCount(this.transactionCount).errorCount(this.errorCount).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    String getFullQueryText(String fullQueryTextSha1) {
        if (this.queries == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.queries.getFullQueryText(fullQueryTextSha1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeQueriesInto(QueryCollector collector) {
        if (this.queries != null) {
            Object object = this.lock;
            synchronized (object) {
                this.queries.mergeQueriesInto(collector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeServiceCallsInto(ServiceCallCollector collector) {
        if (this.serviceCalls != null) {
            Object object = this.lock;
            synchronized (object) {
                this.serviceCalls.mergeServiceCallsInto(collector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeMainThreadProfilesInto(ProfileCollector collector) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mainThreadProfile != null) {
                collector.mergeProfile(this.mainThreadProfile.toProto());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeAuxThreadProfilesInto(ProfileCollector collector) {
        Object object = this.lock;
        synchronized (object) {
            if (this.auxThreadProfile != null) {
                collector.mergeProfile(this.auxThreadProfile.toProto());
            }
        }
    }

    private static class ThreadStatsCollectorImpl
    implements Transaction.ThreadStatsCollector {
        private double totalCpuNanos;
        private long totalBlockedMillis;
        private long totalWaitedMillis;
        private double totalAllocatedBytes;

        private ThreadStatsCollectorImpl() {
        }

        @Override
        public void mergeThreadStats(ThreadStats threadStats) {
            this.totalCpuNanos = NotAvailableAware.add(this.totalCpuNanos, (double)threadStats.getCpuNanos());
            this.totalBlockedMillis = NotAvailableAware.add(this.totalBlockedMillis, threadStats.getBlockedMillis());
            this.totalWaitedMillis = NotAvailableAware.add(this.totalWaitedMillis, threadStats.getWaitedMillis());
            this.totalAllocatedBytes = NotAvailableAware.add(this.totalAllocatedBytes, (double)threadStats.getAllocatedBytes());
        }

        public AggregateOuterClass.Aggregate.ThreadStats toProto() {
            return AggregateOuterClass.Aggregate.ThreadStats.newBuilder().setTotalCpuNanos(this.totalCpuNanos).setTotalBlockedNanos(NotAvailableAware.millisToNanos(this.totalBlockedMillis)).setTotalWaitedNanos(NotAvailableAware.millisToNanos(this.totalWaitedMillis)).setTotalAllocatedBytes(this.totalAllocatedBytes).build();
        }
    }

    private static class RootTimerCollectorImpl
    implements Transaction.RootTimerCollector {
        List<MutableAggregateTimer> rootMutableTimers = Lists.newArrayList();

        private RootTimerCollectorImpl() {
        }

        @Override
        public void mergeRootTimer(TransactionTimer toBeMergedRootTimer) {
            for (MutableAggregateTimer rootTimer : this.rootMutableTimers) {
                if (!toBeMergedRootTimer.getName().equals(rootTimer.getName()) || toBeMergedRootTimer.isExtended() != rootTimer.isExtended()) continue;
                rootTimer.addDataFrom(toBeMergedRootTimer);
                return;
            }
            MutableAggregateTimer rootTimer = new MutableAggregateTimer(toBeMergedRootTimer.getName(), toBeMergedRootTimer.isExtended());
            rootTimer.addDataFrom(toBeMergedRootTimer);
            this.rootMutableTimers.add(rootTimer);
        }

        private List<AggregateOuterClass.Aggregate.Timer> toProto() {
            ArrayList<AggregateOuterClass.Aggregate.Timer> rootTimers = Lists.newArrayList();
            for (MutableAggregateTimer rootMutableTimer : this.rootMutableTimers) {
                rootTimers.add(rootMutableTimer.toProto());
            }
            return rootTimers;
        }
    }
}

