/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.config.ImmutablePluginConfig;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.config.PropertyDescriptor;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PluginConfig {
    @JsonIgnore
    public abstract PluginDescriptor pluginDescriptor();

    @Value.Derived
    public String id() {
        return this.pluginDescriptor().id();
    }

    public abstract Map<String, PropertyValue> properties();

    @JsonIgnore
    @Value.Derived
    ImmutableMap<String, Boolean> booleanProperties() {
        HashMap<String, Boolean> booleanProperties = Maps.newHashMap();
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            Object value = propertyValue.value();
            if (!(value instanceof Boolean)) continue;
            booleanProperties.put(entry.getKey(), (Boolean)value);
        }
        return ImmutableMap.copyOf(booleanProperties);
    }

    @JsonIgnore
    @Value.Derived
    ImmutableMap<String, String> stringProperties() {
        HashMap<String, String> stringProperties = Maps.newHashMap();
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            Object value = propertyValue.value();
            if (!(value instanceof String)) continue;
            stringProperties.put(entry.getKey(), (String)value);
        }
        return ImmutableMap.copyOf(stringProperties);
    }

    @JsonIgnore
    @Value.Derived
    ImmutableMap<String, Optional<Double>> doubleProperties() {
        HashMap doubleProperties = Maps.newHashMap();
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            Object value = propertyValue.value();
            if (value == null) {
                doubleProperties.put(entry.getKey(), Optional.absent());
                continue;
            }
            if (!(value instanceof Double)) continue;
            doubleProperties.put(entry.getKey(), Optional.of((Double)value));
        }
        return ImmutableMap.copyOf(doubleProperties);
    }

    @JsonIgnore
    @Value.Derived
    ImmutableMap<String, List<String>> listProperties() {
        HashMap listProperties = Maps.newHashMap();
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            Object value = propertyValue.value();
            if (!(value instanceof List)) continue;
            ArrayList<String> list = Lists.newArrayList();
            for (Object v : (List)value) {
                list.add((String)Preconditions.checkNotNull(v));
            }
            listProperties.put(entry.getKey(), list);
        }
        return ImmutableMap.copyOf(listProperties);
    }

    public String getStringProperty(String name) {
        String value = this.stringProperties().get(name);
        return value == null ? "" : value;
    }

    public boolean getBooleanProperty(String name) {
        Boolean value = this.booleanProperties().get(name);
        return value != null && value != false;
    }

    @Nullable
    public Double getDoubleProperty(String name) {
        Optional<Double> value = this.doubleProperties().get(name);
        return value == null ? null : value.orNull();
    }

    public List<String> getListProperty(String name) {
        List<String> value = this.listProperties().get(name);
        return value == null ? ImmutableList.of() : value;
    }

    public AgentConfigOuterClass.AgentConfig.PluginConfig toProto() {
        AgentConfigOuterClass.AgentConfig.PluginConfig.Builder builder = AgentConfigOuterClass.AgentConfig.PluginConfig.newBuilder().setId(this.id()).setName(this.pluginDescriptor().name());
        for (Map.Entry<String, PropertyValue> entry : this.properties().entrySet()) {
            PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(entry.getKey());
            AgentConfigOuterClass.AgentConfig.PluginProperty.Builder property = AgentConfigOuterClass.AgentConfig.PluginProperty.newBuilder().setName(entry.getKey()).setValue(entry.getValue().toProto()).setDefault(propertyDescriptor.getValidatedNonNullDefaultValue().toProto()).setLabel(propertyDescriptor.label()).setCheckboxLabel(propertyDescriptor.checkboxLabel()).setDescription(propertyDescriptor.description());
            builder.addProperty(property);
        }
        return builder.build();
    }

    private PropertyDescriptor getPropertyDescriptor(String name) {
        for (PropertyDescriptor propertyDescriptor : this.pluginDescriptor().properties()) {
            if (!propertyDescriptor.name().equals(name)) continue;
            return propertyDescriptor;
        }
        throw new IllegalStateException("Could not find property descriptor: " + name);
    }

    public static PluginConfig create(PluginDescriptor pluginDescriptor, List<AgentConfigOuterClass.AgentConfig.PluginProperty> newProperties) {
        ImmutablePluginConfig.Builder builder = ImmutablePluginConfig.builder().pluginDescriptor(pluginDescriptor);
        HashMap<String, AgentConfigOuterClass.AgentConfig.PluginProperty> remainingNewProperties = Maps.newHashMap();
        for (AgentConfigOuterClass.AgentConfig.PluginProperty newProperty : newProperties) {
            remainingNewProperties.put(newProperty.getName(), newProperty);
        }
        LinkedHashMap<String, PropertyValue> propertyValues = Maps.newLinkedHashMap();
        for (PropertyDescriptor propertyDescriptor : pluginDescriptor.properties()) {
            AgentConfigOuterClass.AgentConfig.PluginProperty newProperty = (AgentConfigOuterClass.AgentConfig.PluginProperty)remainingNewProperties.remove(propertyDescriptor.name());
            if (newProperty == null) {
                propertyValues.put(propertyDescriptor.name(), propertyDescriptor.getValidatedNonNullDefaultValue());
                continue;
            }
            if (!PluginConfig.isValidType(newProperty.getValue().getValCase(), propertyDescriptor.type())) {
                throw new IllegalStateException("Plugin property " + newProperty.getName() + " has incorrect type: " + newProperty.getValue().getValCase());
            }
            propertyValues.put(newProperty.getName(), PropertyValue.create(newProperty.getValue()));
        }
        if (remainingNewProperties.isEmpty()) {
            return builder.properties(propertyValues).build();
        }
        throw new IllegalStateException("Plugin properties not found: " + Joiner.on(", ").join(remainingNewProperties.keySet()));
    }

    private static boolean isValidType(AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase valueType, PropertyValue.PropertyType targetType) {
        switch (targetType) {
            case BOOLEAN: {
                return valueType == AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase.BVAL;
            }
            case STRING: {
                return valueType == AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase.SVAL;
            }
            case DOUBLE: {
                return valueType == AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase.DVAL || valueType == AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase.DVAL_NULL;
            }
            case LIST: {
                return valueType == AgentConfigOuterClass.AgentConfig.PluginProperty.Value.ValCase.LVAL;
            }
        }
        throw new AssertionError((Object)("Unexpected property type: " + (Object)((Object)targetType)));
    }
}

