/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.config.PluginConfig;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PluginConfig", generator="Immutables")
@Immutable
public final class ImmutablePluginConfig
extends PluginConfig {
    private final PluginDescriptor pluginDescriptor;
    private final transient String id;
    private final ImmutableMap<String, PropertyValue> properties;
    private final transient ImmutableMap<String, Boolean> booleanProperties;
    private final transient ImmutableMap<String, String> stringProperties;
    private final transient ImmutableMap<String, Optional<Double>> doubleProperties;
    private final transient ImmutableMap<String, List<String>> listProperties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePluginConfig(PluginDescriptor pluginDescriptor, ImmutableMap<String, PropertyValue> properties) {
        this.pluginDescriptor = pluginDescriptor;
        this.properties = properties;
        this.id = this.initShim.id();
        this.booleanProperties = this.initShim.booleanProperties();
        this.stringProperties = this.initShim.stringProperties();
        this.doubleProperties = this.initShim.doubleProperties();
        this.listProperties = this.initShim.listProperties();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="pluginDescriptor")
    @JsonIgnore
    public PluginDescriptor pluginDescriptor() {
        return this.pluginDescriptor;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        InitShim shim = this.initShim;
        return shim != null ? shim.id() : this.id;
    }

    @JsonProperty(value="properties")
    public ImmutableMap<String, PropertyValue> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="booleanProperties")
    @JsonIgnore
    ImmutableMap<String, Boolean> booleanProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.booleanProperties() : this.booleanProperties;
    }

    @Override
    @JsonProperty(value="stringProperties")
    @JsonIgnore
    ImmutableMap<String, String> stringProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stringProperties() : this.stringProperties;
    }

    @Override
    @JsonProperty(value="doubleProperties")
    @JsonIgnore
    ImmutableMap<String, Optional<Double>> doubleProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.doubleProperties() : this.doubleProperties;
    }

    @Override
    @JsonProperty(value="listProperties")
    @JsonIgnore
    ImmutableMap<String, List<String>> listProperties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.listProperties() : this.listProperties;
    }

    public final ImmutablePluginConfig withPluginDescriptor(PluginDescriptor value) {
        if (this.pluginDescriptor == value) {
            return this;
        }
        PluginDescriptor newValue = Preconditions.checkNotNull(value, "pluginDescriptor");
        return new ImmutablePluginConfig(newValue, this.properties);
    }

    public final ImmutablePluginConfig withProperties(Map<String, ? extends PropertyValue> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap<String, PropertyValue> newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePluginConfig(this.pluginDescriptor, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginConfig && this.equalTo((ImmutablePluginConfig)another);
    }

    private boolean equalTo(ImmutablePluginConfig another) {
        return this.pluginDescriptor.equals(another.pluginDescriptor) && this.id.equals(another.id) && this.properties.equals(another.properties) && this.booleanProperties.equals(another.booleanProperties) && this.stringProperties.equals(another.stringProperties) && this.doubleProperties.equals(another.doubleProperties) && this.listProperties.equals(another.listProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pluginDescriptor.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.booleanProperties.hashCode();
        h += (h << 5) + this.stringProperties.hashCode();
        h += (h << 5) + this.doubleProperties.hashCode();
        h += (h << 5) + this.listProperties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PluginConfig").omitNullValues().add("pluginDescriptor", this.pluginDescriptor).add("id", this.id).add("properties", this.properties).add("booleanProperties", this.booleanProperties).add("stringProperties", this.stringProperties).add("doubleProperties", this.doubleProperties).add("listProperties", this.listProperties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginConfig fromJson(Json json) {
        Builder builder = ImmutablePluginConfig.builder();
        if (json.pluginDescriptor != null) {
            builder.pluginDescriptor(json.pluginDescriptor);
        }
        if (json.properties != null) {
            builder.putAllProperties(json.properties);
        }
        return builder.build();
    }

    public static ImmutablePluginConfig copyOf(PluginConfig instance) {
        if (instance instanceof ImmutablePluginConfig) {
            return (ImmutablePluginConfig)instance;
        }
        return ImmutablePluginConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PluginConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLUGIN_DESCRIPTOR = 1L;
        private long initBits = 1L;
        @Nullable
        private PluginDescriptor pluginDescriptor;
        private ImmutableMap.Builder<String, PropertyValue> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(PluginConfig instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.pluginDescriptor(instance.pluginDescriptor());
            this.putAllProperties(instance.properties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pluginDescriptor(PluginDescriptor pluginDescriptor) {
            this.pluginDescriptor = Preconditions.checkNotNull(pluginDescriptor, "pluginDescriptor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, PropertyValue value) {
            this.properties.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends PropertyValue> entry) {
            this.properties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends PropertyValue> entries) {
            this.properties = ImmutableMap.builder();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends PropertyValue> entries) {
            this.properties.putAll(entries);
            return this;
        }

        public ImmutablePluginConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePluginConfig(this.pluginDescriptor, this.properties.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pluginDescriptor");
            }
            return "Cannot build PluginConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PluginConfig", generator="Immutables")
    static final class Json
    extends PluginConfig {
        @Nullable
        PluginDescriptor pluginDescriptor;
        @Nullable
        Map<String, PropertyValue> properties = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="pluginDescriptor")
        @JsonIgnore
        public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
            this.pluginDescriptor = pluginDescriptor;
        }

        @JsonProperty(value="properties")
        public void setProperties(Map<String, PropertyValue> properties) {
            this.properties = properties;
        }

        @Override
        public PluginDescriptor pluginDescriptor() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, PropertyValue> properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        ImmutableMap<String, Boolean> booleanProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        ImmutableMap<String, String> stringProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        ImmutableMap<String, Optional<Double>> doubleProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        ImmutableMap<String, List<String>> listProperties() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="PluginConfig", generator="Immutables")
    private final class InitShim {
        private byte idBuildStage = 0;
        private String id;
        private byte booleanPropertiesBuildStage = 0;
        private ImmutableMap<String, Boolean> booleanProperties;
        private byte stringPropertiesBuildStage = 0;
        private ImmutableMap<String, String> stringProperties;
        private byte doublePropertiesBuildStage = 0;
        private ImmutableMap<String, Optional<Double>> doubleProperties;
        private byte listPropertiesBuildStage = 0;
        private ImmutableMap<String, List<String>> listProperties;

        private InitShim() {
        }

        String id() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Preconditions.checkNotNull(ImmutablePluginConfig.super.id(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        ImmutableMap<String, Boolean> booleanProperties() {
            if (this.booleanPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.booleanPropertiesBuildStage == 0) {
                this.booleanPropertiesBuildStage = (byte)-1;
                this.booleanProperties = Preconditions.checkNotNull(ImmutablePluginConfig.super.booleanProperties(), "booleanProperties");
                this.booleanPropertiesBuildStage = 1;
            }
            return this.booleanProperties;
        }

        ImmutableMap<String, String> stringProperties() {
            if (this.stringPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stringPropertiesBuildStage == 0) {
                this.stringPropertiesBuildStage = (byte)-1;
                this.stringProperties = Preconditions.checkNotNull(ImmutablePluginConfig.super.stringProperties(), "stringProperties");
                this.stringPropertiesBuildStage = 1;
            }
            return this.stringProperties;
        }

        ImmutableMap<String, Optional<Double>> doubleProperties() {
            if (this.doublePropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.doublePropertiesBuildStage == 0) {
                this.doublePropertiesBuildStage = (byte)-1;
                this.doubleProperties = Preconditions.checkNotNull(ImmutablePluginConfig.super.doubleProperties(), "doubleProperties");
                this.doublePropertiesBuildStage = 1;
            }
            return this.doubleProperties;
        }

        ImmutableMap<String, List<String>> listProperties() {
            if (this.listPropertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.listPropertiesBuildStage == 0) {
                this.listPropertiesBuildStage = (byte)-1;
                this.listProperties = Preconditions.checkNotNull(ImmutablePluginConfig.super.listProperties(), "listProperties");
                this.listPropertiesBuildStage = 1;
            }
            return this.listProperties;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            if (this.booleanPropertiesBuildStage == -1) {
                attributes.add("booleanProperties");
            }
            if (this.stringPropertiesBuildStage == -1) {
                attributes.add("stringProperties");
            }
            if (this.doublePropertiesBuildStage == -1) {
                attributes.add("doubleProperties");
            }
            if (this.listPropertiesBuildStage == -1) {
                attributes.add("listProperties");
            }
            return "Cannot build PluginConfig, attribute initializers form cycle " + attributes;
        }
    }
}

