/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glowroot.agent.config.AllConfig;
import org.glowroot.agent.config.ConfigFile;
import org.glowroot.agent.config.ImmutablePluginConfig;
import org.glowroot.agent.config.ImmutablePluginConfigTemp;
import org.glowroot.agent.config.PluginConfig;
import org.glowroot.agent.config.PluginDescriptor;
import org.glowroot.agent.config.PropertyDescriptor;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.glowroot.agent.shaded.com.google.common.base.Splitter;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.config.AdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.AlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.GaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAdvancedConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableAlertConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableGaugeConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableInstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableJvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableMBeanAttribute;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableSyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableTransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.ImmutableUiDefaultsConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.InstrumentationConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.JvmConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.SyntheticMonitorConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.TransactionConfig;
import org.glowroot.agent.shaded.org.glowroot.common.config.UiDefaultsConfig;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;
import org.immutables.value.Value;

public class ConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigService.class);
    private static final long GAUGE_COLLECTION_INTERVAL_MILLIS = Long.getLong("glowroot.internal.gaugeCollectionIntervalMillis", 5000L);
    private final ConfigFile configFile;
    private final ImmutableList<PluginDescriptor> pluginDescriptors;
    private final Set<ConfigListener> configListeners = Sets.newCopyOnWriteArraySet();
    private final Set<ConfigListener> pluginConfigListeners = Sets.newCopyOnWriteArraySet();
    private volatile TransactionConfig transactionConfig;
    private volatile JvmConfig jvmConfig;
    private volatile UiDefaultsConfig uiDefaultsConfig;
    private volatile AdvancedConfig advancedConfig;
    private volatile ImmutableList<GaugeConfig> gaugeConfigs;
    private volatile ImmutableList<SyntheticMonitorConfig> syntheticMonitorConfigs;
    private volatile ImmutableList<AlertConfig> alertConfigs;
    private volatile ImmutableList<PluginConfig> pluginConfigs;
    private volatile ImmutableList<InstrumentationConfig> instrumentationConfigs;
    private volatile boolean memoryBarrier;

    public static ConfigService create(List<File> confDirs, boolean configReadOnly, List<PluginDescriptor> pluginDescriptors) {
        ConfigService configService = new ConfigService(confDirs, configReadOnly, pluginDescriptors);
        try {
            configService.writeAll();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
        return configService;
    }

    private ConfigService(List<File> confDirs, boolean configReadOnly, List<PluginDescriptor> pluginDescriptors) {
        this.configFile = new ConfigFile(confDirs, configReadOnly);
        this.pluginDescriptors = ImmutableList.copyOf(pluginDescriptors);
        TransactionConfig transactionConfig = this.configFile.getConfig("transactions", ImmutableTransactionConfig.class);
        this.transactionConfig = transactionConfig == null ? ImmutableTransactionConfig.builder().build() : transactionConfig;
        JvmConfig jvmConfig = this.configFile.getConfig("jvm", ImmutableJvmConfig.class);
        this.jvmConfig = jvmConfig == null ? ImmutableJvmConfig.builder().build() : jvmConfig;
        UiDefaultsConfig uiDefaultsConfig = this.configFile.getConfig("uiDefaults", ImmutableUiDefaultsConfig.class);
        this.uiDefaultsConfig = uiDefaultsConfig == null ? ImmutableUiDefaultsConfig.builder().build() : uiDefaultsConfig;
        AdvancedConfig advancedConfig = this.configFile.getConfig("advanced", ImmutableAdvancedConfig.class);
        this.advancedConfig = advancedConfig == null ? ImmutableAdvancedConfig.builder().build() : advancedConfig;
        List<ImmutableGaugeConfig> gaugeConfigs = this.configFile.getConfig("gauges", new TypeReference<List<ImmutableGaugeConfig>>(){});
        this.gaugeConfigs = gaugeConfigs == null ? ConfigService.getDefaultGaugeConfigs() : ImmutableList.copyOf(gaugeConfigs);
        List<ImmutableSyntheticMonitorConfig> syntheticMonitorConfigs = this.configFile.getConfig("syntheticMonitors", new TypeReference<List<ImmutableSyntheticMonitorConfig>>(){});
        this.syntheticMonitorConfigs = syntheticMonitorConfigs == null ? ImmutableList.of() : ImmutableList.copyOf(syntheticMonitorConfigs);
        List<ImmutableAlertConfig> alertConfigs = this.configFile.getConfig("alerts", new TypeReference<List<ImmutableAlertConfig>>(){});
        this.alertConfigs = alertConfigs == null ? ImmutableList.of() : ImmutableList.copyOf(alertConfigs);
        List<ImmutablePluginConfigTemp> pluginConfigs = this.configFile.getConfig("plugins", new TypeReference<List<ImmutablePluginConfigTemp>>(){});
        this.pluginConfigs = ConfigService.fixPluginConfigs(pluginConfigs, pluginDescriptors);
        List<ImmutableInstrumentationConfig> instrumentationConfigs = this.configFile.getConfig("instrumentation", new TypeReference<List<ImmutableInstrumentationConfig>>(){});
        this.instrumentationConfigs = instrumentationConfigs == null ? ImmutableList.of() : ImmutableList.copyOf(instrumentationConfigs);
        for (InstrumentationConfig instrumentationConfig : this.instrumentationConfigs) {
            instrumentationConfig.logValidationErrorsIfAny();
        }
    }

    public TransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public JvmConfig getJvmConfig() {
        return this.jvmConfig;
    }

    public UiDefaultsConfig getUiDefaultsConfig() {
        return this.uiDefaultsConfig;
    }

    public AdvancedConfig getAdvancedConfig() {
        return this.advancedConfig;
    }

    public List<GaugeConfig> getGaugeConfigs() {
        return this.gaugeConfigs;
    }

    public ImmutableList<AlertConfig> getAlertConfigs() {
        return this.alertConfigs;
    }

    public ImmutableList<PluginConfig> getPluginConfigs() {
        return this.pluginConfigs;
    }

    @Nullable
    public PluginConfig getPluginConfig(String pluginId) {
        for (PluginConfig pluginConfig : this.pluginConfigs) {
            if (!pluginId.equals(pluginConfig.id())) continue;
            return pluginConfig;
        }
        return null;
    }

    public List<InstrumentationConfig> getInstrumentationConfigs() {
        return this.instrumentationConfigs;
    }

    public long getGaugeCollectionIntervalMillis() {
        return GAUGE_COLLECTION_INTERVAL_MILLIS;
    }

    public AgentConfigOuterClass.AgentConfig getAgentConfig() {
        AgentConfigOuterClass.AgentConfig.Builder builder = AgentConfigOuterClass.AgentConfig.newBuilder().setTransactionConfig(this.transactionConfig.toProto());
        for (GaugeConfig gaugeConfig : this.gaugeConfigs) {
            builder.addGaugeConfig(gaugeConfig.toProto());
        }
        builder.setJvmConfig(this.jvmConfig.toProto());
        for (SyntheticMonitorConfig syntheticMonitorConfig : this.syntheticMonitorConfigs) {
            builder.addSyntheticMonitorConfig(syntheticMonitorConfig.toProto());
        }
        for (AlertConfig alertConfig : this.alertConfigs) {
            builder.addAlertConfig(alertConfig.toProto());
        }
        builder.setUiDefaultsConfig(this.uiDefaultsConfig.toProto());
        for (PluginConfig pluginConfig : this.pluginConfigs) {
            builder.addPluginConfig(pluginConfig.toProto());
        }
        for (InstrumentationConfig instrumentationConfig : this.instrumentationConfigs) {
            builder.addInstrumentationConfig(instrumentationConfig.toProto());
        }
        builder.setAdvancedConfig(this.advancedConfig.toProto());
        return builder.build();
    }

    public void addConfigListener(ConfigListener listener) {
        this.configListeners.add(listener);
        listener.onChange();
    }

    public void addPluginConfigListener(ConfigListener listener) {
        this.pluginConfigListeners.add(listener);
    }

    public void updateTransactionConfig(TransactionConfig config) throws IOException {
        this.configFile.writeConfig("transactions", config);
        this.transactionConfig = config;
        this.notifyConfigListeners();
    }

    public void updateGaugeConfigs(List<GaugeConfig> configs) throws IOException {
        this.configFile.writeConfig("gauges", configs);
        this.gaugeConfigs = ImmutableList.copyOf(configs);
        this.notifyConfigListeners();
    }

    public void updateJvmConfig(JvmConfig config) throws IOException {
        this.configFile.writeConfig("jvm", config);
        this.jvmConfig = config;
        this.notifyConfigListeners();
    }

    public void updateSyntheticMonitorConfigs(List<SyntheticMonitorConfig> configs) throws IOException {
        this.configFile.writeConfig("syntheticMonitors", configs);
        this.syntheticMonitorConfigs = ImmutableList.copyOf(configs);
        this.notifyConfigListeners();
    }

    public void updateAlertConfigs(List<AlertConfig> configs) throws IOException {
        this.configFile.writeConfig("alerts", configs);
        this.alertConfigs = ImmutableList.copyOf(configs);
        this.notifyConfigListeners();
    }

    public void updateUiDefaultsConfig(UiDefaultsConfig config) throws IOException {
        this.configFile.writeConfig("uiDefaults", config);
        this.uiDefaultsConfig = config;
        this.notifyConfigListeners();
    }

    public void updatePluginConfigs(List<PluginConfig> configs) throws IOException {
        this.configFile.writeConfig("plugins", ConfigService.stripEmptyPluginConfigs(configs));
        this.pluginConfigs = ImmutableList.copyOf(configs);
        this.notifyAllPluginConfigListeners();
    }

    public void updateInstrumentationConfigs(List<InstrumentationConfig> configs) throws IOException {
        this.configFile.writeConfig("instrumentation", configs);
        this.instrumentationConfigs = ImmutableList.copyOf(configs);
        this.notifyConfigListeners();
    }

    public void updateAdvancedConfig(AdvancedConfig config) throws IOException {
        this.configFile.writeConfig("advanced", config);
        this.advancedConfig = config;
        this.notifyConfigListeners();
    }

    public void updateAllConfig(AllConfig config) throws IOException {
        HashMap<String, Object> configs = Maps.newHashMap();
        configs.put("transactions", config.transaction());
        configs.put("jvm", config.jvm());
        configs.put("uiDefaults", config.uiDefaults());
        configs.put("advanced", config.advanced());
        configs.put("gauges", config.gauges());
        configs.put("syntheticMonitors", config.syntheticMonitors());
        configs.put("alerts", config.alerts());
        configs.put("plugins", ConfigService.stripEmptyPluginConfigs(config.plugins()));
        configs.put("instrumentation", config.instrumentation());
        this.configFile.writeAllConfigs(configs);
        this.transactionConfig = config.transaction();
        this.jvmConfig = config.jvm();
        this.uiDefaultsConfig = config.uiDefaults();
        this.advancedConfig = config.advanced();
        this.gaugeConfigs = ImmutableList.copyOf(config.gauges());
        this.syntheticMonitorConfigs = ImmutableList.copyOf(config.syntheticMonitors());
        this.alertConfigs = ImmutableList.copyOf(config.alerts());
        this.pluginConfigs = ImmutableList.copyOf(config.plugins());
        this.instrumentationConfigs = ImmutableList.copyOf(config.instrumentation());
        this.notifyConfigListeners();
        this.notifyAllPluginConfigListeners();
    }

    public boolean readMemoryBarrier() {
        return this.memoryBarrier;
    }

    public void writeMemoryBarrier() {
        this.memoryBarrier = true;
    }

    private void notifyConfigListeners() {
        for (ConfigListener configListener : this.configListeners) {
            configListener.onChange();
        }
    }

    private void notifyAllPluginConfigListeners() {
        for (ConfigListener listener : this.pluginConfigListeners) {
            listener.onChange();
        }
        this.writeMemoryBarrier();
    }

    @OnlyUsedByTests
    public void initConfigForTests() throws IOException {
        this.transactionConfig = ImmutableTransactionConfig.copyOf(this.transactionConfig).withSlowThresholdMillis(0);
        this.writeAll();
        this.notifyConfigListeners();
    }

    @OnlyUsedByTests
    public void resetConfigForTests() throws IOException {
        this.transactionConfig = ImmutableTransactionConfig.builder().slowThresholdMillis(0).build();
        this.jvmConfig = ImmutableJvmConfig.builder().build();
        this.uiDefaultsConfig = ImmutableUiDefaultsConfig.builder().build();
        this.advancedConfig = ImmutableAdvancedConfig.builder().build();
        this.gaugeConfigs = ConfigService.getDefaultGaugeConfigs();
        this.syntheticMonitorConfigs = ImmutableList.of();
        this.alertConfigs = ImmutableList.of();
        this.pluginConfigs = ConfigService.fixPluginConfigs(ImmutableList.<ImmutablePluginConfigTemp>of(), this.pluginDescriptors);
        this.instrumentationConfigs = ImmutableList.of();
        this.writeAll();
        this.notifyConfigListeners();
        this.notifyAllPluginConfigListeners();
    }

    private void writeAll() throws IOException {
        HashMap<String, Object> configs = Maps.newHashMap();
        configs.put("transactions", this.transactionConfig);
        configs.put("jvm", this.jvmConfig);
        configs.put("uiDefaults", this.uiDefaultsConfig);
        configs.put("advanced", this.advancedConfig);
        configs.put("gauges", this.gaugeConfigs);
        configs.put("syntheticMonitors", this.syntheticMonitorConfigs);
        configs.put("alerts", this.alertConfigs);
        configs.put("plugins", ConfigService.stripEmptyPluginConfigs(this.pluginConfigs));
        configs.put("instrumentation", this.instrumentationConfigs);
        this.configFile.writeAllConfigsOnStartup(configs);
    }

    private static List<PluginConfig> stripEmptyPluginConfigs(List<PluginConfig> configs) {
        ArrayList<PluginConfig> nonEmptyConfigs = Lists.newArrayList();
        for (PluginConfig config : configs) {
            if (config.properties().isEmpty()) continue;
            nonEmptyConfigs.add(config);
        }
        return nonEmptyConfigs;
    }

    private static ImmutableList<GaugeConfig> getDefaultGaugeConfigs() {
        ArrayList<ImmutableGaugeConfig> defaultGaugeConfigs = Lists.newArrayList();
        defaultGaugeConfigs.add(ImmutableGaugeConfig.builder().mbeanObjectName("java.lang:type=Memory").addMbeanAttributes(ImmutableMBeanAttribute.of("HeapMemoryUsage.used", false)).build());
        defaultGaugeConfigs.add(ImmutableGaugeConfig.builder().mbeanObjectName("java.lang:type=GarbageCollector,name=*").addMbeanAttributes(ImmutableMBeanAttribute.of("CollectionCount", true)).addMbeanAttributes(ImmutableMBeanAttribute.of("CollectionTime", true)).build());
        defaultGaugeConfigs.add(ImmutableGaugeConfig.builder().mbeanObjectName("java.lang:type=MemoryPool,name=*").addMbeanAttributes(ImmutableMBeanAttribute.of("Usage.used", false)).build());
        ImmutableGaugeConfig.Builder operatingSystemMBean = ImmutableGaugeConfig.builder().mbeanObjectName("java.lang:type=OperatingSystem").addMbeanAttributes(ImmutableMBeanAttribute.of("FreePhysicalMemorySize", false));
        if (!JavaVersion.isJava6()) {
            operatingSystemMBean.addMbeanAttributes(ImmutableMBeanAttribute.of("ProcessCpuLoad", false));
            operatingSystemMBean.addMbeanAttributes(ImmutableMBeanAttribute.of("SystemCpuLoad", false));
        }
        defaultGaugeConfigs.add(operatingSystemMBean.build());
        return ImmutableList.copyOf(defaultGaugeConfigs);
    }

    public static ImmutableList<PluginConfig> fixPluginConfigs(@Nullable List<ImmutablePluginConfigTemp> filePluginConfigs, List<PluginDescriptor> pluginDescriptors) {
        HashMap<String, ImmutablePluginConfigTemp> filePluginConfigMap = Maps.newHashMap();
        if (filePluginConfigs != null) {
            for (ImmutablePluginConfigTemp pluginConfig : filePluginConfigs) {
                filePluginConfigMap.put(pluginConfig.id(), pluginConfig);
            }
        }
        ArrayList<ImmutablePluginConfig> accuratePluginConfigs = Lists.newArrayList();
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            PluginConfigTemp filePluginConfig = (PluginConfigTemp)filePluginConfigMap.get(pluginDescriptor.id());
            ImmutablePluginConfig.Builder builder = ImmutablePluginConfig.builder().pluginDescriptor(pluginDescriptor);
            for (PropertyDescriptor propertyDescriptor : pluginDescriptor.properties()) {
                builder.putProperties(propertyDescriptor.name(), ConfigService.getPropertyValue(filePluginConfig, propertyDescriptor));
            }
            accuratePluginConfigs.add(builder.build());
        }
        return ImmutableList.copyOf(accuratePluginConfigs);
    }

    private static PropertyValue getPropertyValue(@Nullable PluginConfigTemp pluginConfig, PropertyDescriptor propertyDescriptor) {
        if (pluginConfig == null) {
            return propertyDescriptor.getValidatedNonNullDefaultValue();
        }
        PropertyValue propertyValue = ConfigService.getValidatedPropertyValue(pluginConfig.properties(), propertyDescriptor.name(), propertyDescriptor.type());
        if (propertyValue == null) {
            return propertyDescriptor.getValidatedNonNullDefaultValue();
        }
        return propertyValue;
    }

    @Nullable
    private static PropertyValue getValidatedPropertyValue(Map<String, PropertyValue> properties, String propertyName, PropertyValue.PropertyType propertyType) {
        PropertyValue propertyValue = properties.get(propertyName);
        if (propertyValue == null) {
            return null;
        }
        Object value = propertyValue.value();
        if (value == null) {
            return PropertyDescriptor.getDefaultValue(propertyType);
        }
        if (PropertyDescriptor.isValidType(value, propertyType)) {
            return propertyValue;
        }
        if (value instanceof String && propertyType == PropertyValue.PropertyType.LIST) {
            return new PropertyValue(Splitter.on(',').trimResults().omitEmptyStrings().splitToList((String)value));
        }
        logger.warn("invalid value for plugin property: {}", (Object)propertyName);
        return PropertyDescriptor.getDefaultValue(propertyType);
    }

    @Value.Immutable
    static interface PluginConfigTemp {
        public String id();

        public Map<String, PropertyValue> properties();
    }
}

