/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.central;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.agent.central.CentralConnection;
import org.glowroot.agent.central.SharedQueryTextLimiter;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.live.LiveJvmServiceImpl;
import org.glowroot.agent.live.LiveTraceRepositoryImpl;
import org.glowroot.agent.live.LiveWeavingServiceImpl;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.base.Stopwatch;
import org.glowroot.agent.shaded.io.grpc.stub.StreamObserver;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveTraceRepository;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;
import org.glowroot.agent.shaded.org.glowroot.common.util.Throwables;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceGrpc;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.ProfileOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.TraceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.ThreadFactories;

class DownstreamServiceObserver
implements StreamObserver<DownstreamServiceOuterClass.CentralRequest> {
    private static final Logger logger = LoggerFactory.getLogger(DownstreamServiceObserver.class);
    private final CentralConnection centralConnection;
    private final DownstreamServiceGrpc.DownstreamServiceStub downstreamServiceStub;
    private final Collector.AgentConfigUpdater agentConfigUpdater;
    private final boolean configReadOnly;
    private final LiveJvmServiceImpl liveJvmService;
    private final LiveWeavingServiceImpl liveWeavingService;
    private final LiveTraceRepositoryImpl liveTraceRepository;
    private final String agentId;
    @Nullable
    private volatile StreamObserver<DownstreamServiceOuterClass.AgentResponse> currResponseObserver;
    private volatile boolean closedByCentralCollector;
    private final AtomicBoolean inMaybeConnectionFailure = new AtomicBoolean();
    private final AtomicBoolean inConnectionFailure;
    private final SharedQueryTextLimiter sharedQueryTextLimiter;
    private final ScheduledExecutorService scheduledRetryExecutor;

    DownstreamServiceObserver(CentralConnection centralConnection, Collector.AgentConfigUpdater agentConfigUpdater, boolean configReadOnly, LiveJvmServiceImpl liveJvmService, LiveWeavingServiceImpl liveWeavingService, LiveTraceRepositoryImpl liveTraceRepository, String agentId, AtomicBoolean inConnectionFailure, SharedQueryTextLimiter sharedQueryTextLimiter) {
        this.centralConnection = centralConnection;
        this.downstreamServiceStub = (DownstreamServiceGrpc.DownstreamServiceStub)DownstreamServiceGrpc.newStub(centralConnection.getChannel()).withCompression("gzip");
        this.agentConfigUpdater = agentConfigUpdater;
        this.configReadOnly = configReadOnly;
        this.liveJvmService = liveJvmService;
        this.liveWeavingService = liveWeavingService;
        this.liveTraceRepository = liveTraceRepository;
        this.agentId = agentId;
        this.inConnectionFailure = inConnectionFailure;
        this.sharedQueryTextLimiter = sharedQueryTextLimiter;
        this.scheduledRetryExecutor = Executors.newSingleThreadScheduledExecutor(ThreadFactories.create("Glowroot-Downstream-Retry"));
    }

    @Override
    public void onNext(DownstreamServiceOuterClass.CentralRequest request) {
        this.inMaybeConnectionFailure.set(false);
        boolean errorFixed = this.inConnectionFailure.getAndSet(false);
        if (errorFixed) {
            this.centralConnection.suppressLogCollector(new Runnable(){

                @Override
                public void run() {
                    logger.info("re-established connection to the central collector");
                }
            });
        }
        if (request.getMessageCase() == DownstreamServiceOuterClass.CentralRequest.MessageCase.HELLO_ACK) {
            return;
        }
        try {
            this.onNextInternal(request);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    @OnlyUsedByTests
    public void onCompleted() {
        this.closedByCentralCollector = true;
    }

    @Override
    public void onError(final Throwable t) {
        if (!this.inMaybeConnectionFailure.getAndSet(true)) {
            this.connectAsync();
            return;
        }
        if (!this.inConnectionFailure.getAndSet(true)) {
            this.centralConnection.suppressLogCollector(new Runnable(){

                @Override
                public void run() {
                    logger.warn("lost connection to the central collector (will keep trying to re-establish...): {}", (Object)Throwables.getBestMessage(t));
                    logger.debug(t.getMessage(), t);
                }
            });
        }
        this.currResponseObserver = null;
        this.scheduledRetryExecutor.schedule(new RetryAfterError(), 1L, TimeUnit.SECONDS);
    }

    void connectAsync() {
        StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver = this.downstreamServiceStub.connect(this);
        this.currResponseObserver = responseObserver;
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setHello(DownstreamServiceOuterClass.Hello.newBuilder().setAgentId(this.agentId)).build());
    }

    private void onNextInternal(DownstreamServiceOuterClass.CentralRequest request) throws InterruptedException {
        StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver = this.currResponseObserver;
        while (responseObserver == null) {
            TimeUnit.MILLISECONDS.sleep(10L);
            responseObserver = this.currResponseObserver;
        }
        switch (request.getMessageCase()) {
            case AGENT_CONFIG_UPDATE_REQUEST: {
                this.updateConfigAndRespond(request, responseObserver);
                return;
            }
            case THREAD_DUMP_REQUEST: {
                this.threadDumpAndRespond(request, responseObserver);
                return;
            }
            case JSTACK_REQUEST: {
                this.jstackAndRespond(request, responseObserver);
                return;
            }
            case AVAILABLE_DISK_SPACE_REQUEST: {
                this.availableDiskSpaceAndRespond(request, responseObserver);
                return;
            }
            case HEAP_DUMP_REQUEST: {
                this.heapDumpAndRespond(request, responseObserver);
                return;
            }
            case HEAP_HISTOGRAM_REQUEST: {
                this.heapHistogramAndRespond(request, responseObserver);
                return;
            }
            case EXPLICIT_GC_DISABLED_REQUEST: {
                this.explicitGcDisabledAndRespond(request, responseObserver);
                return;
            }
            case FORCE_GC_REQUEST: {
                this.forceGcAndRespond(request, responseObserver);
                return;
            }
            case MBEAN_DUMP_REQUEST: {
                this.mbeanDumpAndRespond(request, responseObserver);
                return;
            }
            case MATCHING_MBEAN_OBJECT_NAMES_REQUEST: {
                this.matchingMBeanObjectNamesAndRespond(request, responseObserver);
                return;
            }
            case MBEAN_META_REQUEST: {
                this.mbeanMetaAndRespond(request, responseObserver);
                return;
            }
            case SYSTEM_PROPERTIES_REQUEST: {
                this.systemPropertiesAndRespond(request, responseObserver);
                return;
            }
            case CURRENT_TIME_REQUEST: {
                this.currentTimeAndRespond(request, responseObserver);
                return;
            }
            case CAPABILITIES_REQUEST: {
                this.capabilitiesAndRespond(request, responseObserver);
                return;
            }
            case GLOBAL_META_REQUEST: {
                this.globalMetaAndRespond(request, responseObserver);
                return;
            }
            case PRELOAD_CLASSPATH_CACHE_REQUEST: {
                this.preloadClasspathCacheAndRespond(request, responseObserver);
                return;
            }
            case MATCHING_CLASS_NAMES_REQUEST: {
                this.matchingClassNamesAndRespond(request, responseObserver);
                return;
            }
            case MATCHING_METHOD_NAMES_REQUEST: {
                this.matchingMethodNamesAndRespond(request, responseObserver);
                return;
            }
            case METHOD_SIGNATURES_REQUEST: {
                this.methodSignaturesAndRespond(request, responseObserver);
                return;
            }
            case REWEAVE_REQUEST: {
                this.reweaveAndRespond(request, responseObserver);
                return;
            }
            case HEADER_REQUEST: {
                this.getHeaderAndRespond(request, responseObserver);
                return;
            }
            case ENTRIES_REQUEST: {
                this.getEntriesAndRespond(request, responseObserver);
                return;
            }
            case QUERIES_REQUEST: {
                this.getQueriesAndRespond(request, responseObserver);
                return;
            }
            case MAIN_THREAD_PROFILE_REQUEST: {
                this.getMainThreadProfileAndRespond(request, responseObserver);
                return;
            }
            case AUX_THREAD_PROFILE_REQUEST: {
                this.getAuxThreadProfileAndRespond(request, responseObserver);
                return;
            }
            case FULL_TRACE_REQUEST: {
                this.getFullTraceAndRespond(request, responseObserver);
                return;
            }
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setUnknownRequestResponse(DownstreamServiceOuterClass.UnknownRequestResponse.getDefaultInstance()).build());
    }

    private void updateConfigAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        if (this.configReadOnly) {
            logger.error("central collector attempted to update agent configuration, but the agent is running with config.readOnly=true");
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        try {
            this.agentConfigUpdater.update(request.getAgentConfigUpdateRequest().getAgentConfig());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setAgentConfigUpdateResponse(DownstreamServiceOuterClass.AgentConfigUpdateResponse.getDefaultInstance()).build());
    }

    private void threadDumpAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        DownstreamServiceOuterClass.ThreadDump threadDump;
        try {
            threadDump = this.liveJvmService.getThreadDump("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setThreadDumpResponse(DownstreamServiceOuterClass.ThreadDumpResponse.newBuilder().setThreadDump(threadDump)).build());
    }

    private void jstackAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        String jstack;
        try {
            jstack = this.liveJvmService.getJstack("");
        }
        catch (LiveJvmService.UnavailableDueToRunningInJreException e) {
            logger.debug(e.getMessage(), e);
            responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setJstackResponse(DownstreamServiceOuterClass.JstackResponse.newBuilder().setUnavailableDueToRunningInJre(true)).build());
            return;
        }
        catch (LiveJvmService.UnavailableDueToRunningInJ9JvmException e) {
            logger.debug(e.getMessage(), e);
            responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setJstackResponse(DownstreamServiceOuterClass.JstackResponse.newBuilder().setUnavailableDueToRunningInJ9Jvm(true)).build());
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setJstackResponse(DownstreamServiceOuterClass.JstackResponse.newBuilder().setJstack(jstack)).build());
    }

    private void availableDiskSpaceAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        long availableDiskSpaceBytes;
        try {
            availableDiskSpaceBytes = this.liveJvmService.getAvailableDiskSpace("", request.getAvailableDiskSpaceRequest().getDirectory());
        }
        catch (LiveJvmService.DirectoryDoesNotExistException e) {
            logger.debug(e.getMessage(), e);
            responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setAvailableDiskSpaceResponse(DownstreamServiceOuterClass.AvailableDiskSpaceResponse.newBuilder().setDirectoryDoesNotExist(true)).build());
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setAvailableDiskSpaceResponse(DownstreamServiceOuterClass.AvailableDiskSpaceResponse.newBuilder().setAvailableBytes(availableDiskSpaceBytes)).build());
    }

    private void heapDumpAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        DownstreamServiceOuterClass.HeapDumpFileInfo heapDumpFileInfo;
        try {
            heapDumpFileInfo = this.liveJvmService.heapDump("", request.getHeapDumpRequest().getDirectory());
        }
        catch (LiveJvmService.DirectoryDoesNotExistException e) {
            logger.debug(e.getMessage(), e);
            responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setHeapDumpResponse(DownstreamServiceOuterClass.HeapDumpResponse.newBuilder().setDirectoryDoesNotExist(true)).build());
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setHeapDumpResponse(DownstreamServiceOuterClass.HeapDumpResponse.newBuilder().setHeapDumpFileInfo(heapDumpFileInfo)).build());
    }

    private void heapHistogramAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        DownstreamServiceOuterClass.HeapHistogram heapHistogram;
        try {
            heapHistogram = this.liveJvmService.heapHistogram("");
        }
        catch (LiveJvmService.UnavailableDueToRunningInJreException e) {
            logger.debug(e.getMessage(), e);
            responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setHeapHistogramResponse(DownstreamServiceOuterClass.HeapHistogramResponse.newBuilder().setUnavailableDueToRunningInJre(true)).build());
            return;
        }
        catch (LiveJvmService.UnavailableDueToRunningInJ9JvmException e) {
            logger.debug(e.getMessage(), e);
            responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setHeapHistogramResponse(DownstreamServiceOuterClass.HeapHistogramResponse.newBuilder().setUnavailableDueToRunningInJ9Jvm(true)).build());
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setHeapHistogramResponse(DownstreamServiceOuterClass.HeapHistogramResponse.newBuilder().setHeapHistogram(heapHistogram)).build());
    }

    private void explicitGcDisabledAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        boolean disabled;
        try {
            disabled = this.liveJvmService.isExplicitGcDisabled("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setExplicitGcDisabledResponse(DownstreamServiceOuterClass.ExplicitGcDisabledResponse.newBuilder().setDisabled(disabled)).build());
    }

    private void forceGcAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        try {
            this.liveJvmService.forceGC("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setForceGcResponse(DownstreamServiceOuterClass.ForceGcResponse.getDefaultInstance()).build());
    }

    private void mbeanDumpAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        DownstreamServiceOuterClass.MBeanDump mbeanDump;
        DownstreamServiceOuterClass.MBeanDumpRequest req = request.getMbeanDumpRequest();
        try {
            mbeanDump = this.liveJvmService.getMBeanDump("", req.getKind(), req.getObjectNameList());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setMbeanDumpResponse(DownstreamServiceOuterClass.MBeanDumpResponse.newBuilder().setMbeanDump(mbeanDump)).build());
    }

    private void matchingMBeanObjectNamesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        List<String> objectNames;
        DownstreamServiceOuterClass.MatchingMBeanObjectNamesRequest req = request.getMatchingMbeanObjectNamesRequest();
        try {
            objectNames = this.liveJvmService.getMatchingMBeanObjectNames("", req.getPartialObjectName(), req.getLimit());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setMatchingMbeanObjectNamesResponse(DownstreamServiceOuterClass.MatchingMBeanObjectNamesResponse.newBuilder().addAllObjectName(objectNames)).build());
    }

    private void mbeanMetaAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        DownstreamServiceOuterClass.MBeanMeta mbeanMeta;
        DownstreamServiceOuterClass.MBeanMetaRequest req = request.getMbeanMetaRequest();
        try {
            mbeanMeta = this.liveJvmService.getMBeanMeta("", req.getObjectName());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setMbeanMetaResponse(DownstreamServiceOuterClass.MBeanMetaResponse.newBuilder().setMbeanMeta(mbeanMeta)).build());
    }

    private void systemPropertiesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        Map<String, String> systemProperties;
        try {
            systemProperties = this.liveJvmService.getSystemProperties("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setSystemPropertiesResponse(DownstreamServiceOuterClass.SystemPropertiesResponse.newBuilder().putAllSystemProperties(systemProperties)).build());
    }

    private void currentTimeAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        long currentTime;
        try {
            currentTime = this.liveJvmService.getCurrentTime("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setCurrentTimeResponse(DownstreamServiceOuterClass.CurrentTimeResponse.newBuilder().setCurrentTimeMillis(currentTime)).build());
    }

    private void capabilitiesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        DownstreamServiceOuterClass.Capabilities capabilities;
        try {
            capabilities = this.liveJvmService.getCapabilities("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setCapabilitiesResponse(DownstreamServiceOuterClass.CapabilitiesResponse.newBuilder().setCapabilities(capabilities)).build());
    }

    private void globalMetaAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        DownstreamServiceOuterClass.GlobalMeta globalMeta;
        try {
            globalMeta = this.liveWeavingService.getGlobalMeta("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setGlobalMetaResponse(DownstreamServiceOuterClass.GlobalMetaResponse.newBuilder().setGlobalMeta(globalMeta)).build());
    }

    private void preloadClasspathCacheAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        try {
            this.liveWeavingService.preloadClasspathCache("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setPreloadClasspathCacheResponse(DownstreamServiceOuterClass.PreloadClasspathCacheResponse.getDefaultInstance()).build());
    }

    private void matchingClassNamesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        List<String> classNames;
        DownstreamServiceOuterClass.MatchingClassNamesRequest req = request.getMatchingClassNamesRequest();
        try {
            classNames = this.liveWeavingService.getMatchingClassNames("", req.getPartialClassName(), req.getLimit());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setMatchingClassNamesResponse(DownstreamServiceOuterClass.MatchingClassNamesResponse.newBuilder().addAllClassName(classNames)).build());
    }

    private void matchingMethodNamesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        List<String> methodNames;
        DownstreamServiceOuterClass.MatchingMethodNamesRequest req = request.getMatchingMethodNamesRequest();
        try {
            methodNames = this.liveWeavingService.getMatchingMethodNames("", req.getClassName(), req.getPartialMethodName(), req.getLimit());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setMatchingMethodNamesResponse(DownstreamServiceOuterClass.MatchingMethodNamesResponse.newBuilder().addAllMethodName(methodNames)).build());
    }

    private void methodSignaturesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        List<DownstreamServiceOuterClass.MethodSignature> methodSignatures;
        DownstreamServiceOuterClass.MethodSignaturesRequest req = request.getMethodSignaturesRequest();
        try {
            methodSignatures = this.liveWeavingService.getMethodSignatures("", req.getClassName(), req.getMethodName());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setMethodSignaturesResponse(DownstreamServiceOuterClass.MethodSignaturesResponse.newBuilder().addAllMethodSignature(methodSignatures)).build());
    }

    private void reweaveAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        int classUpdateCount;
        try {
            classUpdateCount = this.liveWeavingService.reweave("");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setReweaveResponse(DownstreamServiceOuterClass.ReweaveResponse.newBuilder().setClassUpdateCount(classUpdateCount)).build());
    }

    private void getHeaderAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        TraceOuterClass.Trace.Header header;
        try {
            header = this.liveTraceRepository.getHeader("", request.getHeaderRequest().getTraceId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        DownstreamServiceOuterClass.HeaderResponse response = header == null ? DownstreamServiceOuterClass.HeaderResponse.getDefaultInstance() : DownstreamServiceOuterClass.HeaderResponse.newBuilder().setHeader(header).build();
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setHeaderResponse(response).build());
    }

    private void getEntriesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        LiveTraceRepository.Entries entries;
        try {
            entries = this.liveTraceRepository.getEntries("", request.getEntriesRequest().getTraceId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        DownstreamServiceOuterClass.EntriesResponse.Builder response = DownstreamServiceOuterClass.EntriesResponse.newBuilder();
        if (entries != null) {
            response.addAllEntry(entries.entries());
            response.addAllSharedQueryText(this.sharedQueryTextLimiter.reduceTracePayloadWherePossible(entries.sharedQueryTexts()));
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setEntriesResponse(response).build());
    }

    private void getQueriesAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        LiveTraceRepository.Queries queries;
        try {
            queries = this.liveTraceRepository.getQueries("", request.getQueriesRequest().getTraceId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        DownstreamServiceOuterClass.QueriesResponse.Builder response = DownstreamServiceOuterClass.QueriesResponse.newBuilder();
        if (queries != null) {
            response.addAllQuery(queries.queries());
            response.addAllSharedQueryText(this.sharedQueryTextLimiter.reduceTracePayloadWherePossible(queries.sharedQueryTexts()));
        }
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setQueriesResponse(response).build());
    }

    private void getMainThreadProfileAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        ProfileOuterClass.Profile profile;
        try {
            profile = this.liveTraceRepository.getMainThreadProfile("", request.getMainThreadProfileRequest().getTraceId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        DownstreamServiceOuterClass.MainThreadProfileResponse response = profile == null ? DownstreamServiceOuterClass.MainThreadProfileResponse.getDefaultInstance() : DownstreamServiceOuterClass.MainThreadProfileResponse.newBuilder().setProfile(profile).build();
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setMainThreadProfileResponse(response).build());
    }

    private void getAuxThreadProfileAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        ProfileOuterClass.Profile profile;
        try {
            profile = this.liveTraceRepository.getAuxThreadProfile("", request.getAuxThreadProfileRequest().getTraceId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        DownstreamServiceOuterClass.AuxThreadProfileResponse response = profile == null ? DownstreamServiceOuterClass.AuxThreadProfileResponse.getDefaultInstance() : DownstreamServiceOuterClass.AuxThreadProfileResponse.newBuilder().setProfile(profile).build();
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setAuxThreadProfileResponse(response).build());
    }

    private void getFullTraceAndRespond(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        TraceOuterClass.Trace trace;
        try {
            trace = this.liveTraceRepository.getFullTrace("", request.getFullTraceRequest().getTraceId());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            DownstreamServiceObserver.sendExceptionResponse(request, responseObserver);
            return;
        }
        DownstreamServiceOuterClass.FullTraceResponse response = trace == null ? DownstreamServiceOuterClass.FullTraceResponse.getDefaultInstance() : DownstreamServiceOuterClass.FullTraceResponse.newBuilder().setTrace(trace).build();
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setFullTraceResponse(response).build());
    }

    @OnlyUsedByTests
    void close() throws InterruptedException {
        StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver = this.currResponseObserver;
        while (responseObserver == null) {
            TimeUnit.MILLISECONDS.sleep(10L);
            responseObserver = this.currResponseObserver;
        }
        responseObserver.onCompleted();
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (stopwatch.elapsed(TimeUnit.SECONDS) < 10L && !this.closedByCentralCollector) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Preconditions.checkState(this.closedByCentralCollector);
    }

    private static void sendExceptionResponse(DownstreamServiceOuterClass.CentralRequest request, StreamObserver<DownstreamServiceOuterClass.AgentResponse> responseObserver) {
        responseObserver.onNext(DownstreamServiceOuterClass.AgentResponse.newBuilder().setRequestId(request.getRequestId()).setExceptionResponse(DownstreamServiceOuterClass.ExceptionResponse.getDefaultInstance()).build());
    }

    private class RetryAfterError
    implements Runnable {
        private RetryAfterError() {
        }

        @Override
        public void run() {
            try {
                DownstreamServiceObserver.this.connectAsync();
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
            }
        }
    }
}

