/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.api;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.glowroot.agent.api.internal.GlowrootService;
import org.glowroot.agent.api.internal.NopGlowrootService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Glowroot {
    private static final Logger logger;
    private static final GlowrootService glowrootService;

    private Glowroot() {
    }

    public static void setTransactionType(@Nullable String transactionType) {
        glowrootService.setTransactionType(transactionType);
    }

    public static void setTransactionName(@Nullable String transactionName) {
        glowrootService.setTransactionName(transactionName);
    }

    public static void setTransactionUser(@Nullable String user) {
        glowrootService.setTransactionUser(user);
    }

    public static void addTransactionAttribute(String name, @Nullable String value) {
        glowrootService.addTransactionAttribute(name, value);
    }

    public static void setTransactionSlowThreshold(long threshold, TimeUnit unit) {
        glowrootService.setTransactionSlowThreshold(threshold, unit);
    }

    public static void setTransactionOuter() {
        glowrootService.setTransactionOuter();
    }

    @Deprecated
    public static void setOuterTransaction() {
        Glowroot.setTransactionOuter();
    }

    static {
        GlowrootService service;
        logger = LoggerFactory.getLogger(Glowroot.class);
        try {
            Class<?> registryClass = Class.forName("org.glowroot.agent.impl.ServiceRegistryImpl");
            Method getInstanceMethod = registryClass.getMethod("getGlowrootService", new Class[0]);
            service = (GlowrootService)getInstanceMethod.invoke(null, new Object[0]);
            if (service == null) {
                service = NopGlowrootService.INSTANCE;
            }
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            service = NopGlowrootService.INSTANCE;
        }
        glowrootService = service;
    }
}

