/*
 * Decompiled with CFR 0.152.
 */
package org.gillius.jfxutils.chart;

import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.Region;
import org.gillius.jfxutils.JFXUtil;

public class XYChartInfo {
    private final XYChart<?, ?> chart;
    private final Node referenceNode;

    public XYChartInfo(XYChart<?, ?> chart, Node referenceNode) {
        this.chart = chart;
        this.referenceNode = referenceNode;
    }

    public XYChartInfo(XYChart<?, ?> chart) {
        this(chart, (Node)chart);
    }

    public XYChart<?, ?> getChart() {
        return this.chart;
    }

    public Node getReferenceNode() {
        return this.referenceNode;
    }

    public Point2D getDataCoordinates(double x, double y) {
        Axis xAxis = this.chart.getXAxis();
        Axis yAxis = this.chart.getYAxis();
        double xStart = JFXUtil.getXShift((Node)xAxis, this.referenceNode);
        double yStart = JFXUtil.getYShift((Node)yAxis, this.referenceNode);
        return new Point2D(xAxis.toNumericValue(xAxis.getValueForDisplay(x - xStart)), yAxis.toNumericValue(yAxis.getValueForDisplay(y - yStart)));
    }

    public Rectangle2D getDataCoordinates(double minX, double minY, double maxX, double maxY) {
        if (minX > maxX || minY > maxY) {
            throw new IllegalArgumentException("min > max for X and/or Y");
        }
        Axis xAxis = this.chart.getXAxis();
        Axis yAxis = this.chart.getYAxis();
        double xStart = JFXUtil.getXShift((Node)xAxis, this.referenceNode);
        double yStart = JFXUtil.getYShift((Node)yAxis, this.referenceNode);
        double minDataX = xAxis.toNumericValue(xAxis.getValueForDisplay(minX - xStart));
        double maxDataX = xAxis.toNumericValue(xAxis.getValueForDisplay(maxX - xStart));
        double minDataY = yAxis.toNumericValue(yAxis.getValueForDisplay(maxY - yStart));
        double maxDataY = yAxis.toNumericValue(yAxis.getValueForDisplay(minY - yStart));
        return new Rectangle2D(minDataX, minDataY, maxDataX - minDataX, maxDataY - minDataY);
    }

    public boolean isInPlotArea(double x, double y) {
        return this.getPlotArea().contains(x, y);
    }

    public Rectangle2D getPlotArea() {
        Axis xAxis = this.chart.getXAxis();
        Axis yAxis = this.chart.getYAxis();
        double xStart = JFXUtil.getXShift((Node)xAxis, this.referenceNode);
        double yStart = JFXUtil.getYShift((Node)yAxis, this.referenceNode);
        double width = xAxis.getWidth();
        double height = yAxis.getHeight();
        return new Rectangle2D(xStart, yStart, width, height);
    }

    public Rectangle2D getXAxisArea() {
        return this.getComponentArea((Region)this.chart.getXAxis());
    }

    public Rectangle2D getYAxisArea() {
        return this.getComponentArea((Region)this.chart.getYAxis());
    }

    private Rectangle2D getComponentArea(Region childRegion) {
        double xStart = JFXUtil.getXShift((Node)childRegion, this.referenceNode);
        double yStart = JFXUtil.getYShift((Node)childRegion, this.referenceNode);
        return new Rectangle2D(xStart, yStart, childRegion.getWidth(), childRegion.getHeight());
    }
}

