/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.io.IOException;
import java.io.StringReader;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.types.TimestampBooleanMap;
import org.gephi.graph.api.types.TimestampByteMap;
import org.gephi.graph.api.types.TimestampCharMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampFloatMap;
import org.gephi.graph.api.types.TimestampIntegerMap;
import org.gephi.graph.api.types.TimestampLongMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.api.types.TimestampShortMap;
import org.gephi.graph.api.types.TimestampStringMap;
import org.gephi.graph.impl.FormattingAndParsingUtils;

public final class TimestampsParser {
    public static TimestampSet parseTimestampSet(String input, ZoneId zoneId) throws IllegalArgumentException {
        if (input == null) {
            return null;
        }
        if (input.equalsIgnoreCase("<empty>")) {
            return new TimestampSet();
        }
        ArrayList<String> values = new ArrayList<String>();
        try {
            int r;
            StringReader reader = new StringReader(input + " ");
            block8: while ((r = reader.read()) != -1) {
                char c = (char)r;
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '<': 
                    case '>': 
                    case '[': 
                    case ']': {
                        continue block8;
                    }
                    case '\"': 
                    case '\'': {
                        values.add(FormattingAndParsingUtils.parseLiteral(reader, c));
                        continue block8;
                    }
                }
                reader.skip(-1L);
                values.add(FormattingAndParsingUtils.parseValue(reader));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected expection while parsing timestamps", ex);
        }
        TimestampSet result = new TimestampSet(values.size());
        try {
            for (String value : values) {
                result.add(FormattingAndParsingUtils.parseDateTimeOrTimestamp(value, zoneId));
            }
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("Invalid timestamp value: " + ex.getMessage(), ex);
        }
        return result;
    }

    public static TimestampSet parseTimestampSet(String input) throws IllegalArgumentException {
        return TimestampsParser.parseTimestampSet(input, null);
    }

    public static <T> TimestampMap<T> parseTimestampMap(Class<T> typeClass, String input, ZoneId zoneId) throws IllegalArgumentException {
        TimestampMap result;
        if (typeClass == null) {
            throw new IllegalArgumentException("typeClass required");
        }
        if (input == null) {
            return null;
        }
        if ((typeClass = AttributeUtils.getStandardizedType(typeClass)).equals(String.class)) {
            result = new TimestampStringMap();
        } else if (typeClass.equals(Byte.class)) {
            result = new TimestampByteMap();
        } else if (typeClass.equals(Short.class)) {
            result = new TimestampShortMap();
        } else if (typeClass.equals(Integer.class)) {
            result = new TimestampIntegerMap();
        } else if (typeClass.equals(Long.class)) {
            result = new TimestampLongMap();
        } else if (typeClass.equals(Float.class)) {
            result = new TimestampFloatMap();
        } else if (typeClass.equals(Double.class)) {
            result = new TimestampDoubleMap();
        } else if (typeClass.equals(Boolean.class)) {
            result = new TimestampBooleanMap();
        } else if (typeClass.equals(Character.class)) {
            result = new TimestampCharMap();
        } else {
            throw new IllegalArgumentException("Unsupported type " + typeClass.getClass().getCanonicalName());
        }
        if (input.equalsIgnoreCase("<empty>")) {
            return result;
        }
        StringReader reader = new StringReader(input + " ");
        try {
            int r;
            block5: while ((r = reader.read()) != -1) {
                char c = (char)r;
                switch (c) {
                    case '(': 
                    case '[': {
                        TimestampsParser.parseTimestampAndValue(typeClass, reader, result, zoneId);
                        continue block5;
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected expection while parsing timestamps", ex);
        }
        return result;
    }

    public static <T> TimestampMap<T> parseTimestampMap(Class<T> typeClass, String input) throws IllegalArgumentException {
        return TimestampsParser.parseTimestampMap(typeClass, input, null);
    }

    private static <T> void parseTimestampAndValue(Class<T> typeClass, StringReader reader, TimestampMap<T> result, ZoneId zoneId) throws IOException {
        int r;
        ArrayList<String> values = new ArrayList<String>();
        block5: while ((r = reader.read()) != -1) {
            char c = (char)r;
            switch (c) {
                case ')': 
                case ']': {
                    TimestampsParser.addTimestampAndValue(typeClass, values, result, zoneId);
                    return;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    continue block5;
                }
                case '\"': 
                case '\'': {
                    values.add(FormattingAndParsingUtils.parseLiteral(reader, c));
                    continue block5;
                }
            }
            reader.skip(-1L);
            values.add(FormattingAndParsingUtils.parseValue(reader));
        }
        TimestampsParser.addTimestampAndValue(typeClass, values, result, zoneId);
    }

    private static <T> void addTimestampAndValue(Class<T> typeClass, ArrayList<String> values, TimestampMap<T> result, ZoneId zoneId) {
        if (values.size() != 2) {
            throw new IllegalArgumentException("Each timestamp and value array must have 2 values");
        }
        try {
            double timestamp = FormattingAndParsingUtils.parseDateTimeOrTimestamp(values.get(0), zoneId);
            String valString = values.get(1);
            T value = FormattingAndParsingUtils.convertValue(typeClass, valString);
            result.put(timestamp, value);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException("Invalid timestamp value: " + values.get(0), ex);
        }
    }
}

