/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.impl.GraphStoreConfiguration;

public class ConfigurationImpl {
    private final Class nodeIdType;
    private final Class edgeIdType;
    private final Class edgeLabelType;
    private final Class edgeWeightType;
    private final TimeRepresentation timeRepresentation;
    private final boolean edgeWeightColumn;
    private final boolean enableAutoLocking;
    private final boolean enableAutoEdgeTypeRegistration;
    private final boolean enableIndexNodes;
    private final boolean enableIndexEdges;
    private final boolean enableIndexTime;
    private final boolean enableObservers;
    private final boolean enableNodeProperties;
    private final boolean enableEdgeProperties;
    private final boolean enableSpatialIndex;
    private final boolean enableParallelEdgesSameType;

    public ConfigurationImpl() {
        this.nodeIdType = GraphStoreConfiguration.DEFAULT_NODE_ID_TYPE;
        this.edgeIdType = GraphStoreConfiguration.DEFAULT_EDGE_ID_TYPE;
        this.edgeLabelType = GraphStoreConfiguration.DEFAULT_EDGE_LABEL_TYPE;
        this.edgeWeightType = GraphStoreConfiguration.DEFAULT_EDGE_WEIGHT_TYPE;
        this.timeRepresentation = GraphStoreConfiguration.DEFAULT_TIME_REPRESENTATION;
        this.edgeWeightColumn = true;
        this.enableAutoLocking = true;
        this.enableAutoEdgeTypeRegistration = true;
        this.enableIndexNodes = true;
        this.enableIndexEdges = true;
        this.enableIndexTime = true;
        this.enableObservers = true;
        this.enableNodeProperties = true;
        this.enableEdgeProperties = true;
        this.enableSpatialIndex = false;
        this.enableParallelEdgesSameType = true;
    }

    public ConfigurationImpl(Configuration configuration) {
        this.nodeIdType = configuration.getNodeIdType();
        this.edgeIdType = configuration.getEdgeIdType();
        this.edgeLabelType = configuration.getEdgeLabelType();
        this.edgeWeightType = configuration.getEdgeWeightType();
        this.timeRepresentation = configuration.getTimeRepresentation();
        this.edgeWeightColumn = configuration.getEdgeWeightColumn();
        this.enableAutoLocking = configuration.isEnableAutoLocking();
        this.enableAutoEdgeTypeRegistration = configuration.isEnableAutoEdgeTypeRegistration();
        this.enableIndexNodes = configuration.isEnableIndexNodes();
        this.enableIndexEdges = configuration.isEnableIndexEdges();
        this.enableIndexTime = configuration.isEnableIndexTime();
        this.enableObservers = configuration.isEnableObservers();
        this.enableNodeProperties = configuration.isEnableNodeProperties();
        this.enableEdgeProperties = configuration.isEnableEdgeProperties();
        this.enableSpatialIndex = configuration.isEnableSpatialIndex();
        this.enableParallelEdgesSameType = configuration.isEnableParallelEdgesSameType();
    }

    public Configuration toConfiguration() {
        return new ConfigurationProxy(this);
    }

    public Class getNodeIdType() {
        return this.nodeIdType;
    }

    public Class getEdgeIdType() {
        return this.edgeIdType;
    }

    public Class getEdgeLabelType() {
        return this.edgeLabelType;
    }

    public Class getEdgeWeightType() {
        return this.edgeWeightType;
    }

    public TimeRepresentation getTimeRepresentation() {
        return this.timeRepresentation;
    }

    public boolean isEdgeWeightColumn() {
        return this.edgeWeightColumn;
    }

    public boolean isEnableAutoLocking() {
        return this.enableAutoLocking;
    }

    public boolean isEnableAutoEdgeTypeRegistration() {
        return this.enableAutoEdgeTypeRegistration;
    }

    public boolean isEnableIndexNodes() {
        return this.enableIndexNodes;
    }

    public boolean isEnableIndexEdges() {
        return this.enableIndexEdges;
    }

    public boolean isEnableIndexTime() {
        return this.enableIndexTime;
    }

    public boolean isEnableObservers() {
        return this.enableObservers;
    }

    public boolean isEnableNodeProperties() {
        return this.enableNodeProperties;
    }

    public boolean isEnableEdgeProperties() {
        return this.enableEdgeProperties;
    }

    public boolean isEnableSpatialIndex() {
        return this.enableSpatialIndex;
    }

    public boolean isEnableParallelEdgesSameType() {
        return this.enableParallelEdgesSameType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationImpl)) {
            return false;
        }
        ConfigurationImpl that = (ConfigurationImpl)o;
        if (this.isEdgeWeightColumn() != that.isEdgeWeightColumn()) {
            return false;
        }
        if (this.isEnableAutoLocking() != that.isEnableAutoLocking()) {
            return false;
        }
        if (this.isEnableAutoEdgeTypeRegistration() != that.isEnableAutoEdgeTypeRegistration()) {
            return false;
        }
        if (this.isEnableIndexNodes() != that.isEnableIndexNodes()) {
            return false;
        }
        if (this.isEnableIndexEdges() != that.isEnableIndexEdges()) {
            return false;
        }
        if (this.isEnableIndexTime() != that.isEnableIndexTime()) {
            return false;
        }
        if (this.isEnableObservers() != that.isEnableObservers()) {
            return false;
        }
        if (this.isEnableNodeProperties() != that.isEnableNodeProperties()) {
            return false;
        }
        if (this.isEnableEdgeProperties() != that.isEnableEdgeProperties()) {
            return false;
        }
        if (this.isEnableSpatialIndex() != that.isEnableSpatialIndex()) {
            return false;
        }
        if (this.isEnableParallelEdgesSameType() != that.isEnableParallelEdgesSameType()) {
            return false;
        }
        if (!this.getNodeIdType().equals(that.getNodeIdType())) {
            return false;
        }
        if (!this.getEdgeIdType().equals(that.getEdgeIdType())) {
            return false;
        }
        if (!this.getEdgeLabelType().equals(that.getEdgeLabelType())) {
            return false;
        }
        if (!this.getEdgeWeightType().equals(that.getEdgeWeightType())) {
            return false;
        }
        return this.getTimeRepresentation() == that.getTimeRepresentation();
    }

    public int hashCode() {
        int result = this.getNodeIdType().hashCode();
        result = 31 * result + this.getEdgeIdType().hashCode();
        result = 31 * result + this.getEdgeLabelType().hashCode();
        result = 31 * result + this.getEdgeWeightType().hashCode();
        result = 31 * result + this.getTimeRepresentation().hashCode();
        result = 31 * result + (this.isEdgeWeightColumn() ? 1 : 0);
        result = 31 * result + (this.isEnableAutoLocking() ? 1 : 0);
        result = 31 * result + (this.isEnableAutoEdgeTypeRegistration() ? 1 : 0);
        result = 31 * result + (this.isEnableIndexNodes() ? 1 : 0);
        result = 31 * result + (this.isEnableIndexEdges() ? 1 : 0);
        result = 31 * result + (this.isEnableIndexTime() ? 1 : 0);
        result = 31 * result + (this.isEnableObservers() ? 1 : 0);
        result = 31 * result + (this.isEnableNodeProperties() ? 1 : 0);
        result = 31 * result + (this.isEnableEdgeProperties() ? 1 : 0);
        result = 31 * result + (this.isEnableSpatialIndex() ? 1 : 0);
        result = 31 * result + (this.isEnableParallelEdgesSameType() ? 1 : 0);
        return result;
    }

    private static class ConfigurationProxy
    extends Configuration {
        private ConfigurationProxy(ConfigurationImpl impl) {
            super(impl);
        }
    }
}

