/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampLongMap
extends TimestampMap<Long> {
    private long[] values;

    public TimestampLongMap() {
        this.values = new long[0];
    }

    public TimestampLongMap(int capacity) {
        super(capacity);
        this.values = new long[capacity];
    }

    public TimestampLongMap(double[] keys, long[] vals) {
        super(keys);
        this.values = new long[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public TimestampLongMap(TimestampLongMap source) {
        this(source.array, source.values);
    }

    public long getLong(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public long getLong(double timestamp, long defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Long.valueOf(max.longValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Long.valueOf(min.longValue()) : null;
    }

    @Override
    public Class<Long> getTypeClass() {
        return Long.class;
    }

    public long[] toLongArray() {
        return (long[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Long getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (long[])array;
    }
}

