/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import java.math.BigDecimal;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampFloatMap
extends TimestampMap<Float> {
    private float[] values;

    public TimestampFloatMap() {
        this.values = new float[0];
    }

    public TimestampFloatMap(int capacity) {
        super(capacity);
        this.values = new float[capacity];
    }

    public TimestampFloatMap(double[] keys, float[] vals) {
        super(keys);
        this.values = new float[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public TimestampFloatMap(TimestampFloatMap source) {
        this(source.array, source.values);
    }

    public float getFloat(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public float getFloat(double timestamp, float defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    protected Object getAverage(Interval interval) {
        BigDecimal average = this.getAverageBigDecimal(interval);
        return average != null ? Float.valueOf(average.floatValue()) : null;
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Float.valueOf(max.floatValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Float.valueOf(min.floatValue()) : null;
    }

    @Override
    public Class<Float> getTypeClass() {
        return Float.class;
    }

    public float[] toFloatArray() {
        return (float[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Float getValue(int index) {
        return Float.valueOf(this.values[index]);
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (float[])array;
    }
}

