/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalStringMap
extends IntervalMap<String> {
    private String[] values;

    public IntervalStringMap() {
        this.values = new String[0];
    }

    public IntervalStringMap(int capacity) {
        super(capacity);
        this.values = new String[capacity];
    }

    public IntervalStringMap(double[] keys, String[] vals) {
        super(keys);
        this.values = new String[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public IntervalStringMap(IntervalStringMap source) {
        this(source.array, source.values);
    }

    @Override
    public Class<String> getTypeClass() {
        return String.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.FIRST, Estimator.LAST);
    }

    @Override
    protected String getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (String[])array;
    }
}

