/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalDoubleMap
extends IntervalMap<Double> {
    private double[] values;

    public IntervalDoubleMap() {
        this.values = new double[0];
    }

    public IntervalDoubleMap(int capacity) {
        super(capacity);
        this.values = new double[capacity];
    }

    public IntervalDoubleMap(double[] keys, double[] vals) {
        super(keys);
        this.values = new double[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public IntervalDoubleMap(IntervalDoubleMap source) {
        this(source.array, source.values);
    }

    public double getDouble(Interval interval) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public double getDouble(Interval interval, double defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        return defaultValue;
    }

    public double[] toDoubleArray() {
        return (double[])this.toNativeArray();
    }

    @Override
    public Class<Double> getTypeClass() {
        return Double.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Double getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (double[])array;
    }
}

