/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import java.util.Arrays;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.TimeSet;
import org.joda.time.DateTimeZone;

public final class IntervalSet
implements TimeSet<Interval> {
    private double[] array;
    private int size = 0;

    public IntervalSet() {
        this.array = new double[0];
    }

    public IntervalSet(int capacity) {
        this.array = new double[capacity * 2];
        Arrays.fill(this.array, 2.147483647E9);
    }

    public IntervalSet(double[] arr) {
        this.array = new double[arr.length];
        System.arraycopy(arr, 0, this.array, 0, arr.length);
        this.size = arr.length / 2;
    }

    @Override
    public boolean add(Interval interval) {
        return this.addInner(interval.getLow(), interval.getHigh()) >= 0;
    }

    @Override
    public boolean remove(Interval interval) {
        return this.removeInner(interval.getLow(), interval.getHigh()) >= 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(double timestamp) {
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, timestamp);
        return index >= 0 && index < realSize;
    }

    @Override
    public boolean contains(Interval interval) {
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, interval.getLow());
        if (index >= 0) {
            int foundIndex;
            int n = foundIndex = index % 2 == 0 ? index : index - 1;
            while (foundIndex < realSize && foundIndex >= 0) {
                int shift;
                double startValue = this.array[foundIndex];
                if (startValue > interval.getLow()) {
                    return false;
                }
                double endValue = this.array[foundIndex + 1];
                if (startValue == interval.getLow() && endValue > interval.getHigh()) {
                    return false;
                }
                if ((interval.getHigh() > endValue ? 2 : (interval.getHigh() < endValue ? -2 : (shift = interval.getLow() > startValue ? 2 : 0))) == 0) {
                    return true;
                }
                foundIndex += shift;
            }
        }
        return false;
    }

    public double[] getIntervals() {
        int realSize = this.size * 2;
        if (realSize < this.array.length) {
            double[] res = new double[realSize];
            System.arraycopy(this.array, 0, res, 0, realSize);
            return res;
        }
        return this.array;
    }

    public Interval[] toArray() {
        Interval[] res = new Interval[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = new Interval(this.array[i * 2], this.array[i * 2 + 1]);
        }
        return res;
    }

    @Override
    public Object toPrimitiveArray() {
        return this.toArray();
    }

    @Override
    public void clear() {
        this.size = 0;
        this.array = new double[0];
    }

    private int addInner(double intervalStart, double intervalEnd) {
        int insertIndex;
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, intervalStart);
        if (index < 0) {
            double currentValue;
            int insertIndex2 = -index - 1;
            if (insertIndex2 % 2 == 1) {
                this.overlappingIntervallException();
            }
            if (insertIndex2 < realSize && intervalEnd > (currentValue = this.array[insertIndex2])) {
                this.overlappingIntervallException();
            }
            if (realSize < this.array.length - 2) {
                if (insertIndex2 < realSize) {
                    System.arraycopy(this.array, insertIndex2, this.array, insertIndex2 + 2, realSize - insertIndex2);
                }
                this.array[insertIndex2] = intervalStart;
                this.array[insertIndex2 + 1] = intervalEnd;
            } else {
                double[] newArray = new double[this.array.length + 2];
                System.arraycopy(this.array, 0, newArray, 0, insertIndex2);
                System.arraycopy(this.array, insertIndex2, newArray, insertIndex2 + 2, this.array.length - insertIndex2);
                newArray[insertIndex2] = intervalStart;
                newArray[insertIndex2 + 1] = intervalEnd;
                this.array = newArray;
            }
            ++this.size;
            return insertIndex2;
        }
        int n = insertIndex = index % 2 == 0 ? index : index - 1;
        while (insertIndex < realSize && insertIndex >= 0) {
            int shift;
            double startValue = this.array[insertIndex];
            double endValue = this.array[insertIndex + 1];
            if (startValue > intervalStart) {
                if (!(intervalEnd >= endValue)) break;
                this.overlappingIntervallException();
                break;
            }
            if (startValue == intervalStart && endValue > intervalEnd) {
                if (intervalEnd <= startValue) break;
                this.overlappingIntervallException();
            }
            int n2 = intervalEnd > endValue ? 2 : (intervalEnd < endValue ? -2 : (shift = intervalStart > startValue ? 2 : 0));
            if (shift == 0) {
                return -1;
            }
            if (startValue == intervalStart && endValue < intervalEnd && startValue != endValue) {
                this.overlappingIntervallException();
            }
            insertIndex += shift;
        }
        if (realSize < this.array.length - 2) {
            if (insertIndex < realSize) {
                System.arraycopy(this.array, insertIndex, this.array, insertIndex + 2, realSize - insertIndex);
            }
            this.array[insertIndex] = intervalStart;
            this.array[insertIndex + 1] = intervalEnd;
        } else {
            double[] newArray = new double[this.array.length + 2];
            System.arraycopy(this.array, 0, newArray, 0, insertIndex);
            System.arraycopy(this.array, insertIndex, newArray, insertIndex + 2, this.array.length - insertIndex);
            newArray[insertIndex] = intervalStart;
            newArray[insertIndex + 1] = intervalEnd;
            this.array = newArray;
        }
        ++this.size;
        return insertIndex;
    }

    private int removeInner(double intervalStart, double intervalEnd) {
        int realSize = this.size * 2;
        int index = Arrays.binarySearch(this.array, 0, realSize, intervalStart);
        if (index >= 0) {
            int removeIndex;
            int n = removeIndex = index % 2 == 0 ? index : index - 1;
            while (removeIndex < realSize && removeIndex >= 0) {
                int shift;
                double startValue = this.array[removeIndex];
                if (startValue > intervalStart) {
                    return -1;
                }
                double endValue = this.array[removeIndex + 1];
                if (startValue == intervalStart && endValue > intervalEnd) {
                    return -1;
                }
                if ((intervalEnd > endValue ? 2 : (intervalEnd < endValue ? -2 : (shift = intervalStart > startValue ? 2 : 0))) == 0) {
                    if (removeIndex == realSize - 2) {
                        --this.size;
                    } else {
                        System.arraycopy(this.array, removeIndex + 2, this.array, removeIndex, realSize - removeIndex - 2);
                        --this.size;
                    }
                    return removeIndex;
                }
                removeIndex += shift;
            }
        }
        return -1;
    }

    private void overlappingIntervallException() {
        throw new IllegalArgumentException("Overlapping intervals aren't allowed");
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.size;
        int realSize = this.size * 2;
        for (int i = 0; i < realSize; ++i) {
            double t = this.array[i];
            hash = 37 * hash + (int)(Double.doubleToLongBits(t) ^ Double.doubleToLongBits(t) >>> 32);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        if (this.size != other.size) {
            return false;
        }
        int realSize = this.size * 2;
        for (int i = 0; i < realSize; ++i) {
            double i1 = this.array[i];
            double i2 = other.array[i];
            if (i1 == i2) continue;
            return false;
        }
        return true;
    }

    public String toString(TimeFormat timeFormat, DateTimeZone timeZone) {
        if (this.size == 0) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int i = 0; i < this.size; ++i) {
            sb.append('[');
            sb.append(AttributeUtils.printTimestampInFormat(this.array[i * 2], timeFormat, timeZone));
            sb.append(", ");
            sb.append(AttributeUtils.printTimestampInFormat(this.array[i * 2 + 1], timeFormat, timeZone));
            sb.append(']');
            if (i >= this.size - 1) continue;
            sb.append("; ");
        }
        sb.append('>');
        return sb.toString();
    }

    public String toString(TimeFormat timeFormat) {
        return this.toString(timeFormat, null);
    }

    public String toString() {
        return this.toString(TimeFormat.DOUBLE, null);
    }
}

