/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.IntervalBooleanMap;
import org.gephi.graph.api.types.IntervalByteMap;
import org.gephi.graph.api.types.IntervalCharMap;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalFloatMap;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.IntervalLongMap;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.IntervalShortMap;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimestampBooleanMap;
import org.gephi.graph.api.types.TimestampByteMap;
import org.gephi.graph.api.types.TimestampCharMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampFloatMap;
import org.gephi.graph.api.types.TimestampIntegerMap;
import org.gephi.graph.api.types.TimestampLongMap;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.api.types.TimestampShortMap;
import org.gephi.graph.api.types.TimestampStringMap;
import org.gephi.graph.impl.ArraysParser;
import org.gephi.graph.impl.FormattingAndParsingUtils;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.IntervalsParser;
import org.gephi.graph.impl.TimestampsParser;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class AttributeUtils {
    private static final Set<Class> SUPPORTED_TYPES;
    private static final Map<Class, Class> TYPES_STANDARDIZATION;
    private static final DateTimeFormatter DATE_TIME_PARSER;
    private static final DateTimeFormatter DATE_PRINTER;
    private static final DateTimeFormatter DATE_TIME_PRINTER;
    private static final DecimalFormat TIMESTAMP_PRINTER;
    private static final Map<DateTimeZone, DateTimeFormatter> DATE_PRINTERS_BY_TIMEZONE;
    private static final Map<DateTimeZone, DateTimeFormatter> DATE_TIME_PRINTERS_BY_TIMEZONE;
    private static final Map<DateTimeZone, DateTimeFormatter> DATE_TIME_PARSERS_BY_TIMEZONE;

    private AttributeUtils() {
    }

    private static DateTimeFormatter getDateTimeFormatterByTimeZone(Map<DateTimeZone, DateTimeFormatter> cache, DateTimeFormatter baseFormatter, DateTimeZone timeZone) {
        if (timeZone == null) {
            return baseFormatter;
        }
        DateTimeFormatter formatter = cache.get(timeZone);
        if (formatter == null) {
            formatter = baseFormatter.withZone(timeZone);
            cache.put(timeZone, formatter);
        }
        return formatter;
    }

    private static DateTimeFormatter getDateTimeParserByTimeZone(DateTimeZone timeZone) {
        return AttributeUtils.getDateTimeFormatterByTimeZone(DATE_TIME_PARSERS_BY_TIMEZONE, DATE_TIME_PARSER, timeZone);
    }

    private static DateTimeFormatter getDateTimePrinterByTimeZone(DateTimeZone timeZone) {
        return AttributeUtils.getDateTimeFormatterByTimeZone(DATE_TIME_PRINTERS_BY_TIMEZONE, DATE_TIME_PRINTER, timeZone);
    }

    private static DateTimeFormatter getDatePrinterByTimeZone(DateTimeZone timeZone) {
        return AttributeUtils.getDateTimeFormatterByTimeZone(DATE_PRINTERS_BY_TIMEZONE, DATE_PRINTER, timeZone);
    }

    public static Object parse(String str, Class typeClass, DateTimeZone timeZone) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        if (typeClass.isPrimitive()) {
            typeClass = AttributeUtils.getStandardizedType(typeClass);
        }
        if (typeClass.equals(String.class)) {
            return str;
        }
        if (typeClass.equals(Byte.class)) {
            return new Byte(str);
        }
        if (typeClass.equals(Short.class)) {
            return new Short(str);
        }
        if (typeClass.equals(Integer.class)) {
            return new Integer(str);
        }
        if (typeClass.equals(Long.class)) {
            return new Long(str);
        }
        if (typeClass.equals(Float.class)) {
            return new Float(str);
        }
        if (typeClass.equals(Double.class)) {
            return new Double(str);
        }
        if (typeClass.equals(BigInteger.class)) {
            return new BigInteger(str);
        }
        if (typeClass.equals(BigDecimal.class)) {
            return new BigDecimal(str);
        }
        if (typeClass.equals(Boolean.class)) {
            if (str.length() == 1) {
                if (str.charAt(0) == '1') {
                    return Boolean.TRUE;
                }
                if (str.charAt(0) == '0') {
                    return Boolean.FALSE;
                }
            }
            return Boolean.valueOf(str);
        }
        if (typeClass.equals(Character.class)) {
            if (str.length() > 1) {
                throw new IllegalArgumentException("The string has a length > 1");
            }
            return Character.valueOf(str.charAt(0));
        }
        if (typeClass.equals(IntervalSet.class)) {
            return IntervalsParser.parseIntervalSet(str, timeZone);
        }
        if (typeClass.equals(IntervalStringMap.class)) {
            return IntervalsParser.parseIntervalMap(String.class, str, timeZone);
        }
        if (typeClass.equals(IntervalByteMap.class)) {
            return IntervalsParser.parseIntervalMap(Byte.class, str, timeZone);
        }
        if (typeClass.equals(IntervalShortMap.class)) {
            return IntervalsParser.parseIntervalMap(Short.class, str, timeZone);
        }
        if (typeClass.equals(IntervalIntegerMap.class)) {
            return IntervalsParser.parseIntervalMap(Integer.class, str, timeZone);
        }
        if (typeClass.equals(IntervalLongMap.class)) {
            return IntervalsParser.parseIntervalMap(Long.class, str, timeZone);
        }
        if (typeClass.equals(IntervalFloatMap.class)) {
            return IntervalsParser.parseIntervalMap(Float.class, str, timeZone);
        }
        if (typeClass.equals(IntervalDoubleMap.class)) {
            return IntervalsParser.parseIntervalMap(Double.class, str, timeZone);
        }
        if (typeClass.equals(IntervalBooleanMap.class)) {
            return IntervalsParser.parseIntervalMap(Boolean.class, str, timeZone);
        }
        if (typeClass.equals(IntervalCharMap.class)) {
            return IntervalsParser.parseIntervalMap(Character.class, str, timeZone);
        }
        if (typeClass.equals(TimestampSet.class)) {
            return TimestampsParser.parseTimestampSet(str, timeZone);
        }
        if (typeClass.equals(TimestampStringMap.class)) {
            return TimestampsParser.parseTimestampMap(String.class, str, timeZone);
        }
        if (typeClass.equals(TimestampByteMap.class)) {
            return TimestampsParser.parseTimestampMap(Byte.class, str, timeZone);
        }
        if (typeClass.equals(TimestampShortMap.class)) {
            return TimestampsParser.parseTimestampMap(Short.class, str, timeZone);
        }
        if (typeClass.equals(TimestampIntegerMap.class)) {
            return TimestampsParser.parseTimestampMap(Integer.class, str, timeZone);
        }
        if (typeClass.equals(TimestampLongMap.class)) {
            return TimestampsParser.parseTimestampMap(Long.class, str, timeZone);
        }
        if (typeClass.equals(TimestampFloatMap.class)) {
            return TimestampsParser.parseTimestampMap(Float.class, str, timeZone);
        }
        if (typeClass.equals(TimestampDoubleMap.class)) {
            return TimestampsParser.parseTimestampMap(Double.class, str, timeZone);
        }
        if (typeClass.equals(TimestampBooleanMap.class)) {
            return TimestampsParser.parseTimestampMap(Boolean.class, str, timeZone);
        }
        if (typeClass.equals(TimestampCharMap.class)) {
            return TimestampsParser.parseTimestampMap(Character.class, str, timeZone);
        }
        if (typeClass.equals(boolean[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Boolean[].class, str);
        }
        if (typeClass.equals(char[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Character[].class, str);
        }
        if (typeClass.equals(byte[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Byte[].class, str);
        }
        if (typeClass.equals(short[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Short[].class, str);
        }
        if (typeClass.equals(int[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Integer[].class, str);
        }
        if (typeClass.equals(long[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Long[].class, str);
        }
        if (typeClass.equals(float[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Float[].class, str);
        }
        if (typeClass.equals(double[].class)) {
            return ArraysParser.parseArrayAsPrimitiveArray(Double[].class, str);
        }
        if (typeClass.equals(Boolean[].class) || typeClass.equals(String[].class) || typeClass.equals(Character[].class) || typeClass.equals(Byte[].class) || typeClass.equals(Short[].class) || typeClass.equals(Integer[].class) || typeClass.equals(Long[].class) || typeClass.equals(Float[].class) || typeClass.equals(Double[].class) || typeClass.equals(BigInteger[].class) || typeClass.equals(BigDecimal[].class)) {
            return ArraysParser.parseArray(typeClass, str);
        }
        throw new IllegalArgumentException("Unsupported type " + typeClass.getClass().getCanonicalName());
    }

    public static Object parse(String str, Class typeClass) {
        return AttributeUtils.parse(str, typeClass, null);
    }

    public static Class getPrimitiveType(Class type) {
        if (!type.isPrimitive()) {
            if (type.equals(Boolean.class)) {
                return Boolean.TYPE;
            }
            if (type.equals(Integer.class)) {
                return Integer.TYPE;
            }
            if (type.equals(Short.class)) {
                return Short.TYPE;
            }
            if (type.equals(Long.class)) {
                return Long.TYPE;
            }
            if (type.equals(Byte.class)) {
                return Byte.TYPE;
            }
            if (type.equals(Float.class)) {
                return Float.TYPE;
            }
            if (type.equals(Double.class)) {
                return Double.TYPE;
            }
            if (type.equals(Character.class)) {
                return Character.TYPE;
            }
        }
        throw new IllegalArgumentException("The type should be a wrapped primitive");
    }

    public static Object getPrimitiveArray(Object[] array) {
        if (!AttributeUtils.isSupported(array.getClass())) {
            throw new IllegalArgumentException("Unsupported type " + array.getClass().getCanonicalName());
        }
        Class<?> arrayClass = array.getClass().getComponentType();
        if (!(arrayClass.isPrimitive() || arrayClass != Double.class && arrayClass != Float.class && arrayClass != Long.class && arrayClass != Integer.class && arrayClass != Short.class && arrayClass != Character.class && arrayClass != Byte.class && arrayClass != Boolean.class)) {
            Class primitiveClass = AttributeUtils.getPrimitiveType(arrayClass);
            int arrayLength = array.length;
            Object primitiveArray = Array.newInstance(primitiveClass, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object obj = array[i];
                Array.set(primitiveArray, i, obj);
            }
            return primitiveArray;
        }
        return array;
    }

    public static Set<Class> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    public static boolean isSupported(Class type) {
        if (type == null) {
            throw new NullPointerException();
        }
        return SUPPORTED_TYPES.contains(type);
    }

    public static Class getStandardizedType(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        Class t = TYPES_STANDARDIZATION.get(type);
        if (t != null) {
            return t;
        }
        return type;
    }

    public static boolean isStandardizedType(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        return TYPES_STANDARDIZATION.get(type) == null;
    }

    public static Class<? extends TimestampMap> getTimestampMapType(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        if ((type = AttributeUtils.getStandardizedType(type)).equals(Boolean.class)) {
            return TimestampBooleanMap.class;
        }
        if (type.equals(Integer.class)) {
            return TimestampIntegerMap.class;
        }
        if (type.equals(Short.class)) {
            return TimestampShortMap.class;
        }
        if (type.equals(Long.class)) {
            return TimestampLongMap.class;
        }
        if (type.equals(Byte.class)) {
            return TimestampByteMap.class;
        }
        if (type.equals(Float.class)) {
            return TimestampFloatMap.class;
        }
        if (type.equals(Double.class)) {
            return TimestampDoubleMap.class;
        }
        if (type.equals(Character.class)) {
            return TimestampCharMap.class;
        }
        if (type.equals(String.class)) {
            return TimestampStringMap.class;
        }
        throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
    }

    public static Class<? extends IntervalMap> getIntervalMapType(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        if ((type = AttributeUtils.getStandardizedType(type)).equals(Boolean.class)) {
            return IntervalBooleanMap.class;
        }
        if (type.equals(Integer.class)) {
            return IntervalIntegerMap.class;
        }
        if (type.equals(Short.class)) {
            return IntervalShortMap.class;
        }
        if (type.equals(Long.class)) {
            return IntervalLongMap.class;
        }
        if (type.equals(Byte.class)) {
            return IntervalByteMap.class;
        }
        if (type.equals(Float.class)) {
            return IntervalFloatMap.class;
        }
        if (type.equals(Double.class)) {
            return IntervalDoubleMap.class;
        }
        if (type.equals(Character.class)) {
            return IntervalCharMap.class;
        }
        if (type.equals(String.class)) {
            return IntervalStringMap.class;
        }
        throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
    }

    public static Class getStaticType(Class<? extends TimeMap> type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        if (type.equals(TimestampBooleanMap.class) || type.equals(IntervalBooleanMap.class)) {
            return Boolean.class;
        }
        if (type.equals(TimestampIntegerMap.class) || type.equals(IntervalIntegerMap.class)) {
            return Integer.class;
        }
        if (type.equals(TimestampShortMap.class) || type.equals(IntervalShortMap.class)) {
            return Short.class;
        }
        if (type.equals(TimestampLongMap.class) || type.equals(IntervalLongMap.class)) {
            return Long.class;
        }
        if (type.equals(TimestampByteMap.class) || type.equals(IntervalByteMap.class)) {
            return Byte.class;
        }
        if (type.equals(TimestampFloatMap.class) || type.equals(IntervalFloatMap.class)) {
            return Float.class;
        }
        if (type.equals(TimestampDoubleMap.class) || type.equals(IntervalDoubleMap.class)) {
            return Double.class;
        }
        if (type.equals(TimestampCharMap.class) || type.equals(IntervalCharMap.class)) {
            return Character.class;
        }
        if (type.equals(TimestampStringMap.class) || type.equals(IntervalStringMap.class)) {
            return String.class;
        }
        throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
    }

    public static Object standardizeValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        if (type.isArray()) {
            return AttributeUtils.getPrimitiveArray((Object[])value);
        }
        return value;
    }

    public static boolean isNumberType(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        return Number.class.isAssignableFrom(type = AttributeUtils.getStandardizedType(type)) || int[].class.isAssignableFrom(type) || float[].class.isAssignableFrom(type) || double[].class.isAssignableFrom(type) || byte[].class.isAssignableFrom(type) || short[].class.isAssignableFrom(type) || long[].class.isAssignableFrom(type) || type.equals(TimestampIntegerMap.class) || type.equals(TimestampFloatMap.class) || type.equals(TimestampDoubleMap.class) || type.equals(TimestampLongMap.class) || type.equals(TimestampShortMap.class) || type.equals(TimestampByteMap.class) || type.equals(IntervalIntegerMap.class) || type.equals(IntervalFloatMap.class) || type.equals(IntervalDoubleMap.class) || type.equals(IntervalLongMap.class) || type.equals(IntervalShortMap.class) || type.equals(IntervalByteMap.class);
    }

    public static boolean isStringType(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        return type.equals(String.class) || type.equals(String[].class) || type.equals(TimestampStringMap.class) || type.equals(IntervalStringMap.class);
    }

    public static boolean isBooleanType(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        return (type = AttributeUtils.getStandardizedType(type)).equals(Boolean.class) || type.equals(boolean[].class) || type.equals(TimestampBooleanMap.class) || type.equals(IntervalBooleanMap.class);
    }

    public static boolean isDynamicType(Class type) {
        return !type.equals(TimestampMap.class) && TimestampMap.class.isAssignableFrom(type) || type.equals(TimestampSet.class) || !type.equals(IntervalMap.class) && IntervalMap.class.isAssignableFrom(type) || type.equals(IntervalSet.class);
    }

    public static boolean isSimpleType(Class type) {
        return type.isPrimitive() && type != Void.TYPE || type == Double.class || type == Float.class || type == Long.class || type == Integer.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class || type == String.class;
    }

    public static String getTypeName(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
        }
        type = AttributeUtils.getStandardizedType(type);
        return type.getSimpleName().toLowerCase();
    }

    public static double parseDateTime(String dateTime, DateTimeZone timeZone) {
        return AttributeUtils.getDateTimeParserByTimeZone(timeZone).parseDateTime(dateTime).getMillis();
    }

    public static double parseDateTime(String dateTime) {
        return AttributeUtils.parseDateTime(dateTime, null);
    }

    public static String printTimestamp(double timestamp) {
        return TIMESTAMP_PRINTER.format(timestamp);
    }

    public static String printDate(double timestamp, DateTimeZone timeZone) {
        if (Double.isInfinite(timestamp) || Double.isNaN(timestamp)) {
            return AttributeUtils.printTimestamp(timestamp);
        }
        return AttributeUtils.getDatePrinterByTimeZone(timeZone).print((long)timestamp);
    }

    public static String printDate(double timestamp) {
        return AttributeUtils.printDate(timestamp, null);
    }

    public static String printDateTime(double timestamp, DateTimeZone timeZone) {
        if (Double.isInfinite(timestamp) || Double.isNaN(timestamp)) {
            return AttributeUtils.printTimestamp(timestamp);
        }
        return AttributeUtils.getDateTimePrinterByTimeZone(timeZone).print((long)timestamp);
    }

    public static String printDateTime(double timestamp) {
        return AttributeUtils.printDateTime(timestamp, null);
    }

    public static String printTimestampInFormat(double timestamp, TimeFormat timeFormat, DateTimeZone timeZone) {
        switch (timeFormat) {
            case DATE: {
                return AttributeUtils.printDate(timestamp, timeZone);
            }
            case DATETIME: {
                return AttributeUtils.printDateTime(timestamp, timeZone);
            }
            case DOUBLE: {
                return AttributeUtils.printTimestamp(timestamp);
            }
        }
        throw new UnsupportedOperationException("Unknown TimeFormat");
    }

    public static String printTimestampInFormat(double timestamp, TimeFormat timeFormat) {
        return AttributeUtils.printTimestampInFormat(timestamp, timeFormat, null);
    }

    public static String printArray(Object arr) {
        return FormattingAndParsingUtils.printArray(arr);
    }

    public static boolean isNodeColumn(Column colum) {
        return colum.getTable().getElementClass().equals(Node.class);
    }

    public static boolean isEdgeColumn(Column colum) {
        return colum.getTable().getElementClass().equals(Edge.class);
    }

    static {
        HashSet<Class<Object>> supportedTypes = new HashSet<Class<Object>>();
        supportedTypes.add(Boolean.class);
        supportedTypes.add(Boolean.TYPE);
        supportedTypes.add(Integer.class);
        supportedTypes.add(Integer.TYPE);
        supportedTypes.add(Short.class);
        supportedTypes.add(Short.TYPE);
        supportedTypes.add(Long.class);
        supportedTypes.add(Long.TYPE);
        supportedTypes.add(BigInteger.class);
        supportedTypes.add(Byte.class);
        supportedTypes.add(Byte.TYPE);
        supportedTypes.add(Float.class);
        supportedTypes.add(Float.TYPE);
        supportedTypes.add(Double.class);
        supportedTypes.add(Double.TYPE);
        supportedTypes.add(BigDecimal.class);
        supportedTypes.add(Character.class);
        supportedTypes.add(Character.TYPE);
        supportedTypes.add(String.class);
        supportedTypes.add(Boolean[].class);
        supportedTypes.add(boolean[].class);
        supportedTypes.add(Integer[].class);
        supportedTypes.add(int[].class);
        supportedTypes.add(Short[].class);
        supportedTypes.add(short[].class);
        supportedTypes.add(Long[].class);
        supportedTypes.add(long[].class);
        supportedTypes.add(BigInteger[].class);
        supportedTypes.add(Byte[].class);
        supportedTypes.add(byte[].class);
        supportedTypes.add(Float[].class);
        supportedTypes.add(float[].class);
        supportedTypes.add(Double[].class);
        supportedTypes.add(double[].class);
        supportedTypes.add(BigDecimal[].class);
        supportedTypes.add(Character[].class);
        supportedTypes.add(char[].class);
        supportedTypes.add(String[].class);
        supportedTypes.add(TimestampSet.class);
        supportedTypes.add(TimestampBooleanMap.class);
        supportedTypes.add(TimestampIntegerMap.class);
        supportedTypes.add(TimestampShortMap.class);
        supportedTypes.add(TimestampLongMap.class);
        supportedTypes.add(TimestampByteMap.class);
        supportedTypes.add(TimestampFloatMap.class);
        supportedTypes.add(TimestampDoubleMap.class);
        supportedTypes.add(TimestampCharMap.class);
        supportedTypes.add(TimestampStringMap.class);
        supportedTypes.add(IntervalSet.class);
        supportedTypes.add(IntervalBooleanMap.class);
        supportedTypes.add(IntervalIntegerMap.class);
        supportedTypes.add(IntervalShortMap.class);
        supportedTypes.add(IntervalLongMap.class);
        supportedTypes.add(IntervalByteMap.class);
        supportedTypes.add(IntervalFloatMap.class);
        supportedTypes.add(IntervalDoubleMap.class);
        supportedTypes.add(IntervalCharMap.class);
        supportedTypes.add(IntervalStringMap.class);
        SUPPORTED_TYPES = Collections.unmodifiableSet(supportedTypes);
        HashMap<Class<Object>, Class> typesStandardization = new HashMap<Class<Object>, Class>();
        typesStandardization.put(Boolean.TYPE, Boolean.class);
        typesStandardization.put(Integer.TYPE, Integer.class);
        typesStandardization.put(Short.TYPE, Short.class);
        typesStandardization.put(Long.TYPE, Long.class);
        typesStandardization.put(Byte.TYPE, Byte.class);
        typesStandardization.put(Float.TYPE, Float.class);
        typesStandardization.put(Double.TYPE, Double.class);
        typesStandardization.put(Character.TYPE, Character.class);
        typesStandardization.put(Boolean[].class, boolean[].class);
        typesStandardization.put(Integer[].class, int[].class);
        typesStandardization.put(Short[].class, short[].class);
        typesStandardization.put(Long[].class, long[].class);
        typesStandardization.put(Byte[].class, byte[].class);
        typesStandardization.put(Float[].class, float[].class);
        typesStandardization.put(Double[].class, double[].class);
        typesStandardization.put(Character[].class, char[].class);
        TYPES_STANDARDIZATION = Collections.unmodifiableMap(typesStandardization);
        DATE_TIME_PARSER = ISODateTimeFormat.dateOptionalTimeParser().withZone(GraphStoreConfiguration.DEFAULT_TIME_ZONE);
        DATE_PRINTER = ISODateTimeFormat.date().withZone(GraphStoreConfiguration.DEFAULT_TIME_ZONE);
        DATE_TIME_PRINTER = ISODateTimeFormat.dateTime().withZone(GraphStoreConfiguration.DEFAULT_TIME_ZONE);
        DATE_PRINTERS_BY_TIMEZONE = new HashMap<DateTimeZone, DateTimeFormatter>();
        DATE_TIME_PRINTERS_BY_TIMEZONE = new HashMap<DateTimeZone, DateTimeFormatter>();
        DATE_TIME_PARSERS_BY_TIMEZONE = new HashMap<DateTimeZone, DateTimeFormatter>();
        DATE_PRINTERS_BY_TIMEZONE.put(DATE_PRINTER.getZone(), DATE_PRINTER);
        DATE_TIME_PRINTERS_BY_TIMEZONE.put(DATE_TIME_PRINTER.getZone(), DATE_TIME_PRINTER);
        DATE_TIME_PARSERS_BY_TIMEZONE.put(DATE_TIME_PARSER.getZone(), DATE_TIME_PARSER);
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
        decimalFormatSymbols.setInfinity("Infinity");
        TIMESTAMP_PRINTER = new DecimalFormat("0.0###", decimalFormatSymbols);
    }
}

