/*
 * Decompiled with CFR 0.152.
 */
package org.geomesa.testcontainers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.utility.DockerImageName;

public class UnoContainer<T extends UnoContainer<T>>
extends GenericContainer<T> {
    private static final Logger logger = LoggerFactory.getLogger(UnoContainer.class);
    static final DockerImageName DEFAULT_IMAGE = DockerImageName.parse((String)"ghcr.io/geomesa/accumulo-uno").withTag("2.1");

    public UnoContainer(DockerImageName imageName) {
        super(imageName);
        String hostname = null;
        try {
            hostname = (String)((CompletableFuture)Runtime.getRuntime().exec("hostname -s").onExit().thenApply(p -> {
                String string;
                block8: {
                    InputStream is = p.getInputStream();
                    try {
                        string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8).trim();
                        if (is == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            logger.error("Error reading hostname:", (Throwable)e);
                            return null;
                        }
                    }
                    is.close();
                }
                return string;
            })).get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            logger.error("Error reading hostname, networking may not work correctly:", (Throwable)e);
        }
        if (hostname != null) {
            String finalHostname = hostname;
            this.withCreateContainerCmdModifier(cmd -> cmd.withHostName(finalHostname));
            this.withNetworkAliases(new String[]{hostname});
        }
    }
}

