/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDOEncoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.Ordinates;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;

public class SdoLineStringEncoder
extends AbstractSDOEncoder {
    @Override
    public <P extends Position> boolean accepts(Geometry<P> geom) {
        return GeometryType.LINESTRING.equals((Object)geom.getGeometryType());
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SDOGeometry encode(G geom) {
        int dim = geom.getCoordinateDimension();
        int lrsPos = this.getLRSDim(geom);
        boolean isLrs = lrsPos > 0;
        Double[] ordinates = this.convertPositionSequence(geom.getPositions());
        ElemInfo info = new ElemInfo(1);
        info.setElement(0, 1, ElementType.LINE_STRAITH_SEGMENTS, 0);
        return new SDOGeometry(new SDOGType(dim, lrsPos, TypeGeometry.LINE), geom.getSRID(), null, info, new Ordinates(ordinates));
    }
}

