/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.shaded.org.eclipse.jetty.util.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gaul.shaded.org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.gaul.shaded.org.eclipse.jetty.util.component.Dumpable;

public class SslSelectionDump
extends ContainerLifeCycle
implements Dumpable {
    private final String type;
    private CaptionedList enabled = new CaptionedList("Enabled");
    private CaptionedList disabled = new CaptionedList("Disabled");

    public SslSelectionDump(String type, String[] supportedByJVM, String[] enabledByJVM, String[] excludedByConfig, String[] includedByConfig) {
        this.type = type;
        this.addBean(this.enabled);
        this.addBean(this.disabled);
        List<String> jvmEnabled = Arrays.asList(enabledByJVM);
        List<Pattern> excludedPatterns = SslSelectionDump.toPatternList(excludedByConfig);
        List<Pattern> includedPatterns = SslSelectionDump.toPatternList(includedByConfig);
        for (String entry : this.toSortedList(supportedByJVM)) {
            boolean isPresent = true;
            StringBuilder s = new StringBuilder();
            s.append(entry);
            if (!jvmEnabled.contains(entry)) {
                if (isPresent) {
                    s.append(" -");
                    isPresent = false;
                }
                s.append(" JreDisabled:java.security");
            }
            for (Pattern pattern : excludedPatterns) {
                Matcher m = pattern.matcher(entry);
                if (!m.matches()) continue;
                if (isPresent) {
                    s.append(" -");
                    isPresent = false;
                } else {
                    s.append(",");
                }
                s.append(" ConfigExcluded:'").append(pattern.pattern()).append('\'');
            }
            if (!includedPatterns.isEmpty()) {
                boolean isIncluded = false;
                for (Pattern pattern : includedPatterns) {
                    Matcher m = pattern.matcher(entry);
                    if (!m.matches()) continue;
                    isIncluded = true;
                    break;
                }
                if (!isIncluded) {
                    if (isPresent) {
                        s.append(" -");
                        isPresent = false;
                    } else {
                        s.append(",");
                    }
                    s.append(" ConfigIncluded:NotSpecified");
                }
            }
            if (isPresent) {
                this.enabled.add(s.toString());
                continue;
            }
            this.disabled.add(s.toString());
        }
    }

    private List<String> toSortedList(String[] strings) {
        ArrayList<String> sorted = new ArrayList<String>();
        for (String entry : strings) {
            sorted.add(entry);
        }
        Collections.sort(sorted, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return sorted;
    }

    private static List<Pattern> toPatternList(String[] configs) {
        ArrayList<Pattern> ret = new ArrayList<Pattern>();
        for (String entry : configs) {
            ret.add(Pattern.compile(entry));
        }
        return ret;
    }

    @Override
    public String dump() {
        return ContainerLifeCycle.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpBeans(out, indent, new Collection[0]);
    }

    @Override
    protected void dumpThis(Appendable out) throws IOException {
        out.append(this.type).append(" Selections").append(System.lineSeparator());
    }

    private static class CaptionedList
    extends ArrayList<String>
    implements Dumpable {
        private final String caption;

        public CaptionedList(String caption) {
            this.caption = caption;
        }

        @Override
        public String dump() {
            return ContainerLifeCycle.dump(this);
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            out.append(this.caption);
            out.append(" (size=").append(Integer.toString(this.size())).append(")");
            out.append(System.lineSeparator());
            ContainerLifeCycle.dump(out, indent, this);
        }
    }
}

