/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.shaded.org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gaul.shaded.org.eclipse.jetty.http.HttpFields;
import org.gaul.shaded.org.eclipse.jetty.http.HttpHeader;
import org.gaul.shaded.org.eclipse.jetty.http.HttpMethod;
import org.gaul.shaded.org.eclipse.jetty.http.HttpStatus;
import org.gaul.shaded.org.eclipse.jetty.http.MimeTypes;
import org.gaul.shaded.org.eclipse.jetty.server.Dispatcher;
import org.gaul.shaded.org.eclipse.jetty.server.Request;
import org.gaul.shaded.org.eclipse.jetty.server.Response;
import org.gaul.shaded.org.eclipse.jetty.server.Server;
import org.gaul.shaded.org.eclipse.jetty.server.handler.AbstractHandler;
import org.gaul.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import org.gaul.shaded.org.eclipse.jetty.util.BufferUtil;
import org.gaul.shaded.org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.gaul.shaded.org.eclipse.jetty.util.StringUtil;
import org.gaul.shaded.org.eclipse.jetty.util.log.Log;
import org.gaul.shaded.org.eclipse.jetty.util.log.Logger;

public class ErrorHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(ErrorHandler.class);
    public static final String ERROR_PAGE = "org.gaul.shaded.org.eclipse.jetty.server.error_page";
    boolean _showStacks = true;
    boolean _showMessageInTitle = true;
    String _cacheControl = "must-revalidate,no-cache,no-store";

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String old_error_page;
        String error_page;
        String method = request.getMethod();
        if (!(HttpMethod.GET.is(method) || HttpMethod.POST.is(method) || HttpMethod.HEAD.is(method))) {
            baseRequest.setHandled(true);
            return;
        }
        if (this instanceof ErrorPageMapper && (error_page = ((ErrorPageMapper)((Object)this)).getErrorPage(request)) != null && request.getServletContext() != null && ((old_error_page = (String)request.getAttribute(ERROR_PAGE)) == null || !old_error_page.equals(error_page))) {
            request.setAttribute(ERROR_PAGE, (Object)error_page);
            Dispatcher dispatcher = (Dispatcher)request.getServletContext().getRequestDispatcher(error_page);
            try {
                if (dispatcher != null) {
                    dispatcher.error((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                LOG.warn("No error page " + error_page, new Object[0]);
            }
            catch (ServletException e) {
                LOG.warn("EXCEPTION ", e);
                return;
            }
        }
        baseRequest.setHandled(true);
        response.setContentType(MimeTypes.Type.TEXT_HTML_8859_1.asString());
        if (this._cacheControl != null) {
            response.setHeader(HttpHeader.CACHE_CONTROL.asString(), this._cacheControl);
        }
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(4096);
        String reason = response instanceof Response ? ((Response)response).getReason() : null;
        this.handleErrorPage(request, writer, response.getStatus(), reason);
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo((OutputStream)response.getOutputStream());
        writer.destroy();
    }

    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        this.writeErrorPage(request, writer, code, message, this._showStacks);
    }

    protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        if (message == null) {
            message = HttpStatus.getMessage(code);
        }
        writer.write("<html>\n<head>\n");
        this.writeErrorPageHead(request, writer, code, message);
        writer.write("</head>\n<body>");
        this.writeErrorPageBody(request, writer, code, message, showStacks);
        writer.write("\n</body>\n</html>\n");
    }

    protected void writeErrorPageHead(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n");
        writer.write("<title>Error ");
        writer.write(Integer.toString(code));
        if (this._showMessageInTitle) {
            writer.write(32);
            this.write(writer, message);
        }
        writer.write("</title>\n");
    }

    protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        String uri = request.getRequestURI();
        this.writeErrorPageMessage(request, writer, code, message, uri);
        if (showStacks) {
            this.writeErrorPageStacks(request, writer);
        }
        writer.write("<hr><i><small>Powered by Jetty://</small></i><hr/>\n");
    }

    protected void writeErrorPageMessage(HttpServletRequest request, Writer writer, int code, String message, String uri) throws IOException {
        writer.write("<h2>HTTP ERROR ");
        writer.write(Integer.toString(code));
        writer.write("</h2>\n<p>Problem accessing ");
        this.write(writer, uri);
        writer.write(". Reason:\n<pre>    ");
        this.write(writer, message);
        writer.write("</pre></p>");
    }

    protected void writeErrorPageStacks(HttpServletRequest request, Writer writer) throws IOException {
        for (Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception"); th != null; th = th.getCause()) {
            writer.write("<h3>Caused by:</h3><pre>");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            this.write(writer, sw.getBuffer().toString());
            writer.write("</pre>\n");
        }
    }

    public ByteBuffer badMessageError(int status, String reason, HttpFields fields) {
        if (reason == null) {
            reason = HttpStatus.getMessage(status);
        }
        fields.put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.TEXT_HTML_8859_1.asString());
        return BufferUtil.toBuffer("<h1>Bad Message " + status + "</h1><pre>reason: " + reason + "</pre>");
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = cacheControl;
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    public void setShowStacks(boolean showStacks) {
        this._showStacks = showStacks;
    }

    public void setShowMessageInTitle(boolean showMessageInTitle) {
        this._showMessageInTitle = showMessageInTitle;
    }

    public boolean getShowMessageInTitle() {
        return this._showMessageInTitle;
    }

    protected void write(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        writer.write(StringUtil.sanitizeXmlString(string));
    }

    public static ErrorHandler getErrorHandler(Server server, ContextHandler context) {
        ErrorHandler error_handler = null;
        if (context != null) {
            error_handler = context.getErrorHandler();
        }
        if (error_handler == null && server != null) {
            error_handler = server.getBean(ErrorHandler.class);
        }
        return error_handler;
    }

    public static interface ErrorPageMapper {
        public String getErrorPage(HttpServletRequest var1);
    }
}

