/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.shaded.org.eclipse.jetty.server;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.gaul.shaded.org.eclipse.jetty.http.HttpVersion;
import org.gaul.shaded.org.eclipse.jetty.io.Connection;
import org.gaul.shaded.org.eclipse.jetty.io.EndPoint;
import org.gaul.shaded.org.eclipse.jetty.io.ssl.SslConnection;
import org.gaul.shaded.org.eclipse.jetty.server.AbstractConnectionFactory;
import org.gaul.shaded.org.eclipse.jetty.server.ConnectionFactory;
import org.gaul.shaded.org.eclipse.jetty.server.Connector;
import org.gaul.shaded.org.eclipse.jetty.util.annotation.Name;
import org.gaul.shaded.org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslConnectionFactory
extends AbstractConnectionFactory {
    private final SslContextFactory _sslContextFactory;
    private final String _nextProtocol;
    private boolean _directBuffersForEncryption = false;
    private boolean _directBuffersForDecryption = false;

    public SslConnectionFactory() {
        this(HttpVersion.HTTP_1_1.asString());
    }

    public SslConnectionFactory(@Name(value="next") String nextProtocol) {
        this(null, nextProtocol);
    }

    public SslConnectionFactory(@Name(value="sslContextFactory") SslContextFactory factory, @Name(value="next") String nextProtocol) {
        super("SSL-" + nextProtocol);
        this._sslContextFactory = factory == null ? new SslContextFactory() : factory;
        this._nextProtocol = nextProtocol;
        this.addBean(this._sslContextFactory);
    }

    public SslContextFactory getSslContextFactory() {
        return this._sslContextFactory;
    }

    public void setDirectBuffersForEncryption(boolean useDirectBuffers) {
        this._directBuffersForEncryption = useDirectBuffers;
    }

    public void setDirectBuffersForDecryption(boolean useDirectBuffers) {
        this._directBuffersForDecryption = useDirectBuffers;
    }

    public boolean isDirectBuffersForDecryption() {
        return this._directBuffersForDecryption;
    }

    public boolean isDirectBuffersForEncryption() {
        return this._directBuffersForEncryption;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        SSLEngine engine = this._sslContextFactory.newSSLEngine();
        engine.setUseClientMode(false);
        SSLSession session = engine.getSession();
        if (session.getPacketBufferSize() > this.getInputBufferSize()) {
            this.setInputBufferSize(session.getPacketBufferSize());
        }
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        SSLEngine engine = this._sslContextFactory.newSSLEngine(endPoint.getRemoteAddress());
        engine.setUseClientMode(false);
        SslConnection sslConnection = this.newSslConnection(connector, endPoint, engine);
        sslConnection.setRenegotiationAllowed(this._sslContextFactory.isRenegotiationAllowed());
        this.configure(sslConnection, connector, endPoint);
        ConnectionFactory next = connector.getConnectionFactory(this._nextProtocol);
        SslConnection.DecryptedEndPoint decryptedEndPoint = sslConnection.getDecryptedEndPoint();
        Connection connection = next.newConnection(connector, decryptedEndPoint);
        decryptedEndPoint.setConnection(connection);
        return sslConnection;
    }

    protected SslConnection newSslConnection(Connector connector, EndPoint endPoint, SSLEngine engine) {
        return new SslConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, engine, this.isDirectBuffersForEncryption(), this.isDirectBuffersForDecryption());
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol());
    }
}

