/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gaul.s3proxy.AuthenticationType;
import org.gaul.s3proxy.CrossOriginResourceSharing;
import org.gaul.s3proxy.S3ErrorCode;
import org.gaul.s3proxy.S3Exception;
import org.gaul.s3proxy.S3ProxyHandler;
import org.gaul.shaded.org.eclipse.jetty.server.Request;
import org.gaul.shaded.org.eclipse.jetty.server.handler.AbstractHandler;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class S3ProxyHandlerJetty
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(S3ProxyHandlerJetty.class);
    private final S3ProxyHandler handler;

    S3ProxyHandlerJetty(BlobStore blobStore, AuthenticationType authenticationType, String identity, String credential, @Nullable String virtualHost, long v4MaxNonChunkedRequestSize, boolean ignoreUnknownHeaders, CrossOriginResourceSharing corsRules, String servicePath, int maximumTimeSkew) {
        this.handler = new S3ProxyHandler(blobStore, authenticationType, identity, credential, virtualHost, v4MaxNonChunkedRequestSize, ignoreUnknownHeaders, corsRules, servicePath, maximumTimeSkew);
    }

    private void sendS3Exception(HttpServletRequest request, HttpServletResponse response, S3Exception se) throws IOException {
        this.handler.sendSimpleErrorResponse(request, response, se.getError(), se.getMessage(), se.getElements());
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try (ServletInputStream is = request.getInputStream();){
            baseRequest.setAttribute("queryEncoding", baseRequest.getQueryEncoding());
            this.handler.doHandle(baseRequest, request, response, (InputStream)is);
            baseRequest.setHandled(true);
        }
        catch (ContainerNotFoundException cnfe) {
            S3ErrorCode code = S3ErrorCode.NO_SUCH_BUCKET;
            this.handler.sendSimpleErrorResponse(request, response, code, code.getMessage(), (Map<String, String>)ImmutableMap.of());
            baseRequest.setHandled(true);
            return;
        }
        catch (HttpResponseException hre) {
            HttpResponse hr = hre.getResponse();
            if (hr == null) {
                logger.debug("HttpResponseException without HttpResponse:", (Throwable)hre);
                response.sendError(500, hre.getMessage());
                return;
            }
            int status = hr.getStatusCode();
            switch (status) {
                case 412: {
                    this.sendS3Exception(request, response, new S3Exception(S3ErrorCode.PRECONDITION_FAILED));
                    break;
                }
                case 416: {
                    this.sendS3Exception(request, response, new S3Exception(S3ErrorCode.INVALID_RANGE));
                    break;
                }
                case 400: 
                case 422: {
                    this.sendS3Exception(request, response, new S3Exception(S3ErrorCode.BAD_DIGEST));
                    break;
                }
                default: {
                    response.sendError(status, hre.getContent());
                }
            }
            baseRequest.setHandled(true);
            return;
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.getMessage());
            baseRequest.setHandled(true);
            return;
        }
        catch (KeyNotFoundException knfe) {
            S3ErrorCode code = S3ErrorCode.NO_SUCH_KEY;
            this.handler.sendSimpleErrorResponse(request, response, code, code.getMessage(), (Map<String, String>)ImmutableMap.of());
            baseRequest.setHandled(true);
            return;
        }
        catch (S3Exception se) {
            this.sendS3Exception(request, response, se);
            baseRequest.setHandled(true);
            return;
        }
        catch (UnsupportedOperationException uoe) {
            response.sendError(501, uoe.getMessage());
            baseRequest.setHandled(true);
            return;
        }
        catch (Throwable throwable) {
            if (Throwables2.getFirstThrowableOfType((Throwable)throwable, AuthorizationException.class) != null) {
                S3ErrorCode code = S3ErrorCode.ACCESS_DENIED;
                this.handler.sendSimpleErrorResponse(request, response, code, code.getMessage(), (Map<String, String>)ImmutableMap.of());
                baseRequest.setHandled(true);
                return;
            }
            if (Throwables2.getFirstThrowableOfType((Throwable)throwable, TimeoutException.class) != null) {
                S3ErrorCode code = S3ErrorCode.REQUEST_TIMEOUT;
                this.handler.sendSimpleErrorResponse(request, response, code, code.getMessage(), (Map<String, String>)ImmutableMap.of());
                baseRequest.setHandled(true);
                return;
            }
            logger.debug("Unknown exception:", throwable);
            throw throwable;
        }
    }

    public S3ProxyHandler getHandler() {
        return this.handler;
    }
}

