/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.s3proxy;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.gaul.s3proxy.S3ErrorCode;

public final class S3Exception
extends Exception {
    private final S3ErrorCode error;
    private final Map<String, String> elements;

    S3Exception(S3ErrorCode error) {
        this(error, error.getMessage(), null, (Map<String, String>)ImmutableMap.of());
    }

    S3Exception(S3ErrorCode error, String message) {
        this(error, message, null, (Map<String, String>)ImmutableMap.of());
    }

    S3Exception(S3ErrorCode error, Throwable cause) {
        this(error, error.getMessage(), cause, (Map<String, String>)ImmutableMap.of());
    }

    S3Exception(S3ErrorCode error, String message, Throwable cause) {
        this(error, message, cause, (Map<String, String>)ImmutableMap.of());
    }

    S3Exception(S3ErrorCode error, String message, Throwable cause, Map<String, String> elements) {
        super(Objects.requireNonNull(message), cause);
        this.error = Objects.requireNonNull(error);
        this.elements = ImmutableMap.copyOf(elements);
    }

    S3ErrorCode getError() {
        return this.error;
    }

    Map<String, String> getElements() {
        return this.elements;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder().append(super.getMessage());
        if (!this.elements.isEmpty()) {
            builder.append(" ").append(this.elements);
        }
        return builder.toString();
    }
}

