/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class Utils {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    static <T> Set<T> createImmutableSet(Collection<T> collection) {
        return Collections.unmodifiableSet(new HashSet<T>(Utils.checkNotNull(collection)));
    }

    static <T, U> Map<T, U> createImmutableMap(Map<T, U> map) {
        return Collections.unmodifiableMap(new HashMap<T, U>(Utils.checkNotNull(map)));
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static Collection<String> readAllLines(InputStream is) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, UTF_8));
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    private Utils() {
        throw new AssertionError((Object)"Intentionally not implemented");
    }
}

