/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juli.logging.impl.SLF4JDelegatingLog;
import org.slf4j.ILoggerFactory;
import org.slf4j.helpers.Util;

public class SeparateSLF4JImplBridge {
    private static final String SLF4J_IMPL_STATIC_LOGGER_BINDER_CLASS = "org.slf4j.impl.StaticLoggerBinder";
    private static final String REQUESTED_API_VERSION_FIELD = "REQUESTED_API_VERSION";
    private static final String GET_SINGLETON_METHOD = "getSingleton";
    private static final String GET_LOGGER_FACTORY_METHOD = "getLoggerFactory";
    private static final String GET_LOGGER_FACTORY_CLASS_STR_METHOD = "getLoggerFactoryClassStr";
    private static Field requestedApiVersionField;
    private static Method getSingletonMethod;
    private static Method getLoggerFactoryMethod;
    private static Method getLoggerFactoryClassStrMethod;

    static void doBootstrap(ClassLoader slf4jImplLoader) {
        Method getLoggerFactoryClassStr;
        Method getLoggerFactory;
        Method getSingleton;
        Field requestedApiVersion;
        if (SLF4JDelegatingLog.diagnostics <= 10) {
            Util.report((String)("SeparateSLF4JImplBridge.doBootstrap('" + slf4jImplLoader + "')"));
        }
        try {
            Class<?> staticLoggerBinder = slf4jImplLoader.loadClass(SLF4J_IMPL_STATIC_LOGGER_BINDER_CLASS);
            requestedApiVersion = staticLoggerBinder.getDeclaredField(REQUESTED_API_VERSION_FIELD);
            getSingleton = staticLoggerBinder.getMethod(GET_SINGLETON_METHOD, new Class[0]);
            getLoggerFactory = staticLoggerBinder.getMethod(GET_LOGGER_FACTORY_METHOD, new Class[0]);
            getLoggerFactoryClassStr = staticLoggerBinder.getMethod(GET_LOGGER_FACTORY_CLASS_STR_METHOD, new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException exc) {
            throw new RuntimeException("unexpected error while bootstrapping the actual StaticLoggerBinder", exc);
        }
        requestedApiVersionField = requestedApiVersion;
        getSingletonMethod = getSingleton;
        getLoggerFactoryMethod = getLoggerFactory;
        getLoggerFactoryClassStrMethod = getLoggerFactoryClassStr;
    }

    static String requestedApiVersion() {
        try {
            return (String)requestedApiVersionField.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException exc) {
            throw new RuntimeException(exc);
        }
    }

    static Object getStaticLoggerBinder() {
        try {
            return getSingletonMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exc) {
            throw new RuntimeException(exc);
        }
    }

    static ILoggerFactory getLoggerFactory() {
        try {
            return (ILoggerFactory)getLoggerFactoryMethod.invoke(SeparateSLF4JImplBridge.getStaticLoggerBinder(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exc) {
            throw new RuntimeException(exc);
        }
    }

    static ILoggerFactory getLoggerFactoryClassStr() {
        try {
            return (ILoggerFactory)getLoggerFactoryClassStrMethod.invoke(SeparateSLF4JImplBridge.getStaticLoggerBinder(), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exc) {
            throw new RuntimeException(exc);
        }
    }
}

