/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.juli.logging.impl.PreBootstrapLoggingEvent;
import org.apache.juli.logging.impl.SLF4JDelegatingLog;
import org.apache.juli.logging.impl.SeparateLogbackSupport;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.Util;
import org.slf4j.spi.LocationAwareLogger;

public class PreBootstrapLogger
extends MarkerIgnoringBase
implements LocationAwareLogger,
Logger {
    private static final long serialVersionUID = -3141897866237016968L;
    private static final String UNIMPLEMENTED_ERR = "This method is not implemented and should not be used. Only the log() method should be used.";
    private static Collection<PreBootstrapLogger> registry = new LinkedList<PreBootstrapLogger>();
    private SLF4JDelegatingLog facade;

    static void swapLoggers() {
        if (SLF4JDelegatingLog.diagnostics <= 10) {
            Util.report((String)"PreBootstrapLogger.swapLoggers()");
        }
        Iterator<PreBootstrapLogger> itr = registry.iterator();
        while (itr.hasNext()) {
            PreBootstrapLogger logger = itr.next();
            logger.facade.setLogger(SeparateLogbackSupport.obtainLogger(logger.name));
            itr.remove();
        }
    }

    public PreBootstrapLogger(SLF4JDelegatingLog facade, String name) {
        this.name = name;
        this.facade = facade;
        registry.add(this);
    }

    public void log(Marker marker, String fqcn, int level, String msg, Object[] args, Throwable t) {
        PreBootstrapLoggingEvent.add(this.name, fqcn, level, msg, t);
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        this.illegal();
    }

    public void trace(String format, Object arg) {
        this.illegal();
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.illegal();
    }

    public void trace(String format, Object ... args) {
        this.illegal();
    }

    public void trace(String msg, Throwable t) {
        this.illegal();
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        this.illegal();
    }

    public void debug(String format, Object arg) {
        this.illegal();
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.illegal();
    }

    public void debug(String format, Object ... arguments) {
        this.illegal();
    }

    public void debug(String msg, Throwable t) {
        this.illegal();
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        this.illegal();
    }

    public void info(String format, Object arg) {
        this.illegal();
    }

    public void info(String format, Object arg1, Object arg2) {
        this.illegal();
    }

    public void info(String format, Object ... arguments) {
        this.illegal();
    }

    public void info(String msg, Throwable t) {
        this.illegal();
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.illegal();
    }

    public void warn(String format, Object arg) {
        this.illegal();
    }

    public void warn(String format, Object ... arguments) {
        this.illegal();
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.illegal();
    }

    public void warn(String msg, Throwable t) {
        this.illegal();
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.illegal();
    }

    public void error(String format, Object arg) {
        this.illegal();
    }

    public void error(String format, Object arg1, Object arg2) {
        this.illegal();
    }

    public void error(String format, Object ... arguments) {
        this.illegal();
    }

    public void error(String msg, Throwable t) {
        this.illegal();
    }

    private void illegal() {
        throw new UnsupportedOperationException(UNIMPLEMENTED_ERR);
    }
}

