/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mvnplugins.graph;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DependencyVisualizer {
    private static final String DOT_EXTENSION = ".dot";
    private static final String TGF_EXTENSION = ".tgf";
    private final LinkedHashMap<String, Node> nodes = new LinkedHashMap();
    private final LinkedHashSet<Edge> edges = new LinkedHashSet();
    final HashSet<String> hideScopes = new HashSet();
    boolean hideOptional;
    boolean hidePoms;
    boolean hideOmitted;
    boolean hideExternal;
    boolean hideVersion;
    boolean hideGroupId;
    boolean hideType;
    boolean keepDot;
    String label;
    boolean hideTransitive;
    Log log;
    boolean cascade;
    String direction = "TB";
    Set<String> excludeGroupIds = new HashSet<String>();
    Set<String> includeGroupIds = new HashSet<String>();
    Set<String> excludeArtifactIds = new HashSet<String>();
    Set<String> includeArtifactIds = new HashSet<String>();

    public void add(DependencyNode dn) {
        this.add(dn, true);
    }

    private Node add(DependencyNode dn, boolean root) {
        Node parent = this.getNode(dn);
        if (root) {
            parent.roots++;
        }
        if (dn.hasChildren()) {
            for (DependencyNode c : dn.getChildren()) {
                Node child = this.add(c, false);
                Edge edge = new Edge(parent, child, c);
                this.add(edge);
            }
        }
        return parent;
    }

    private Node getNode(DependencyNode dn) {
        Node node;
        Artifact artifact = dn.getArtifact();
        String id = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        if (artifact.getClassifier() != null) {
            id = id + ":" + artifact.getClassifier();
        }
        if ((node = this.nodes.get(id)) == null) {
            node = new Node(id, dn.getArtifact());
            this.nodes.put(id, node);
        }
        return node;
    }

    private void add(Edge edge) {
        if (this.edges.add(edge)) {
            edge.child.parents.add(edge);
            edge.parent.children.add(edge);
        }
    }

    private void remove(Node node) {
        this.nodes.remove(node.getId());
        for (Edge edge : new ArrayList(node.parents)) {
            this.remove(edge);
        }
        for (Edge edge : new ArrayList(node.children)) {
            this.remove(edge);
        }
    }

    private void remove(Edge edge) {
        edge.parent.children.remove(edge);
        edge.child.parents.remove(edge);
        this.edges.remove(edge);
    }

    public void export(File target) throws MojoExecutionException {
        for (Node node : new ArrayList<Node>(this.nodes.values())) {
            if (!node.isHidden()) continue;
            this.log.debug((CharSequence)("Dropping hidden node: " + node));
            this.remove(node);
        }
        for (Edge edge : new ArrayList<Edge>(this.edges)) {
            if (!edge.isHidden()) continue;
            this.log.debug((CharSequence)("Dropping hidden edge: " + edge));
            this.remove(edge);
        }
        if (this.cascade) {
            LinkedList<Node> ll = new LinkedList<Node>(this.nodes.values());
            while (!ll.isEmpty()) {
                Node node;
                node = ll.removeFirst();
                if (node.isOptional()) {
                    for (Edge edge : new ArrayList(node.children)) {
                        if (edge.optional) continue;
                        this.remove(edge);
                        this.add(edge.optional(true));
                        if (!edge.child.isOptional()) continue;
                        ll.addLast(edge.child);
                    }
                }
                if (!node.isScope("test")) continue;
                for (Edge edge : new ArrayList(node.children)) {
                    if (edge.isScope("test")) continue;
                    this.remove(edge);
                    this.add(edge.scope("test"));
                    if (!edge.child.isScope("test")) continue;
                    ll.addLast(edge.child);
                }
            }
        }
        for (Node node : new ArrayList<Node>(this.nodes.values())) {
            if (node.parents.size() != 0 || node.roots != 0) continue;
            this.log.debug((CharSequence)("Dropping orphaned node: " + node));
            this.remove(node);
        }
        boolean convertDotFile = true;
        File source = new File(target.getParentFile(), target.getName() + DOT_EXTENSION);
        if (target.getName().endsWith(DOT_EXTENSION) || target.getName().endsWith(TGF_EXTENSION)) {
            convertDotFile = false;
            source = target;
        }
        PrintStream os = null;
        try {
            this.log.debug((CharSequence)("Exporting to: " + source));
            os = new PrintStream(source);
            if (target.getName().endsWith(TGF_EXTENSION)) {
                new TgfExporter(os).export();
            } else {
                new DotExporter(os).export();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create the dot/tgf file", e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        if (!convertDotFile) {
            return;
        }
        try {
            Commandline commandline = new Commandline();
            try {
                commandline.addSystemEnvironment();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            commandline.setExecutable("dot");
            commandline.addArguments(new String[]{"-T" + FileUtils.getExtension((String)target.getName()), "-o" + target.getAbsolutePath(), source.getAbsolutePath()});
            this.log.debug((CharSequence)"Executing dot command...");
            int rc = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)new DefaultConsumer());
            if (rc != 0) {
                throw new MojoExecutionException("Execution of the 'dot' command failed.  Perhaps it's not installed.  See: http://www.graphviz.org/");
            }
            this.log.debug((CharSequence)"Graph generated. ");
            if (!this.keepDot && !source.delete()) {
                this.log.warn((CharSequence)"failed to delete generated dot file");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Execution of the 'dot' command failed.", (Exception)((Object)e));
        }
    }

    private class DotExporter {
        private final PrintStream out;
        int indent = 0;

        public DotExporter(PrintStream os) {
            this.out = os;
        }

        public void export() {
            String graphFont = "Serif";
            String nodeFont = "SanSerif";
            String osName = System.getProperty("os.name", "NO OS NAME!!");
            if (osName.contains("Windows")) {
                graphFont = "arial";
                nodeFont = "arial";
            }
            this.p("digraph dependencies {").i(1);
            this.p("graph [").i(1);
            if (DependencyVisualizer.this.label != null) {
                this.p("label=" + this.q(DependencyVisualizer.this.label));
            }
            this.p("labeljust=l");
            this.p("labelloc=t");
            this.p("fontsize=18");
            this.p("fontname=" + this.q(graphFont));
            this.p("ranksep=1");
            this.p("rankdir=" + this.q(DependencyVisualizer.this.direction));
            this.p("nodesep=.05");
            this.i(-1).p("];");
            this.p("node [").i(1);
            this.p("fontsize=8");
            this.p("fontname=" + this.q(nodeFont));
            this.p("shape=\"rectangle\"");
            this.i(-1).p("];");
            this.p("edge [").i(1);
            this.p("fontsize=8");
            this.p("fontname=" + this.q(nodeFont));
            this.i(-1).p("];");
            for (Node node : DependencyVisualizer.this.nodes.values()) {
                this.p(this.q(node.getId()) + " [").i(1);
                this.p("fontsize=" + node.getFontSize());
                this.p("label=" + this.q(node.getLabel()));
                this.p("color=" + this.q(node.getColor()));
                this.p("fontcolor=" + this.q(node.getFontColor()));
                this.p("fillcolor=" + this.q(node.getFillColor()));
                this.p("style=" + this.q(node.getLineStyle()));
                this.i(-1).p("];");
            }
            for (Edge edge : DependencyVisualizer.this.edges) {
                this.p(this.q(edge.parent.getId()) + " -> " + this.q(edge.child.getId()) + " [").i(1);
                this.p("label=" + this.q(edge.getLabel()));
                this.p("style=" + this.q(edge.getLineStyle()));
                this.p("color=" + this.q(edge.getColor()));
                this.p("fontcolor=" + this.q(edge.getColor()));
                this.p("weight=" + edge.getWeight());
                this.i(-1).p("];");
            }
            this.i(-1).p("}");
        }

        private String q(String value) {
            return "\"" + value + "\"";
        }

        private DotExporter i(int indent) {
            this.indent += indent;
            return this;
        }

        private DotExporter p(String x) {
            for (int i = 0; i < this.indent; ++i) {
                this.out.print("  ");
            }
            this.out.println(x);
            return this;
        }
    }

    private final class TgfExporter {
        private final PrintStream out;

        public TgfExporter(PrintStream os) {
            this.out = os;
        }

        public void export() {
            for (Node node : DependencyVisualizer.this.nodes.values()) {
                String label = node.getLabel().replace("\\n", " ");
                this.out.printf("%s %s\n", node.getId(), label);
            }
            this.out.printf("#\n", new Object[0]);
            for (Edge edge : DependencyVisualizer.this.edges) {
                this.out.printf("%s %s\n", edge.parent.getId(), edge.child.getId());
            }
        }
    }

    private class Edge {
        private final Node parent;
        private final Node child;
        private String scope;
        private boolean optional;
        private final DependencyNode dependencyNode;
        private String groupId;
        private String artifactId;

        public Edge(Node parent, Node child, DependencyNode dependencyNode) {
            this.parent = parent;
            this.child = child;
            this.dependencyNode = dependencyNode;
            this.scope = dependencyNode.getArtifact().getScope();
            this.optional = dependencyNode.getArtifact().isOptional();
            this.groupId = dependencyNode.getArtifact().getGroupId();
            this.artifactId = dependencyNode.getArtifact().getArtifactId();
        }

        public Edge(Edge edge) {
            this.parent = edge.parent;
            this.child = edge.child;
            this.dependencyNode = edge.dependencyNode;
            this.scope = edge.scope;
            this.optional = edge.optional;
        }

        public Edge optional(boolean optional) {
            if (this.optional == optional) {
                return this;
            }
            Edge rc = new Edge(this);
            rc.optional = optional;
            return rc;
        }

        public Edge scope(String scope) {
            if (this.scope.equals(scope)) {
                return this;
            }
            Edge rc = new Edge(this);
            rc.scope = scope;
            return rc;
        }

        public boolean isHidden() {
            String prefix;
            if (DependencyVisualizer.this.hideTransitive && this.dependencyNode.getParent().getParent() != null) {
                return true;
            }
            if (DependencyVisualizer.this.hideOptional && this.optional) {
                return true;
            }
            if (DependencyVisualizer.this.hideScopes.contains(this.scope)) {
                return true;
            }
            for (String exclude : DependencyVisualizer.this.excludeGroupIds) {
                if (exclude.endsWith("*")) {
                    String prefix2 = exclude.substring(0, exclude.length() - 1);
                    if (!this.groupId.startsWith(prefix2)) continue;
                    DependencyVisualizer.this.log.debug((CharSequence)("Excluding (wildcard) " + this.groupId + ":" + this.artifactId));
                    return true;
                }
                if (!this.groupId.equals(exclude)) continue;
                DependencyVisualizer.this.log.debug((CharSequence)("Excluding " + this.groupId + ":" + this.artifactId));
                return true;
            }
            boolean included = false;
            for (String include : DependencyVisualizer.this.includeGroupIds) {
                if (include.endsWith("*")) {
                    prefix = include.substring(0, include.length() - 1);
                    if (!this.groupId.startsWith(prefix)) continue;
                    DependencyVisualizer.this.log.debug((CharSequence)("Including (wildcard) " + this.groupId + ":" + this.artifactId));
                    included = true;
                    continue;
                }
                if (!this.groupId.equals(include)) continue;
                DependencyVisualizer.this.log.debug((CharSequence)("Including " + this.groupId + ":" + this.artifactId));
                included = true;
            }
            if (!DependencyVisualizer.this.includeGroupIds.isEmpty() && !included) {
                return true;
            }
            for (String exclude : DependencyVisualizer.this.excludeArtifactIds) {
                if (exclude.endsWith("*")) {
                    prefix = exclude.substring(0, exclude.length() - 1);
                    if (!this.artifactId.startsWith(prefix)) continue;
                    DependencyVisualizer.this.log.debug((CharSequence)("Excluding artifactId (wildcard) " + this.groupId + ":" + this.artifactId));
                    return true;
                }
                if (!this.artifactId.equals(exclude)) continue;
                DependencyVisualizer.this.log.debug((CharSequence)("Excluding artifactId " + this.groupId + ":" + this.artifactId));
                return true;
            }
            included = false;
            for (String include : DependencyVisualizer.this.includeArtifactIds) {
                if (include.endsWith("*")) {
                    prefix = include.substring(0, include.length() - 1);
                    if (!this.artifactId.startsWith(prefix)) continue;
                    DependencyVisualizer.this.log.debug((CharSequence)("Including artifactId (wildcard) " + this.groupId + ":" + this.artifactId));
                    included = true;
                    continue;
                }
                if (!this.artifactId.equals(include)) continue;
                DependencyVisualizer.this.log.debug((CharSequence)("Including artifactId " + this.groupId + ":" + this.artifactId));
                included = true;
            }
            if (!DependencyVisualizer.this.includeArtifactIds.isEmpty() && !included) {
                return true;
            }
            int state = this.dependencyNode.getState();
            return DependencyVisualizer.this.hideOmitted && (state == 2 || state == 3);
        }

        public boolean isScope(String s) {
            return this.scope.equals(s);
        }

        public String getLineStyle() {
            if (this.optional) {
                return "dotted";
            }
            return "solid";
        }

        public String getLabel() {
            StringBuilder sb = new StringBuilder();
            if (!this.isScope("compile")) {
                sb.append(this.scope);
            }
            if (this.optional) {
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append("optional");
            }
            return sb.toString();
        }

        public String getColor() {
            if (this.isScope("test")) {
                return "cornflowerblue";
            }
            return "black";
        }

        double getWeight() {
            double rc = 1 + this.getRecursiveChildCount();
            if (this.isScope("compile")) {
                rc *= 2.0;
            }
            if (!this.optional) {
                rc *= 2.0;
            }
            return rc;
        }

        private int getRecursiveChildCount() {
            return this.child.getRecursiveChildCount();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge edge = (Edge)o;
            if (this.parent != null ? !this.parent.equals(edge.parent) : edge.parent != null) {
                return false;
            }
            if (this.child != null ? !this.child.equals(edge.child) : edge.child != null) {
                return false;
            }
            if (this.scope != null ? !this.scope.equals(edge.scope) : edge.scope != null) {
                return false;
            }
            return this.optional == edge.optional;
        }

        public int hashCode() {
            int result = this.parent != null ? this.parent.hashCode() : 0;
            result = 31 * result + (this.child != null ? this.child.hashCode() : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            result = 31 * result + (this.optional ? 1 : 0);
            return result;
        }

        public String toString() {
            return "Edge{parent=" + this.parent + ", child=" + this.child + ", scope='" + this.scope + '\'' + ", optional=" + this.optional + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private final String id;
        private final ArrayList<Edge> children = new ArrayList();
        private final ArrayList<Edge> parents = new ArrayList();
        private final Artifact artifact;
        private int roots;

        public Node(String id, Artifact artifact) {
            this.id = id;
            this.artifact = artifact;
        }

        public boolean equals(Object obj) {
            return obj instanceof Node && this.id.equals(((Node)obj).id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return this.id;
        }

        public boolean isHidden() {
            if (DependencyVisualizer.this.hidePoms && this.isExclusivelyType("pom")) {
                return true;
            }
            return DependencyVisualizer.this.hideExternal && this.roots == 0;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            Artifact a = this.artifact;
            StringBuilder sb = new StringBuilder();
            if (!DependencyVisualizer.this.hideGroupId) {
                sb.append(a.getGroupId() + "\\n");
            }
            sb.append(a.getArtifactId());
            if (!DependencyVisualizer.this.hideType && !this.isExclusivelyType("jar")) {
                sb.append("\\n");
                boolean first = true;
                for (String type : this.getTypes()) {
                    if (!first) {
                        sb.append(" | ");
                    }
                    first = false;
                    sb.append(type);
                }
            }
            if (!DependencyVisualizer.this.hideVersion) {
                sb.append("\\n" + a.getVersion());
            }
            return sb.toString();
        }

        public String getColor() {
            if (this.isScope("test")) {
                return "cornflowerblue";
            }
            if (this.isOptional()) {
                return "green";
            }
            if (this.isScope("provided")) {
                return "darkgrey";
            }
            return "black";
        }

        private boolean isScope(String scope) {
            return this.roots == 0 && !this.parents.isEmpty() && this.allMatchScope(this.parents, scope);
        }

        public String getFillColor() {
            if (this.roots > 0) {
                return "#dddddd";
            }
            return "white";
        }

        public String getFontColor() {
            return this.getColor();
        }

        public String getLineStyle() {
            String rc = this.isOptional() ? "dotted" : "solid";
            rc = rc + ",filled";
            return rc;
        }

        public double getFontSize() {
            if (this.roots > 0) {
                return 14.0;
            }
            return 8.0;
        }

        public boolean isOptional() {
            return this.roots == 0 && !this.parents.isEmpty() && this.allMatchOptional(this.parents, true);
        }

        private boolean allMatchScope(ArrayList<Edge> edges, String scope) {
            for (Edge e : edges) {
                if (e.isScope(scope)) continue;
                return false;
            }
            return true;
        }

        private boolean allMatchOptional(ArrayList<Edge> edges, boolean value) {
            for (Edge e : edges) {
                if (e.optional == value) continue;
                return false;
            }
            return true;
        }

        private Set<String> getTypes() {
            LinkedHashSet<String> rc = new LinkedHashSet<String>();
            rc.add(this.artifact.getType() + (this.artifact.getClassifier() == null ? "" : ":" + this.artifact.getClassifier()));
            for (Edge e : this.parents) {
                Artifact artifact = e.dependencyNode.getArtifact();
                rc.add(artifact.getType() + (artifact.getClassifier() == null ? "" : ":" + artifact.getClassifier()));
            }
            return rc;
        }

        private boolean isExclusivelyType(String value) {
            Set<String> types = this.getTypes();
            return types.size() == 1 && types.contains(value);
        }

        public int getRecursiveChildCount() {
            int rc = this.children.size();
            for (Edge child : this.children) {
                int t = child.getRecursiveChildCount();
                if (t <= rc) continue;
                rc = t;
            }
            return rc;
        }
    }
}

