/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.fuin.utils4j.Utils4J;
import org.xml.sax.SAXException;

public final class UnmarshallerBuilder {
    private final Set<XmlAdapter<?, ?>> adapters = new HashSet();
    private final Set<Source> schemaSources = new HashSet<Source>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<Class<?>> classesToBeBound = new HashSet();
    private ValidationEventHandler handler;
    private JAXBContext ctx;
    private Unmarshaller.Listener listener;

    public UnmarshallerBuilder withContext(JAXBContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public UnmarshallerBuilder withListener(Unmarshaller.Listener listener) {
        this.listener = listener;
        return this;
    }

    public UnmarshallerBuilder withHandler(ValidationEventHandler handler) {
        this.handler = handler;
        return this;
    }

    public UnmarshallerBuilder addClassToBeBound(Class<?> clasz) {
        Utils4J.checkNotNull("clasz", clasz);
        this.classesToBeBound.add(clasz);
        return this;
    }

    public UnmarshallerBuilder addClassesToBeBound(Class<?> ... classes) {
        Utils4J.checkNotNull("classes", classes);
        Arrays.asList(classes).forEach(this::addClassToBeBound);
        return this;
    }

    public UnmarshallerBuilder addClassesToBeBound(Collection<Class<?>> classes) {
        Utils4J.checkNotNull("classes", classes);
        classes.forEach(this::addClassToBeBound);
        return this;
    }

    public UnmarshallerBuilder addAdapter(XmlAdapter<?, ?> adapter) {
        Utils4J.checkNotNull("adapter", adapter);
        this.adapters.add(adapter);
        return this;
    }

    public UnmarshallerBuilder addAdapters(XmlAdapter<?, ?> ... adapters) {
        Utils4J.checkNotNull("adapters", adapters);
        Arrays.asList(adapters).forEach(this::addAdapter);
        return this;
    }

    public UnmarshallerBuilder addAdapters(Collection<XmlAdapter<?, ?>> adapters) {
        Utils4J.checkNotNull("adapters", adapters);
        adapters.forEach(this::addAdapter);
        return this;
    }

    public UnmarshallerBuilder addSchema(Source source) {
        Utils4J.checkNotNull("source", source);
        this.schemaSources.add(source);
        return this;
    }

    public UnmarshallerBuilder addSchemas(Source ... sources) {
        Utils4J.checkNotNull("sources", sources);
        Arrays.asList(sources).forEach(this::addSchema);
        return this;
    }

    public UnmarshallerBuilder addSchemas(Collection<Source> sources) {
        Utils4J.checkNotNull("sources", sources);
        sources.forEach(this::addSchema);
        return this;
    }

    public UnmarshallerBuilder addClasspathSchema(String xsdPath) {
        Utils4J.checkNotNull("xsdPath", xsdPath);
        this.addSchema(new StreamSource(this.getClass().getResourceAsStream(xsdPath)));
        return this;
    }

    public UnmarshallerBuilder addClasspathSchemas(String ... xsdPaths) {
        Utils4J.checkNotNull("xsdPaths", xsdPaths);
        Arrays.asList(xsdPaths).forEach(this::addClasspathSchema);
        return this;
    }

    public UnmarshallerBuilder addClasspathSchemas(Collection<String> xsdPaths) {
        Utils4J.checkNotNull("xsdPaths", xsdPaths);
        xsdPaths.forEach(this::addClasspathSchema);
        return this;
    }

    public UnmarshallerBuilder addProperty(String name, Object value) {
        Utils4J.checkNotNull("name", name);
        Utils4J.checkNotNull("value", value);
        this.properties.put(name, value);
        return this;
    }

    private static void setProperties(Unmarshaller unmarshaller, Map<String, Object> map) {
        map.forEach((name, value) -> {
            try {
                unmarshaller.setProperty(name, value);
            }
            catch (PropertyException ex) {
                throw new IllegalArgumentException("Failed to set property '" + name + "' to: " + String.valueOf(value), ex);
            }
        });
    }

    private Schema createSchema() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory.newSchema(this.schemaSources.toArray(new Source[this.schemaSources.size()]));
        }
        catch (SAXException ex) {
            throw new RuntimeException("Failed to create schema", ex);
        }
    }

    private JAXBContext getCtx() {
        if (!this.classesToBeBound.isEmpty()) {
            if (this.ctx != null) {
                throw new IllegalStateException("A JAXBContext (ctx) and a list of classes (classesToBeBound) was provided. You can only use one of them, not both.");
            }
            return UnmarshallerBuilder.createContext(this.classesToBeBound);
        }
        if (this.ctx != null) {
            return this.ctx;
        }
        throw new IllegalStateException("Either the JAXBContext (ctx) or a list of classes (classesToBeBound) must be provided");
    }

    private static Unmarshaller createUnmarshaller(JAXBContext ctx) {
        try {
            return ctx.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to create unmarshaller", ex);
        }
    }

    private static void setEventHandler(Unmarshaller unmarshaller, ValidationEventHandler handler) {
        try {
            unmarshaller.setEventHandler(handler);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to set unmarshaller's event handler", ex);
        }
    }

    private static JAXBContext createContext(Set<Class<?>> classesToBeBound) {
        try {
            return JAXBContext.newInstance((Class[])classesToBeBound.toArray(new Class[classesToBeBound.size()]));
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to create JAXB context with classes: " + String.valueOf(classesToBeBound), ex);
        }
    }

    public Unmarshaller build() {
        Unmarshaller unmarshaller = UnmarshallerBuilder.createUnmarshaller(this.getCtx());
        this.adapters.forEach(arg_0 -> ((Unmarshaller)unmarshaller).setAdapter(arg_0));
        if (this.handler != null) {
            UnmarshallerBuilder.setEventHandler(unmarshaller, this.handler);
        }
        if (!this.schemaSources.isEmpty()) {
            unmarshaller.setSchema(this.createSchema());
        }
        if (this.listener != null) {
            unmarshaller.setListener(this.listener);
        }
        if (!this.properties.isEmpty()) {
            UnmarshallerBuilder.setProperties(unmarshaller, this.properties);
        }
        return unmarshaller;
    }
}

