/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.jandex;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4j.jandex.JandexIndexFileReader;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

public final class JandexUtils {
    private JandexUtils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static boolean indexClassFile(Indexer indexer, List<File> knownFiles, File classFile) {
        if (knownFiles.contains(classFile)) {
            return false;
        }
        knownFiles.add(classFile);
        try (InputStream in = classFile.toURI().toURL().openStream();){
            indexer.index(in);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error indexing file: " + String.valueOf(classFile), ex);
        }
        return true;
    }

    public static Index indexDir(File dir) {
        Indexer indexer = new Indexer();
        JandexUtils.indexDir(indexer, new ArrayList<File>(), dir);
        return indexer.complete();
    }

    public static Index indexDirs(File ... dirs) {
        Indexer indexer = new Indexer();
        ArrayList<File> knownClassFiles = new ArrayList<File>();
        for (File dir : dirs) {
            JandexUtils.indexDir(indexer, knownClassFiles, dir);
        }
        return indexer.complete();
    }

    public static void indexDir(Indexer indexer, List<File> knownFiles, File dir) {
        List<File> classes = Utils4J.pathsFiles(dir.getPath(), Utils4J::classFile);
        for (File file : classes) {
            JandexUtils.indexClassFile(indexer, knownFiles, file);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean indexJar(Indexer indexer, List<File> knownFiles, File jarFile) {
        if (knownFiles.contains(jarFile)) {
            return false;
        }
        knownFiles.add(jarFile);
        try (JarFile jar = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                try {
                    InputStream stream = jar.getInputStream(entry);
                    try {
                        indexer.index(stream);
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error indexing " + entry.getName() + " in " + String.valueOf(jarFile), ex);
                    return true;
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error indexing " + String.valueOf(jarFile), ex);
        }
    }

    public static void indexClasspath(Indexer indexer, List<File> knownFiles) {
        JandexUtils.indexFiles(Utils4J.classpathFiles(), indexer, knownFiles);
    }

    public static void indexFiles(List<File> files, Indexer indexer, List<File> knownFiles) {
        for (File file : files) {
            if (Utils4J.nonJreJarFile(file)) {
                JandexUtils.indexJar(indexer, knownFiles, file);
                continue;
            }
            if (!file.isDirectory() || file.getName().startsWith(".")) continue;
            JandexUtils.indexDir(indexer, knownFiles, file);
        }
        for (File file : Utils4J.classpathFiles(Utils4J::nonJreJarFile)) {
            JandexUtils.indexJar(indexer, knownFiles, file);
        }
        for (File file : Utils4J.classpathFiles(Utils4J::classFile)) {
            JandexUtils.indexClassFile(indexer, knownFiles, file);
        }
    }

    public static Class<?> loadClass(DotName name) {
        return Utils4J.loadClass(name.toString());
    }

    public static <T> List<Class<? extends T>> findImplementors(Class<T> intf, File ... classesDirs) {
        ArrayList<Object> indexes = new ArrayList<Object>();
        indexes.add(new JandexIndexFileReader.Builder().addDefaultResource().build().loadR());
        indexes.add(JandexUtils.indexDirs(classesDirs));
        return JandexUtils.findImplementors(intf, (IndexView)CompositeIndex.create(indexes));
    }

    public static <T> List<Class<? extends T>> findImplementors(Class<T> intf, IndexView index) {
        ArrayList<Class<T>> implementors = new ArrayList<Class<T>>();
        Collection implementingClasses = index.getAllKnownImplementors(DotName.createSimple(intf));
        for (ClassInfo classInfo : implementingClasses) {
            if (Modifier.isAbstract(classInfo.flags()) || Modifier.isInterface(classInfo.flags())) continue;
            Class<?> implementor = JandexUtils.loadClass(classInfo.name());
            implementors.add(implementor);
        }
        return implementors;
    }
}

