/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.jandex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;

public final class JandexIndexFileReader {
    private final List<File> files = new ArrayList<File>();
    private final List<String> resources = new ArrayList<String>();

    private JandexIndexFileReader() {
    }

    public IndexView load() throws IOException {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        for (File file : this.files) {
            indexes.add(this.loadFile(file));
        }
        for (String resource : this.resources) {
            indexes.add(this.loadResources(resource));
        }
        return CompositeIndex.create(indexes);
    }

    public IndexView loadR() {
        try {
            return this.load();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read index files or resources", ex);
        }
    }

    private IndexView loadFile(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            Index index = new IndexReader((InputStream)input).read();
            return index;
        }
    }

    private IndexView loadResources(String indexFilePathAndName) throws IOException {
        Enumeration<URL> enu = Thread.currentThread().getContextClassLoader().getResources(indexFilePathAndName);
        ArrayList<Index> indexes = new ArrayList<Index>();
        ArrayList<URL> urlList = Collections.list(enu);
        for (URL url : urlList) {
            InputStream input = url.openStream();
            try {
                indexes.add(new IndexReader(input).read());
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        return CompositeIndex.create(indexes);
    }

    public static final class Builder {
        private JandexIndexFileReader delegate = new JandexIndexFileReader();

        public Builder addFiles(File ... files) {
            return this.addFiles(Arrays.asList(files));
        }

        public Builder addFiles(List<File> files) {
            for (File file : Objects.requireNonNull(files, "files==null")) {
                if (!file.exists()) {
                    throw new IllegalStateException("Index file does not exist: " + String.valueOf(file));
                }
                if (!file.isFile()) {
                    throw new IllegalStateException("No file: " + String.valueOf(file));
                }
                this.delegate.files.add(Objects.requireNonNull(file, "file==null"));
            }
            return this;
        }

        public Builder addDefaultResource() {
            this.addResources("META-INF/jandex.idx");
            return this;
        }

        public Builder addResources(String ... resources) {
            return this.addResources(Arrays.asList(resources));
        }

        public Builder addResources(List<String> resources) {
            for (String resource : Objects.requireNonNull(resources, "resources==null")) {
                this.delegate.resources.add(Objects.requireNonNull(resource, "resource==null"));
            }
            return this;
        }

        public JandexIndexFileReader build() {
            if (this.delegate.resources.isEmpty() && this.delegate.files.isEmpty()) {
                this.addDefaultResource();
            }
            JandexIndexFileReader tmp = this.delegate;
            this.delegate = new JandexIndexFileReader();
            return tmp;
        }
    }
}

