/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fuin.utils4j.Utils4J;

public final class VariableResolver {
    private final Map<String, String> unresolved;
    private final Map<String, Integer> depth;
    private final Map<String, String> resolved;

    public VariableResolver(Map<String, String> unresolved) {
        this.unresolved = unresolved == null ? new HashMap<String, String>() : new HashMap<String, String>(unresolved);
        this.depth = new HashMap<String, Integer>();
        this.resolved = new HashMap<String, String>();
        this.resolve();
    }

    private void resolve() {
        int max = 0;
        for (String name : this.unresolved.keySet()) {
            String value;
            int d = this.resolve(name, value = this.unresolved.get(name), new ArrayList<String>());
            if (d <= max) continue;
            max = d;
        }
        for (int d = 0; d <= max; ++d) {
            for (String name : this.unresolved.keySet()) {
                String value = this.unresolved.get(name);
                if (this.depth.get(name) != d) continue;
                this.resolved.put(name, Utils4J.replaceCrLfTab(Utils4J.replaceVars(value, this.resolved)));
            }
        }
    }

    private Integer resolve(String name, String value, List<String> path) {
        if (path.contains(name)) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = path.iterator();
            while (it.hasNext()) {
                sb.append(it.next() + " > ");
            }
            sb.append(name);
            throw new IllegalStateException("Cycle: " + String.valueOf(sb));
        }
        Integer d = this.depth.get(name);
        if (d == null) {
            Set<String> refs = VariableResolver.references(value);
            if (refs.isEmpty()) {
                d = 0;
            } else {
                for (String refName : refs) {
                    String refValue = this.unresolved.get(refName);
                    d = 1 + this.resolve(refName, refValue, this.add(path, name));
                }
            }
            this.depth.put(name, d);
        }
        return d;
    }

    private List<String> add(List<String> list, String name) {
        ArrayList<String> newList = new ArrayList<String>(list);
        newList.add(name);
        return newList;
    }

    public final Map<String, Integer> getDepth() {
        return this.depth;
    }

    public final Map<String, String> getResolved() {
        return this.resolved;
    }

    public final Map<String, String> getUnresolved() {
        return this.unresolved;
    }

    public static Set<String> references(String value) {
        HashSet<String> names = new HashSet<String>();
        if (value == null || value.length() == 0) {
            return names;
        }
        int end = -1;
        int from = 0;
        int start = -1;
        while ((start = value.indexOf("${", from)) > -1) {
            end = value.indexOf(125, start + 1);
            if (end == -1) {
                from = value.length();
                continue;
            }
            names.add(value.substring(start + 2, end));
            from = end + 1;
        }
        return names;
    }
}

