/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.jaxb;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.fuin.utils4j.Utils4J;
import org.xml.sax.SAXException;

public class MarshallerBuilder {
    private final Set<XmlAdapter<?, ?>> adapters = new HashSet();
    private final Set<Source> schemaSources = new HashSet<Source>();
    private final Set<Class<?>> classesToBeBound = new HashSet();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private Marshaller.Listener listener;
    private ValidationEventHandler handler;
    private JAXBContext ctx;

    public MarshallerBuilder withContext(JAXBContext ctx) {
        this.ctx = ctx;
        return this;
    }

    public MarshallerBuilder withListener(Marshaller.Listener listener) {
        this.listener = listener;
        return this;
    }

    public MarshallerBuilder withHandler(ValidationEventHandler handler) {
        this.handler = handler;
        return this;
    }

    public MarshallerBuilder addClassToBeBound(Class<?> clasz) {
        Utils4J.checkNotNull("clasz", clasz);
        this.classesToBeBound.add(clasz);
        return this;
    }

    public MarshallerBuilder addClassesToBeBound(Class<?> ... classes) {
        Utils4J.checkNotNull("classes", classes);
        Arrays.asList(classes).forEach(this::addClassToBeBound);
        return this;
    }

    public MarshallerBuilder addClassesToBeBound(Collection<Class<?>> classes) {
        Utils4J.checkNotNull("classes", classes);
        classes.forEach(this::addClassToBeBound);
        return this;
    }

    public MarshallerBuilder addAdapter(XmlAdapter<?, ?> adapter) {
        Utils4J.checkNotNull("adapter", adapter);
        this.adapters.add(adapter);
        return this;
    }

    public MarshallerBuilder addAdapters(XmlAdapter<?, ?> ... adapters) {
        Utils4J.checkNotNull("adapters", adapters);
        Arrays.asList(adapters).forEach(this::addAdapter);
        return this;
    }

    public MarshallerBuilder addAdapters(Collection<XmlAdapter<?, ?>> adapters) {
        Utils4J.checkNotNull("adapters", adapters);
        adapters.forEach(this::addAdapter);
        return this;
    }

    public MarshallerBuilder addSchema(Source source) {
        Utils4J.checkNotNull("source", source);
        this.schemaSources.add(source);
        return this;
    }

    public MarshallerBuilder addSchemas(Source ... sources) {
        Utils4J.checkNotNull("sources", sources);
        Arrays.asList(sources).forEach(this::addSchema);
        return this;
    }

    public MarshallerBuilder addSchemas(Collection<Source> sources) {
        Utils4J.checkNotNull("sources", sources);
        sources.forEach(this::addSchema);
        return this;
    }

    public MarshallerBuilder addClasspathSchema(String xsdPath) {
        Utils4J.checkNotNull("xsdPath", xsdPath);
        this.addSchema(new StreamSource(this.getClass().getResourceAsStream(xsdPath)));
        return this;
    }

    public MarshallerBuilder addClasspathSchemas(String ... xsdPaths) {
        Utils4J.checkNotNull("xsdPaths", xsdPaths);
        Arrays.asList(xsdPaths).forEach(this::addClasspathSchema);
        return this;
    }

    public MarshallerBuilder addClasspathSchemas(Collection<String> xsdPaths) {
        Utils4J.checkNotNull("xsdPaths", xsdPaths);
        xsdPaths.forEach(this::addClasspathSchema);
        return this;
    }

    public MarshallerBuilder prettyPrint() {
        this.addProperty("jaxb.formatted.output", true);
        return this;
    }

    public MarshallerBuilder addProperty(String name, Object value) {
        Utils4J.checkNotNull("name", name);
        Utils4J.checkNotNull("value", value);
        this.properties.put(name, value);
        return this;
    }

    private static void setProperties(Marshaller marshaller, Map<String, Object> map) {
        map.forEach((name, value) -> {
            try {
                marshaller.setProperty(name, value);
            }
            catch (PropertyException ex) {
                throw new IllegalArgumentException("Failed to set property '" + name + "' to: " + String.valueOf(value), ex);
            }
        });
    }

    private Schema createSchema() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory.newSchema(this.schemaSources.toArray(new Source[this.schemaSources.size()]));
        }
        catch (SAXException ex) {
            throw new RuntimeException("Failed to create schema", ex);
        }
    }

    private JAXBContext getCtx() {
        if (!this.classesToBeBound.isEmpty()) {
            if (this.ctx != null) {
                throw new IllegalStateException("A JAXBContext (ctx) and a list of classes (classesToBeBound) was provided. You can only use one of them, not both.");
            }
            return MarshallerBuilder.createContext(this.classesToBeBound);
        }
        if (this.ctx != null) {
            return this.ctx;
        }
        throw new IllegalStateException("Either the JAXBContext (ctx) or a list of classes (classesToBeBound) must be provided");
    }

    private static Marshaller createMarshaller(JAXBContext ctx) {
        try {
            return ctx.createMarshaller();
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to create marshaller", ex);
        }
    }

    private static void setEventHandler(Marshaller marshaller, ValidationEventHandler handler) {
        try {
            marshaller.setEventHandler(handler);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to set marshaller's event handler", ex);
        }
    }

    private static JAXBContext createContext(Set<Class<?>> classesToBeBound) {
        try {
            return JAXBContext.newInstance((Class[])classesToBeBound.toArray(new Class[classesToBeBound.size()]));
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to create JAXB context with classes: " + String.valueOf(classesToBeBound), ex);
        }
    }

    public Marshaller build() {
        Marshaller marshaller = MarshallerBuilder.createMarshaller(this.getCtx());
        this.adapters.forEach(arg_0 -> ((Marshaller)marshaller).setAdapter(arg_0));
        if (this.handler != null) {
            MarshallerBuilder.setEventHandler(marshaller, this.handler);
        }
        if (!this.schemaSources.isEmpty()) {
            marshaller.setSchema(this.createSchema());
        }
        if (!this.properties.isEmpty()) {
            MarshallerBuilder.setProperties(marshaller, this.properties);
        }
        if (this.listener != null) {
            marshaller.setListener(this.listener);
        }
        return marshaller;
    }
}

