/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.filter;

import java.util.regex.Pattern;
import org.fuin.utils4j.filter.Filter;

public class RegExprFilter
implements Filter {
    public static final int MATCHES = 0;
    public static final int LOOKING_AT = 1;
    public static final int FIND = 2;
    private static final String[] TYPES = new String[]{"matches", "lookingAt", "find"};
    private Pattern p;
    private String pattern;
    private int type = 1;

    public RegExprFilter(String pattern) {
        this.pattern = pattern;
        this.p = Pattern.compile(pattern);
    }

    @Override
    public final boolean complies(Object obj) {
        String str = obj.toString();
        if (this.type == 0) {
            return this.p.matcher(str).matches();
        }
        if (this.type == 1) {
            return this.p.matcher(str).lookingAt();
        }
        if (this.type == 2) {
            return this.p.matcher(str).find();
        }
        throw new IllegalStateException("Unknown 'type': " + this.type);
    }

    public final String getPattern() {
        return this.pattern;
    }

    public final String toString() {
        return " = RegExpr[" + this.pattern + "]";
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int type) {
        this.type = type;
    }

    public final String getTypeName() {
        if (this.type == 1) {
            return null;
        }
        return TYPES[this.type];
    }

    public final void setTypeName(String typeName) {
        if (typeName == null) {
            this.type = 1;
        } else if (typeName.equalsIgnoreCase(TYPES[0])) {
            this.type = 0;
        } else if (typeName.equalsIgnoreCase(TYPES[1])) {
            this.type = 1;
        } else if (typeName.equalsIgnoreCase(TYPES[2])) {
            this.type = 2;
        }
    }
}

