/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.fuin.utils4j.Utils4J;

public final class PropertiesUtils {
    private PropertiesUtils() {
        throw new UnsupportedOperationException("This utility class is not intended to be instanciated!");
    }

    public static Properties loadProperties(Class<?> clasz, String filename) {
        Utils4J.checkNotNull("clasz", clasz);
        Utils4J.checkNotNull("filename", filename);
        String path = Utils4J.getPackagePath(clasz);
        String resPath = path + "/" + filename;
        return PropertiesUtils.loadProperties(clasz.getClassLoader(), resPath);
    }

    public static Properties loadProperties(ClassLoader loader, String resource) {
        Utils4J.checkNotNull("loader", loader);
        Utils4J.checkNotNull("resource", resource);
        Properties props = new Properties();
        try (InputStream inStream = loader.getResourceAsStream(resource);){
            if (inStream == null) {
                throw new IllegalArgumentException("Resource '" + resource + "' not found!");
            }
            props.load(inStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return props;
    }

    public static Properties loadProperties(File file) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkValidFile(file);
        Properties props = new Properties();
        try (FileInputStream inStream = new FileInputStream(file);){
            props.load(inStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return props;
    }

    public static void saveProperties(File file, Properties props, String comment) {
        Utils4J.checkNotNull("file", file);
        Utils4J.checkNotNull("props", props);
        if (!file.getParentFile().exists()) {
            throw new IllegalArgumentException("The parent directory '" + String.valueOf(file.getParentFile()) + "' does not exist [file='" + String.valueOf(file) + "']!");
        }
        try (FileOutputStream outStream = new FileOutputStream(file);){
            props.store(outStream, comment);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Properties loadProperties(URL baseUrl, String filename) {
        return PropertiesUtils.loadProperties(Utils4J.createUrl(baseUrl, "", filename));
    }

    public static Properties loadProperties(URL fileURL) {
        Utils4J.checkNotNull("fileURL", fileURL);
        Properties props = new Properties();
        try (InputStream inStream = fileURL.openStream();){
            props.load(inStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return props;
    }

    public static Properties loadProperties(String baseUrl, String filename) {
        Utils4J.checkNotNull("baseUrl", baseUrl);
        Utils4J.checkNotNull("filename", filename);
        try {
            URL url = new URL(baseUrl);
            return PropertiesUtils.loadProperties(url, filename);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("The argument 'srcUrl' is not a valid URL [" + baseUrl + "]!", ex);
        }
    }
}

