/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fuin.utils4j.TestCommand;
import org.fuin.utils4j.Utils4J;

public final class MultipleCommands<CONTEXT>
implements TestCommand<CONTEXT> {
    private final List<TestCommand<CONTEXT>> commands;

    public MultipleCommands() {
        this.commands = new ArrayList<TestCommand<CONTEXT>>();
    }

    @SafeVarargs
    public MultipleCommands(TestCommand<CONTEXT> ... commands) {
        this(Arrays.asList(commands));
    }

    public MultipleCommands(List<? extends TestCommand<CONTEXT>> commands) {
        Utils4J.checkNotNull("commands", commands);
        this.commands = new ArrayList<TestCommand<CONTEXT>>(commands);
    }

    public void add(TestCommand<CONTEXT> command) {
        this.commands.add(command);
    }

    @Override
    public void init(CONTEXT context) {
        for (TestCommand<CONTEXT> command : this.commands) {
            command.init(context);
        }
    }

    @Override
    public final void execute() {
        for (TestCommand<CONTEXT> command : this.commands) {
            command.execute();
        }
    }

    @Override
    public final boolean isSuccessful() {
        for (TestCommand<CONTEXT> command : this.commands) {
            if (command.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String getFailureDescription() {
        StringBuilder sb = new StringBuilder();
        for (TestCommand<CONTEXT> command : this.commands) {
            if (command.isSuccessful()) continue;
            sb.append(command.getFailureDescription());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public final void verify() {
        if (!this.isSuccessful()) {
            throw new RuntimeException("There was at least one failure:\n" + this.getFailureDescription());
        }
    }
}

