/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j.fileprocessor;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.fuin.utils4j.fileprocessor.FileHandler;
import org.fuin.utils4j.fileprocessor.FileHandlerResult;
import org.fuin.utils4j.fileprocessor.FileOrder;

public final class FileProcessor {
    private final FileHandler handler;
    private final FileOrder order;
    private final boolean sort;

    public FileProcessor(FileHandler handler) {
        this(handler, FileOrder.DEFAULT, false);
    }

    public FileProcessor(FileHandler handler, FileOrder order) {
        this(handler, order, false);
    }

    public FileProcessor(FileHandler handler, FileOrder order, boolean sort) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 'handler' cannot be NULL");
        }
        if (order == null) {
            throw new IllegalArgumentException("Argument 'order' cannot be NULL");
        }
        this.handler = handler;
        this.order = order;
        this.sort = sort;
    }

    public final void process(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 'file' cannot be NULL");
        }
        if (file.isFile()) {
            this.handler.handleFile(file);
        } else {
            this.processDir(file);
        }
    }

    private FileHandlerResult processDir(File dir) {
        FileHandlerResult dirResult = this.handler.handleFile(dir);
        if (dirResult == FileHandlerResult.STOP) {
            return FileHandlerResult.STOP;
        }
        if (dirResult == FileHandlerResult.SKIP_ALL) {
            return FileHandlerResult.CONTINUE;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            List<File> sortedFiles = this.asList(files);
            for (int i = 0; i < sortedFiles.size(); ++i) {
                File file = sortedFiles.get(i);
                FileHandlerResult result = FileHandlerResult.CONTINUE;
                if (file.isDirectory() && dirResult != FileHandlerResult.SKIP_SUBDIRS) {
                    result = this.processDir(file);
                } else if (file.isFile() && dirResult != FileHandlerResult.SKIP_FILES) {
                    result = this.handler.handleFile(file);
                }
                if (result == FileHandlerResult.STOP) {
                    return FileHandlerResult.STOP;
                }
                if (result != FileHandlerResult.SKIP_ALL) continue;
                return FileHandlerResult.CONTINUE;
            }
        }
        return FileHandlerResult.CONTINUE;
    }

    private List<File> asList(File[] files) {
        if (this.order == FileOrder.DEFAULT) {
            return this.defaultList(files);
        }
        return this.orderedList(files);
    }

    private List<File> orderedList(File[] files) {
        ArrayList<File> list;
        ArrayList<File> dirList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                dirList.add(file);
                continue;
            }
            fileList.add(file);
        }
        if (this.sort) {
            Collections.sort(dirList, new FilenameComparator());
            Collections.sort(fileList, new FilenameComparator());
        }
        if (this.order == FileOrder.DIR_FIRST) {
            list = new ArrayList<File>(dirList);
            list.addAll(fileList);
        } else {
            list = new ArrayList(fileList);
            list.addAll(dirList);
        }
        return list;
    }

    private List<File> defaultList(File[] files) {
        ArrayList<File> list = new ArrayList<File>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            list.add(file);
        }
        if (this.sort) {
            Collections.sort(list, new FilenameComparator());
        }
        return list;
    }

    private static class FilenameComparator
    implements Comparator<File> {
        private FilenameComparator() {
        }

        @Override
        public final int compare(File f1, File f2) {
            return f1.getName().compareTo(f2.getName());
        }
    }
}

