/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.stream.XMLStreamWriter;

public final class JaxbUtils {
    private static final String ERROR_MARSHALLING_TEST_DATA = "Error marshalling test data";
    public static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";

    private JaxbUtils() {
        throw new UnsupportedOperationException("It's not allowed to create an instance of a utility class");
    }

    public static <T> String marshal(T data, Class<?> ... classesToBeBound) {
        return JaxbUtils.marshal(data, null, classesToBeBound);
    }

    public static <T> String marshal(T data, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        if (data == null) {
            return null;
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound);
            return JaxbUtils.marshal(ctx, data, adapters);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }

    public static <T> String marshal(JAXBContext ctx, T data) {
        return JaxbUtils.marshal(ctx, data, null);
    }

    public static <T> String marshal(JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters) {
        if (data == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        JaxbUtils.marshal(ctx, data, adapters, writer);
        return writer.toString();
    }

    public static <T> void marshal(JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters, Writer writer) {
        if (data == null) {
            return;
        }
        try {
            Marshaller marshaller = ctx.createMarshaller();
            if (adapters != null) {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    marshaller.setAdapter(adapter);
                }
            }
            marshaller.marshal(data, writer);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }

    public static <T> void marshal(JAXBContext ctx, T data, XmlAdapter<?, ?>[] adapters, XMLStreamWriter writer) {
        if (data == null) {
            return;
        }
        try {
            Marshaller marshaller = ctx.createMarshaller();
            if (adapters != null) {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    marshaller.setAdapter(adapter);
                }
            }
            marshaller.marshal(data, writer);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ERROR_MARSHALLING_TEST_DATA, ex);
        }
    }

    public static <T> T unmarshal(String xmlData, Class<?> ... classesToBeBound) {
        return JaxbUtils.unmarshal(xmlData, null, classesToBeBound);
    }

    public static <T> T unmarshal(String xmlData, XmlAdapter<?, ?>[] adapters, Class<?> ... classesToBeBound) {
        if (xmlData == null) {
            return null;
        }
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound);
            return JaxbUtils.unmarshal(ctx, xmlData, adapters);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error unmarshalling test data", ex);
        }
    }

    public static <T> T unmarshal(JAXBContext ctx, String xmlData, XmlAdapter<?, ?>[] adapters) {
        if (xmlData == null) {
            return null;
        }
        return JaxbUtils.unmarshal(ctx, new StringReader(xmlData), adapters);
    }

    public static <T> T unmarshal(JAXBContext ctx, Reader reader, XmlAdapter<?, ?>[] adapters) {
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            if (adapters != null) {
                for (XmlAdapter<?, ?> adapter : adapters) {
                    unmarshaller.setAdapter(adapter);
                }
            }
            unmarshaller.setEventHandler(event -> {
                if (event.getSeverity() > 0) {
                    Throwable ex = event.getLinkedException();
                    if (ex == null) {
                        throw new RuntimeException("Error unmarshalling the data: " + event.getMessage());
                    }
                    throw new RuntimeException("Error unmarshalling the data", ex);
                }
                return true;
            });
            return (T)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Error unmarshalling test data", ex);
        }
    }
}

