/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.jsonb;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class JsonbProvider
implements AutoCloseable {
    private final JsonbConfig config;
    private Jsonb jsonb;

    public JsonbProvider(JsonbConfig config) {
        this.config = Objects.requireNonNull(config, "config==null");
    }

    public Jsonb jsonb() {
        if (this.jsonb == null) {
            this.jsonb = JsonbBuilder.create((JsonbConfig)this.config);
        }
        return this.jsonb;
    }

    @Override
    public void close() {
        if (this.jsonb != null) {
            try {
                this.jsonb.close();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to close JSON-B instance", ex);
            }
        }
    }
}

