/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.objects4j.vo;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.Immutable;
import org.fuin.objects4j.common.Nullable;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;
import org.fuin.objects4j.vo.AbstractStringValueObject;
import org.fuin.objects4j.vo.Hour;
import org.fuin.objects4j.vo.HourRangeConverter;
import org.fuin.objects4j.vo.HourRangeStr;

@ShortLabel(value="HH-HH")
@Label(value="From-To Hour")
@Tooltip(value="From hourRange of day until hourRange of day")
@Prompt(value="00:00-24:00")
@XmlJavaTypeAdapter(value=HourRangeConverter.class)
@Immutable
public final class HourRange
extends AbstractStringValueObject {
    private static final long serialVersionUID = 1000L;
    @NotNull
    private Hour from;
    @NotNull
    private Hour to;

    protected HourRange() {
    }

    public HourRange(@NotNull @HourRangeStr String hourRange) {
        Contract.requireArgNotEmpty("hourRange", hourRange);
        HourRange.requireArgValid("hourRange", hourRange);
        this.from = new Hour(hourRange.substring(0, 5));
        this.to = new Hour(hourRange.substring(6));
        if (this.from.equals(this.to)) {
            throw new ConstraintViolationException("The argument 'from' of the hour range cannot be equal 'to': '" + hourRange + "'");
        }
        if (this.from.equals(new Hour(24, 0))) {
            throw new ConstraintViolationException("The argument 'from' of the hour range cannot be '24:00'");
        }
        if (this.to.equals(new Hour(0, 0))) {
            throw new ConstraintViolationException("The argument 'to' of the hour range cannot be '00:00'");
        }
    }

    public HourRange(@NotNull Hour from, @NotNull Hour to) {
        Contract.requireArgNotNull("from", from);
        Contract.requireArgNotNull("to", to);
        this.from = from;
        this.to = to;
        if (from.equals(to)) {
            throw new ConstraintViolationException("The argument 'from' of the hour range cannot be equal 'to': " + from);
        }
        if (from.equals(new Hour(24, 0))) {
            throw new ConstraintViolationException("The argument 'from' of the hour range cannot be '24:00'");
        }
        if (to.equals(new Hour(0, 0))) {
            throw new ConstraintViolationException("The argument 'to' of the hour range cannot be '00:00'");
        }
    }

    public final Hour getFrom() {
        return this.from;
    }

    public final Hour getTo() {
        return this.to;
    }

    @Override
    @NotEmpty
    public final String asBaseType() {
        return this.from + "-" + this.to;
    }

    public final BitSet toMinutes() {
        HourRange.ensureSingleDayOnly(this);
        BitSet minutes = new BitSet(1440);
        for (int i = this.from.toMinutes(); i < this.to.toMinutes(); ++i) {
            minutes.set(i);
        }
        return minutes;
    }

    private static void ensureSingleDayOnly(HourRange range) {
        List<HourRange> list = range.normalize();
        if (list.size() > 1) {
            throw new IllegalArgumentException("Cannot convert an hour range to minutes that spans two days (" + list + ") - Please use 'normalize()' method and pass then the hour range per day to this method!");
        }
    }

    public final String toString() {
        return this.asBaseType();
    }

    public final boolean overlaps(@NotNull HourRange other) {
        Contract.requireArgNotNull("other", other);
        if (this.equals(other)) {
            return true;
        }
        int otherFrom = other.from.toMinutes();
        int thisFrom = this.from.toMinutes();
        int otherTo = other.to.toMinutes();
        int thisTo = this.to.toMinutes();
        if (otherFrom <= thisTo && otherFrom >= thisFrom) {
            return true;
        }
        if (otherTo <= thisTo && otherTo >= thisFrom) {
            return true;
        }
        if (thisFrom <= otherTo && thisFrom >= otherFrom) {
            return true;
        }
        return thisTo <= otherTo && thisTo >= otherFrom;
    }

    public final List<HourRange> normalize() {
        ArrayList<HourRange> ranges = new ArrayList<HourRange>();
        if (this.from.toMinutes() > this.to.toMinutes()) {
            ranges.add(new HourRange(this.from, new Hour(24, 0)));
            ranges.add(new HourRange(new Hour(0, 0), this.to));
        } else {
            ranges.add(this);
        }
        return ranges;
    }

    public final int getOpenMinutes() {
        HourRange hr = this.normalize().get(0);
        return hr.to.toMinutes() - hr.from.toMinutes();
    }

    public final int getClosedMinutes() {
        return 1440 - this.getOpenMinutes();
    }

    public HourRange joinWithNextDay(@NotNull HourRange other) {
        Contract.requireArgNotNull("other", other);
        if (!this.to.equals(new Hour(24, 0))) {
            throw new ConstraintViolationException("The 'to' hour value of this instance is not '24:00', but was: '" + this.to + "'");
        }
        if (!other.from.equals(new Hour(0, 0))) {
            throw new ConstraintViolationException("The 'from' hour value of the other instance is not '00:00', but was: '" + other.from + "'");
        }
        int thisClosedMinutes = this.getClosedMinutes();
        int otherOpenMinutes = other.getOpenMinutes();
        if (otherOpenMinutes > thisClosedMinutes) {
            throw new ConstraintViolationException("The hour range of the other instance cannot be greater than hours not used by this instance: this='" + this + "', other='" + other + "'");
        }
        if (this.from.equals(other.to)) {
            return new HourRange("00:00-24:00");
        }
        return new HourRange(this.from, other.to);
    }

    public static boolean isValid(@Nullable String hourRange) {
        if (hourRange == null) {
            return true;
        }
        int p = hourRange.indexOf(45);
        if (p != 5) {
            return false;
        }
        String fromStr = hourRange.substring(0, 5);
        String toStr = hourRange.substring(6);
        if (!Hour.isValid(fromStr) || !Hour.isValid(toStr)) {
            return false;
        }
        Hour from = new Hour(fromStr);
        Hour to = new Hour(toStr);
        if (from.equals(to)) {
            return false;
        }
        if (from.equals(new Hour(24, 0))) {
            return false;
        }
        return !to.equals(new Hour(0, 0));
    }

    @Nullable
    public static HourRange valueOf(@Nullable String str) {
        if (str == null) {
            return null;
        }
        return new HourRange(str);
    }

    public static void requireArgValid(@NotNull String name, @NotNull String value) throws ConstraintViolationException {
        if (!HourRange.isValid(value)) {
            throw new ConstraintViolationException("The argument '" + name + "' does not represent a valid hour range like '00:00-24:00' or '06:00-21:00': '" + value + "'");
        }
    }
}

